/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.singlestore;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Calendar;
import org.apache.beam.sdk.io.singlestore.SingleStoreDefaultRowMapper;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SingleStoreDefaultRowMapperTest {
    @Test
    public void testEmptyRow() throws Exception {
        com.singlestore.jdbc.client.result.ResultSetMetaData md = (com.singlestore.jdbc.client.result.ResultSetMetaData)Mockito.mock(com.singlestore.jdbc.client.result.ResultSetMetaData.class);
        Mockito.when((Object)md.getColumnCount()).thenReturn((Object)0);
        ResultSet res = (ResultSet)Mockito.mock(ResultSet.class);
        SingleStoreDefaultRowMapper mapper = new SingleStoreDefaultRowMapper();
        mapper.init((ResultSetMetaData)md);
        Schema s = mapper.getCoder().getSchema();
        Row r = mapper.mapRow(res);
        Assert.assertEquals((long)0L, (long)s.getFieldCount());
        Assert.assertEquals((long)0L, (long)r.getFieldCount());
    }

    @Test
    public void testAllDataTypes() throws Exception {
        int i;
        com.singlestore.jdbc.client.result.ResultSetMetaData md = (com.singlestore.jdbc.client.result.ResultSetMetaData)Mockito.mock(com.singlestore.jdbc.client.result.ResultSetMetaData.class);
        Mockito.when((Object)md.getColumnCount()).thenReturn((Object)17);
        Mockito.when((Object)md.getColumnType(1)).thenReturn((Object)-7);
        Mockito.when((Object)md.getColumnType(2)).thenReturn((Object)-6);
        Mockito.when((Object)md.getColumnType(3)).thenReturn((Object)5);
        Mockito.when((Object)md.getColumnType(4)).thenReturn((Object)4);
        Mockito.when((Object)md.getColumnType(5)).thenReturn((Object)-5);
        Mockito.when((Object)md.getColumnType(6)).thenReturn((Object)7);
        Mockito.when((Object)md.getColumnType(7)).thenReturn((Object)8);
        Mockito.when((Object)md.getColumnType(8)).thenReturn((Object)3);
        Mockito.when((Object)md.getColumnType(9)).thenReturn((Object)93);
        Mockito.when((Object)md.getColumnType(10)).thenReturn((Object)91);
        Mockito.when((Object)md.getColumnType(11)).thenReturn((Object)92);
        Mockito.when((Object)md.getColumnType(12)).thenReturn((Object)-4);
        Mockito.when((Object)md.getColumnType(13)).thenReturn((Object)-3);
        Mockito.when((Object)md.getColumnType(14)).thenReturn((Object)-2);
        Mockito.when((Object)md.getColumnType(15)).thenReturn((Object)-1);
        Mockito.when((Object)md.getColumnType(16)).thenReturn((Object)12);
        Mockito.when((Object)md.getColumnType(17)).thenReturn((Object)1);
        for (i = 12; i <= 17; ++i) {
            Mockito.when((Object)md.getPrecision(i)).thenReturn((Object)10);
        }
        for (i = 1; i <= md.getColumnCount(); ++i) {
            Mockito.when((Object)md.getColumnLabel(i)).thenReturn((Object)("c" + i));
            Mockito.when((Object)md.isNullable(i)).thenReturn((Object)0);
        }
        ResultSet res = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)res.getBoolean(1)).thenReturn((Object)true);
        Mockito.when((Object)res.getByte(2)).thenReturn((Object)10);
        Mockito.when((Object)res.getShort(3)).thenReturn((Object)10);
        Mockito.when((Object)res.getInt(4)).thenReturn((Object)10);
        Mockito.when((Object)res.getLong(5)).thenReturn((Object)10L);
        Mockito.when((Object)Float.valueOf(res.getFloat(6))).thenReturn((Object)Float.valueOf(10.1f));
        Mockito.when((Object)res.getDouble(7)).thenReturn((Object)10.1);
        Mockito.when((Object)res.getBigDecimal(8)).thenReturn((Object)new BigDecimal("100.100"));
        Mockito.when((Object)res.getTimestamp(Mockito.eq((int)9), (Calendar)Mockito.any())).thenReturn((Object)Timestamp.valueOf("2022-10-10 10:10:10"));
        Mockito.when((Object)res.getObject(10, LocalDate.class)).thenReturn((Object)LocalDate.of(2022, 10, 10));
        Mockito.when((Object)res.getTime(Mockito.eq((int)11), (Calendar)Mockito.any())).thenReturn((Object)Time.valueOf("10:10:10"));
        Mockito.when((Object)res.getBytes(12)).thenReturn((Object)"asd".getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)res.getBytes(13)).thenReturn((Object)"asd".getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)res.getBytes(14)).thenReturn((Object)"asd\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)res.getString(15)).thenReturn((Object)"asd");
        Mockito.when((Object)res.getString(16)).thenReturn((Object)"asd");
        Mockito.when((Object)res.getString(17)).thenReturn((Object)"asd");
        Mockito.when((Object)res.wasNull()).thenReturn((Object)false);
        SingleStoreDefaultRowMapper mapper = new SingleStoreDefaultRowMapper();
        mapper.init((ResultSetMetaData)md);
        Schema s = mapper.getCoder().getSchema();
        Row r = mapper.mapRow(res);
        Assert.assertEquals((long)17L, (long)s.getFieldCount());
        for (int i2 = 0; i2 < s.getFieldCount(); ++i2) {
            Assert.assertEquals((Object)("c" + (i2 + 1)), (Object)s.getField(i2).getName());
        }
        Assert.assertEquals((Object)Schema.FieldType.BOOLEAN, (Object)s.getField(0).getType());
        Assert.assertEquals((Object)Schema.FieldType.BYTE, (Object)s.getField(1).getType());
        Assert.assertEquals((Object)Schema.FieldType.INT16, (Object)s.getField(2).getType());
        Assert.assertEquals((Object)Schema.FieldType.INT32, (Object)s.getField(3).getType());
        Assert.assertEquals((Object)Schema.FieldType.INT64, (Object)s.getField(4).getType());
        Assert.assertEquals((Object)Schema.FieldType.FLOAT, (Object)s.getField(5).getType());
        Assert.assertEquals((Object)Schema.FieldType.DOUBLE, (Object)s.getField(6).getType());
        Assert.assertEquals((Object)Schema.FieldType.DECIMAL, (Object)s.getField(7).getType());
        Assert.assertEquals((Object)Schema.FieldType.DATETIME, (Object)s.getField(8).getType());
        Assert.assertEquals((Object)Schema.FieldType.DATETIME, (Object)s.getField(9).getType());
        Assert.assertEquals((Object)Schema.FieldType.DATETIME, (Object)s.getField(10).getType());
        Assert.assertEquals((Object)Schema.TypeName.LOGICAL_TYPE, (Object)s.getField(11).getType().getTypeName());
        Assert.assertEquals((Object)Schema.TypeName.LOGICAL_TYPE, (Object)s.getField(12).getType().getTypeName());
        Assert.assertEquals((Object)Schema.TypeName.LOGICAL_TYPE, (Object)s.getField(13).getType().getTypeName());
        Assert.assertEquals((Object)Schema.TypeName.LOGICAL_TYPE, (Object)s.getField(14).getType().getTypeName());
        Assert.assertEquals((Object)Schema.TypeName.LOGICAL_TYPE, (Object)s.getField(15).getType().getTypeName());
        Assert.assertEquals((Object)Schema.TypeName.LOGICAL_TYPE, (Object)s.getField(16).getType().getTypeName());
        Assert.assertEquals((Object)Schema.FieldType.BYTES, (Object)s.getField(11).getType().getLogicalType().getBaseType());
        Assert.assertEquals((Object)Schema.FieldType.BYTES, (Object)s.getField(12).getType().getLogicalType().getBaseType());
        Assert.assertEquals((Object)Schema.FieldType.BYTES, (Object)s.getField(13).getType().getLogicalType().getBaseType());
        Assert.assertEquals((Object)Schema.FieldType.STRING, (Object)s.getField(14).getType().getLogicalType().getBaseType());
        Assert.assertEquals((Object)Schema.FieldType.STRING, (Object)s.getField(15).getType().getLogicalType().getBaseType());
        Assert.assertEquals((Object)Schema.FieldType.STRING, (Object)s.getField(16).getType().getLogicalType().getBaseType());
        Assert.assertEquals((long)17L, (long)r.getFieldCount());
        Assert.assertEquals((Object)true, (Object)r.getBoolean(0));
        Assert.assertEquals((Object)10, (Object)r.getByte(1));
        Assert.assertEquals((Object)10, (Object)r.getInt16(2));
        Assert.assertEquals((Object)10, (Object)r.getInt32(3));
        Assert.assertEquals((Object)10L, (Object)r.getInt64(4));
        Assert.assertEquals((Object)Float.valueOf(10.1f), (Object)r.getFloat(5));
        Assert.assertEquals((Object)10.1, (Object)r.getDouble(6));
        Assert.assertEquals((Object)new BigDecimal("100.100"), (Object)r.getDecimal(7));
        Assert.assertEquals((long)0L, (long)new DateTime((Object)"2022-10-10T10:10:10").compareTo((ReadableInstant)r.getDateTime(8)));
        Assert.assertEquals((long)0L, (long)new DateTime((Object)"2022-10-10T00:00:00Z").compareTo((ReadableInstant)r.getDateTime(9)));
        Assert.assertEquals((long)0L, (long)new DateTime((Object)"1970-01-01T10:10:10").compareTo((ReadableInstant)r.getDateTime(10)));
        Assert.assertArrayEquals((byte[])"asd".getBytes(StandardCharsets.UTF_8), (byte[])r.getBytes(11));
        Assert.assertArrayEquals((byte[])"asd".getBytes(StandardCharsets.UTF_8), (byte[])r.getBytes(12));
        Assert.assertArrayEquals((byte[])"asd\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes(StandardCharsets.UTF_8), (byte[])r.getBytes(13));
        Assert.assertEquals((Object)"asd", (Object)r.getString(14));
        Assert.assertEquals((Object)"asd", (Object)r.getString(15));
        Assert.assertEquals((Object)"asd", (Object)r.getString(16));
    }

    @Test
    public void testNullValues() throws Exception {
        int i;
        com.singlestore.jdbc.client.result.ResultSetMetaData md = (com.singlestore.jdbc.client.result.ResultSetMetaData)Mockito.mock(com.singlestore.jdbc.client.result.ResultSetMetaData.class);
        Mockito.when((Object)md.getColumnCount()).thenReturn((Object)18);
        Mockito.when((Object)md.getColumnType(1)).thenReturn((Object)-7);
        Mockito.when((Object)md.getColumnType(2)).thenReturn((Object)-6);
        Mockito.when((Object)md.getColumnType(3)).thenReturn((Object)5);
        Mockito.when((Object)md.getColumnType(4)).thenReturn((Object)4);
        Mockito.when((Object)md.getColumnType(5)).thenReturn((Object)-5);
        Mockito.when((Object)md.getColumnType(6)).thenReturn((Object)7);
        Mockito.when((Object)md.getColumnType(7)).thenReturn((Object)8);
        Mockito.when((Object)md.getColumnType(8)).thenReturn((Object)3);
        Mockito.when((Object)md.getColumnType(9)).thenReturn((Object)93);
        Mockito.when((Object)md.getColumnType(10)).thenReturn((Object)91);
        Mockito.when((Object)md.getColumnType(11)).thenReturn((Object)92);
        Mockito.when((Object)md.getColumnType(12)).thenReturn((Object)-4);
        Mockito.when((Object)md.getColumnType(13)).thenReturn((Object)-3);
        Mockito.when((Object)md.getColumnType(14)).thenReturn((Object)-2);
        Mockito.when((Object)md.getColumnType(15)).thenReturn((Object)-1);
        Mockito.when((Object)md.getColumnType(16)).thenReturn((Object)12);
        Mockito.when((Object)md.getColumnType(17)).thenReturn((Object)1);
        Mockito.when((Object)md.getColumnType(18)).thenReturn((Object)0);
        for (int i2 = 1; i2 <= md.getColumnCount(); ++i2) {
            Mockito.when((Object)md.getColumnLabel(i2)).thenReturn((Object)("c" + i2));
            Mockito.when((Object)md.isNullable(i2)).thenReturn((Object)1);
        }
        ResultSet res = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)res.getBoolean(1)).thenReturn((Object)false);
        Mockito.when((Object)res.getByte(2)).thenReturn((Object)0);
        Mockito.when((Object)res.getShort(3)).thenReturn((Object)0);
        Mockito.when((Object)res.getInt(4)).thenReturn((Object)0);
        Mockito.when((Object)res.getLong(5)).thenReturn((Object)0L);
        Mockito.when((Object)Float.valueOf(res.getFloat(6))).thenReturn((Object)Float.valueOf(0.0f));
        Mockito.when((Object)res.getDouble(7)).thenReturn((Object)0.0);
        Mockito.when((Object)res.getBigDecimal(8)).thenReturn(null);
        Mockito.when((Object)res.getTimestamp(9)).thenReturn(null);
        Mockito.when((Object)res.getDate(10)).thenReturn(null);
        Mockito.when((Object)res.getTime(11)).thenReturn(null);
        Mockito.when((Object)res.getBytes(12)).thenReturn(null);
        Mockito.when((Object)res.getBytes(13)).thenReturn(null);
        Mockito.when((Object)res.getBytes(14)).thenReturn(null);
        Mockito.when((Object)res.getString(15)).thenReturn(null);
        Mockito.when((Object)res.getString(16)).thenReturn(null);
        Mockito.when((Object)res.getString(17)).thenReturn(null);
        Mockito.when((Object)res.getString(18)).thenReturn(null);
        Mockito.when((Object)res.wasNull()).thenReturn((Object)true);
        SingleStoreDefaultRowMapper mapper = new SingleStoreDefaultRowMapper();
        mapper.init((ResultSetMetaData)md);
        Schema s = mapper.getCoder().getSchema();
        Row r = mapper.mapRow(res);
        Assert.assertEquals((long)18L, (long)s.getFieldCount());
        for (i = 0; i < s.getFieldCount(); ++i) {
            Assert.assertEquals((Object)("c" + (i + 1)), (Object)s.getField(i).getName());
        }
        Assert.assertEquals((long)18L, (long)r.getFieldCount());
        for (i = 0; i < r.getFieldCount(); ++i) {
            Assert.assertNull((Object)r.getValue(i));
        }
    }
}

