/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.singlestore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.common.TestRow;
import org.apache.beam.sdk.io.singlestore.SingleStoreIO;
import org.apache.beam.sdk.io.singlestore.TestHelper;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;

@RunWith(value=JUnit4.class)
public class ReadWithPartitionsTest {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    public final transient Pipeline pipelineForErrorChecks = Pipeline.create();
    private static SingleStoreIO.DataSourceConfiguration dataSourceConfiguration;
    private static final int EXPECTED_ROW_COUNT = 10;

    ResultSet getMockResultSet(int from, int to) throws SQLException {
        ResultSet res = (ResultSet)Mockito.mock(ResultSet.class, (MockSettings)Mockito.withSettings().serializable());
        OngoingStubbing next = Mockito.when((Object)res.next());
        for (int i = from; i < to; ++i) {
            next = next.thenReturn((Object)true);
        }
        next.thenReturn((Object)false);
        OngoingStubbing getInt = Mockito.when((Object)res.getInt(1));
        for (int i = from; i < to; ++i) {
            getInt = getInt.thenReturn((Object)i);
        }
        OngoingStubbing getString = Mockito.when((Object)res.getString(2));
        for (int i = from; i < to; ++i) {
            getString = getString.thenReturn((Object)TestRow.getNameForSeed((Integer)i));
        }
        return res;
    }

    @Before
    public void init() throws SQLException {
        ResultSet res0 = this.getMockResultSet(0, 5);
        ResultSet res1 = this.getMockResultSet(5, 10);
        ResultSet resNumPartitions = (ResultSet)Mockito.mock(ResultSet.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)resNumPartitions.next()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)resNumPartitions.getInt(1)).thenReturn((Object)2);
        Statement stmtNumPartitions = (Statement)Mockito.mock(Statement.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)stmtNumPartitions.executeQuery("SELECT num_partitions FROM information_schema.DISTRIBUTED_DATABASES WHERE database_name = 'db'")).thenReturn((Object)resNumPartitions);
        PreparedStatement stmt0 = (PreparedStatement)Mockito.mock(PreparedStatement.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)stmt0.executeQuery()).thenReturn((Object)res0);
        PreparedStatement stmt1 = (PreparedStatement)Mockito.mock(PreparedStatement.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)stmt1.executeQuery()).thenReturn((Object)res1);
        Connection conn = (Connection)Mockito.mock(Connection.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)conn.createStatement()).thenReturn((Object)stmtNumPartitions);
        Mockito.when((Object)conn.prepareStatement("SELECT * FROM (SELECT * FROM `t`) WHERE partition_id()=0")).thenReturn((Object)stmt0);
        Mockito.when((Object)conn.prepareStatement("SELECT * FROM (SELECT * FROM `t`) WHERE partition_id()=1")).thenReturn((Object)stmt1);
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)conn);
        dataSourceConfiguration = (SingleStoreIO.DataSourceConfiguration)Mockito.mock(SingleStoreIO.DataSourceConfiguration.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)dataSourceConfiguration.getDataSource()).thenReturn((Object)dataSource);
        Mockito.when((Object)dataSourceConfiguration.getDatabase()).thenReturn((Object)"db");
    }

    @Test
    public void testReadWithPartitions() {
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SingleStoreIO.readWithPartitions().withDataSourceConfiguration(dataSourceConfiguration).withQuery("SELECT * FROM `t`").withRowMapper((SingleStoreIO.RowMapper)new TestHelper.TestRowMapper()));
        PAssert.thatSingleton((PCollection)((PCollection)rows.apply("Count All", Count.globally()))).isEqualTo((Object)10L);
        Iterable expectedValues = TestRow.getExpectedValues((int)0, (int)10);
        PAssert.that((PCollection)rows).containsInAnyOrder(expectedValues);
        this.pipeline.run();
    }

    @Test
    public void testReadWithPartitionsWithTable() {
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SingleStoreIO.readWithPartitions().withDataSourceConfiguration(dataSourceConfiguration).withTable("t").withRowMapper((SingleStoreIO.RowMapper)new TestHelper.TestRowMapper()));
        PAssert.thatSingleton((PCollection)((PCollection)rows.apply("Count All", Count.globally()))).isEqualTo((Object)10L);
        Iterable expectedValues = TestRow.getExpectedValues((int)0, (int)10);
        PAssert.that((PCollection)rows).containsInAnyOrder(expectedValues);
        this.pipeline.run();
    }

    @Test
    public void testReadWithPartitionsNoTableAndQuery() {
        Assert.assertThrows((String)"One of withTable() or withQuery() is required", IllegalArgumentException.class, () -> {
            PCollection cfr_ignored_0 = (PCollection)this.pipelineForErrorChecks.apply((PTransform)SingleStoreIO.readWithPartitions().withDataSourceConfiguration(dataSourceConfiguration).withRowMapper((SingleStoreIO.RowMapper)new TestHelper.TestRowMapper()));
        });
    }

    @Test
    public void testReadWithPartitionsBothTableAndQuery() {
        Assert.assertThrows((String)"withTable() can not be used together with withQuery()", IllegalArgumentException.class, () -> {
            PCollection cfr_ignored_0 = (PCollection)this.pipelineForErrorChecks.apply((PTransform)SingleStoreIO.readWithPartitions().withDataSourceConfiguration(dataSourceConfiguration).withTable("t").withQuery("SELECT * FROM `t`").withRowMapper((SingleStoreIO.RowMapper)new TestHelper.TestRowMapper()));
        });
    }
}

