/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.singlestore;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.common.TestRow;
import org.apache.beam.sdk.io.singlestore.SingleStoreIO;
import org.apache.beam.sdk.io.singlestore.TestHelper;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;

@RunWith(value=JUnit4.class)
public class ReadTest {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    public final transient Pipeline pipelineForErrorChecks = Pipeline.create();
    private static SingleStoreIO.DataSourceConfiguration dataSourceConfiguration;
    private static PreparedStatement stmt;
    private static Connection conn;
    private static int setIntCalls;
    private static final int EXPECTED_ROW_COUNT = 10;

    @Before
    public void init() throws SQLException {
        ResultSet res = (ResultSet)Mockito.mock(ResultSet.class, (MockSettings)Mockito.withSettings().serializable());
        OngoingStubbing next = Mockito.when((Object)res.next());
        for (int i = 0; i < 10; ++i) {
            next = next.thenReturn((Object)true);
        }
        next.thenReturn((Object)false);
        OngoingStubbing getInt = Mockito.when((Object)res.getInt(1));
        for (int i = 0; i < 10; ++i) {
            getInt = getInt.thenReturn((Object)i);
        }
        OngoingStubbing getString = Mockito.when((Object)res.getString(2));
        for (int i = 0; i < 10; ++i) {
            getString = getString.thenReturn((Object)TestRow.getNameForSeed((Integer)i));
        }
        stmt = (PreparedStatement)Mockito.mock(PreparedStatement.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)stmt.executeQuery()).thenReturn((Object)res);
        conn = (Connection)Mockito.mock(Connection.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)conn.prepareStatement("SELECT * FROM `t`")).thenReturn((Object)stmt);
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)conn);
        dataSourceConfiguration = (SingleStoreIO.DataSourceConfiguration)Mockito.mock(SingleStoreIO.DataSourceConfiguration.class, (MockSettings)Mockito.withSettings().serializable());
        Mockito.when((Object)dataSourceConfiguration.getDataSource()).thenReturn((Object)dataSource);
    }

    @Test
    public void testRead() {
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SingleStoreIO.read().withDataSourceConfiguration(dataSourceConfiguration).withQuery("SELECT * FROM `t`").withRowMapper((SingleStoreIO.RowMapper)new TestHelper.TestRowMapper()));
        PAssert.thatSingleton((PCollection)((PCollection)rows.apply("Count All", Count.globally()))).isEqualTo((Object)10L);
        Iterable expectedValues = TestRow.getExpectedValues((int)0, (int)10);
        PAssert.that((PCollection)rows).containsInAnyOrder(expectedValues);
        this.pipeline.run();
    }

    @Test
    public void testReadWithStatementPreparator() throws SQLException {
        Mockito.when((Object)conn.prepareStatement("SELECT * FROM `t` WHERE id < ?")).thenReturn((Object)stmt);
        ((PreparedStatement)Mockito.doAnswer((Answer)new SetIntCall()).when((Object)stmt)).setInt(1, 10);
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SingleStoreIO.read().withDataSourceConfiguration(dataSourceConfiguration).withQuery("SELECT * FROM `t` WHERE id < ?").withRowMapper((SingleStoreIO.RowMapper)new TestHelper.TestRowMapper()).withStatementPreparator((SingleStoreIO.StatementPreparator)new TestStatmentPreparator()));
        PAssert.thatSingleton((PCollection)((PCollection)rows.apply("Count All", Count.globally()))).isEqualTo((Object)10L);
        Iterable expectedValues = TestRow.getExpectedValues((int)0, (int)10);
        PAssert.that((PCollection)rows).containsInAnyOrder(expectedValues);
        this.pipeline.run();
        Assert.assertEquals((long)1L, (long)setIntCalls);
    }

    @Test
    public void testReadWithTable() {
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SingleStoreIO.read().withDataSourceConfiguration(dataSourceConfiguration).withTable("t").withRowMapper((SingleStoreIO.RowMapper)new TestHelper.TestRowMapper()));
        PAssert.thatSingleton((PCollection)((PCollection)rows.apply("Count All", Count.globally()))).isEqualTo((Object)10L);
        Iterable expectedValues = TestRow.getExpectedValues((int)0, (int)10);
        PAssert.that((PCollection)rows).containsInAnyOrder(expectedValues);
        this.pipeline.run();
    }

    @Test
    public void testReadWithoutOutputParallelization() {
        PCollection rows = (PCollection)this.pipeline.apply((PTransform)SingleStoreIO.read().withDataSourceConfiguration(dataSourceConfiguration).withQuery("SELECT * FROM `t`").withRowMapper((SingleStoreIO.RowMapper)new TestHelper.TestRowMapper()).withOutputParallelization(Boolean.valueOf(false)));
        PAssert.thatSingleton((PCollection)((PCollection)rows.apply("Count All", Count.globally()))).isEqualTo((Object)10L);
        Iterable expectedValues = TestRow.getExpectedValues((int)0, (int)10);
        PAssert.that((PCollection)rows).containsInAnyOrder(expectedValues);
        this.pipeline.run();
    }

    @Test
    public void testReadNoTableAndQuery() {
        Assert.assertThrows((String)"One of withTable() or withQuery() is required", IllegalArgumentException.class, () -> this.pipelineForErrorChecks.apply((PTransform)SingleStoreIO.read().withDataSourceConfiguration(dataSourceConfiguration).withRowMapper((SingleStoreIO.RowMapper)new TestHelper.TestRowMapper()).withOutputParallelization(Boolean.valueOf(false))));
    }

    @Test
    public void testReadBothTableAndQuery() {
        Assert.assertThrows((String)"withTable() can not be used together with withQuery()", IllegalArgumentException.class, () -> this.pipelineForErrorChecks.apply((PTransform)SingleStoreIO.read().withDataSourceConfiguration(dataSourceConfiguration).withTable("t").withQuery("SELECT * FROM `t`").withRowMapper((SingleStoreIO.RowMapper)new TestHelper.TestRowMapper()).withOutputParallelization(Boolean.valueOf(false))));
    }

    static {
        setIntCalls = 0;
    }

    private static class TestStatmentPreparator
    implements SingleStoreIO.StatementPreparator {
        private TestStatmentPreparator() {
        }

        public void setParameters(PreparedStatement preparedStatement) throws Exception {
            preparedStatement.setInt(1, 10);
        }
    }

    private static class SetIntCall
    implements Serializable,
    Answer<Void> {
        private SetIntCall() {
        }

        public Void answer(InvocationOnMock invocation) {
            setIntCalls++;
            return null;
        }
    }
}

