/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class RabbitMqTestUtils {
    private RabbitMqTestUtils() {
        throw new UnsupportedOperationException("RabbitMqTestUtils is a non-instantiable utility class");
    }

    public static byte[] generateRecord(int recordNum) {
        return ("Test " + recordNum).getBytes(StandardCharsets.UTF_8);
    }

    public static List<byte[]> generateRecords(int numRecords) {
        return IntStream.range(0, numRecords).mapToObj(RabbitMqTestUtils::generateRecord).collect(Collectors.toList());
    }

    public static String recordToString(byte[] record) {
        return new String(record, StandardCharsets.UTF_8);
    }

    static class TestConsumer
    extends DefaultConsumer {
        private final List<String> received = Collections.synchronizedList(new ArrayList());

        public TestConsumer(Channel channel) {
            super(channel);
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            this.received.add(RabbitMqTestUtils.recordToString(body));
        }

        public List<String> getReceived() {
            return Collections.unmodifiableList(this.received);
        }
    }
}

