/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.rabbitmq;

import com.rabbitmq.client.AMQP;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.rabbitmq.RabbitMqIO;
import org.apache.beam.sdk.io.rabbitmq.RabbitMqTestUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

class ExchangeTestPlan {
    static final String DEFAULT_ROUTING_KEY = "someRoutingKey";
    private final RabbitMqIO.Read read;
    private final int numRecords;
    private final int numRecordsToPublish;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable AMQP.BasicProperties publishProperties;

    public ExchangeTestPlan(RabbitMqIO.Read read, int maxRecordsRead) {
        this(read, maxRecordsRead, maxRecordsRead);
    }

    public ExchangeTestPlan(RabbitMqIO.Read read, int maxRecordsRead, int numRecordsToPublish) {
        this(read, maxRecordsRead, numRecordsToPublish, null);
    }

    public ExchangeTestPlan(RabbitMqIO.Read read, int maxRecordsRead, int numRecordsToPublish, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable AMQP.BasicProperties publishProperties) {
        this.read = read;
        this.numRecords = maxRecordsRead;
        this.numRecordsToPublish = numRecordsToPublish;
        this.publishProperties = publishProperties;
    }

    public RabbitMqIO.Read getRead() {
        return this.read;
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public int getNumRecordsToPublish() {
        return this.numRecordsToPublish;
    }

    public AMQP.BasicProperties getPublishProperties() {
        return this.publishProperties;
    }

    public Supplier<String> publishRoutingKeyGen() {
        return () -> DEFAULT_ROUTING_KEY;
    }

    public List<String> expectedResults() {
        return RabbitMqTestUtils.generateRecords(this.numRecordsToPublish).stream().map(RabbitMqTestUtils::recordToString).collect(Collectors.toList());
    }
}

