/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.LongString;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class RabbitMqMessage
implements Serializable {
    private final @Nullable @UnknownKeyFor @Initialized String routingKey;
    private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] body;
    private final @UnknownKeyFor @NonNull @Initialized String contentType;
    private final @UnknownKeyFor @NonNull @Initialized String contentEncoding;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> headers;
    private final @UnknownKeyFor @NonNull @Initialized Integer deliveryMode;
    private final @UnknownKeyFor @NonNull @Initialized Integer priority;
    private final @Nullable @UnknownKeyFor @Initialized String correlationId;
    private final @Nullable @UnknownKeyFor @Initialized String replyTo;
    private final @UnknownKeyFor @NonNull @Initialized String expiration;
    private final @UnknownKeyFor @NonNull @Initialized String messageId;
    private final @UnknownKeyFor @NonNull @Initialized Date timestamp;
    private final @Nullable @UnknownKeyFor @Initialized String type;
    private final @Nullable @UnknownKeyFor @Initialized String userId;
    private final @Nullable @UnknownKeyFor @Initialized String appId;
    private final @Nullable @UnknownKeyFor @Initialized String clusterId;

    private static @UnknownKeyFor @NonNull @Initialized GetResponse serializableDeliveryOf(@UnknownKeyFor @NonNull @Initialized GetResponse processed) {
        Envelope envelope = processed.getEnvelope();
        AMQP.BasicProperties properties = processed.getProps();
        AMQP.BasicProperties nextProperties = new AMQP.BasicProperties.Builder().appId(properties.getAppId()).clusterId(properties.getClusterId()).contentEncoding(properties.getContentEncoding()).contentType(properties.getContentType()).correlationId(properties.getCorrelationId()).deliveryMode(properties.getDeliveryMode()).expiration(properties.getExpiration()).headers(RabbitMqMessage.serializableHeaders(properties.getHeaders())).messageId(properties.getMessageId()).priority(properties.getPriority()).replyTo(properties.getReplyTo()).timestamp(properties.getTimestamp()).type(properties.getType()).userId(properties.getUserId()).build();
        return new GetResponse(envelope, nextProperties, processed.getBody(), processed.getMessageCount());
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> serializableHeaders(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> headers) {
        HashMap<String, Object> returned = new HashMap<String, Object>();
        if (headers != null) {
            for (Map.Entry<String, Object> h : headers.entrySet()) {
                Object value = h.getValue();
                if (!(value instanceof Serializable)) {
                    try {
                        if (!(value instanceof LongString)) {
                            throw new RuntimeException(String.format("no transformation defined for %s", value));
                        }
                        LongString longString = (LongString)value;
                        byte[] bytes = longString.getBytes();
                        String s = new String(bytes, StandardCharsets.UTF_8);
                        value = s;
                    }
                    catch (Throwable t) {
                        throw new UnsupportedOperationException(String.format("can't make unserializable value %s a serializable value (which is mandatory for Apache Beam dataflow implementation)", value), t);
                    }
                }
                returned.put(h.getKey(), value);
            }
        }
        return returned;
    }

    public RabbitMqMessage(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] body) {
        this.body = body;
        this.routingKey = "";
        this.contentType = null;
        this.contentEncoding = null;
        this.headers = new HashMap<String, Object>();
        this.deliveryMode = 1;
        this.priority = 1;
        this.correlationId = null;
        this.replyTo = null;
        this.expiration = null;
        this.messageId = null;
        this.timestamp = new Date();
        this.type = null;
        this.userId = null;
        this.appId = null;
        this.clusterId = null;
    }

    public RabbitMqMessage(@UnknownKeyFor @NonNull @Initialized String routingKey, @UnknownKeyFor @NonNull @Initialized GetResponse delivery) {
        this.routingKey = routingKey;
        delivery = RabbitMqMessage.serializableDeliveryOf(delivery);
        this.body = delivery.getBody();
        this.contentType = delivery.getProps().getContentType();
        this.contentEncoding = delivery.getProps().getContentEncoding();
        this.headers = delivery.getProps().getHeaders();
        this.deliveryMode = delivery.getProps().getDeliveryMode();
        this.priority = delivery.getProps().getPriority();
        this.correlationId = delivery.getProps().getCorrelationId();
        this.replyTo = delivery.getProps().getReplyTo();
        this.expiration = delivery.getProps().getExpiration();
        this.messageId = delivery.getProps().getMessageId();
        this.timestamp = delivery.getProps().getTimestamp();
        this.type = delivery.getProps().getType();
        this.userId = delivery.getProps().getUserId();
        this.appId = delivery.getProps().getAppId();
        this.clusterId = delivery.getProps().getClusterId();
    }

    public RabbitMqMessage(@UnknownKeyFor @NonNull @Initialized String routingKey, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] body, @UnknownKeyFor @NonNull @Initialized String contentType, @UnknownKeyFor @NonNull @Initialized String contentEncoding, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> headers, @UnknownKeyFor @NonNull @Initialized Integer deliveryMode, @UnknownKeyFor @NonNull @Initialized Integer priority, @UnknownKeyFor @NonNull @Initialized String correlationId, @UnknownKeyFor @NonNull @Initialized String replyTo, @UnknownKeyFor @NonNull @Initialized String expiration, @UnknownKeyFor @NonNull @Initialized String messageId, @UnknownKeyFor @NonNull @Initialized Date timestamp, @UnknownKeyFor @NonNull @Initialized String type, @UnknownKeyFor @NonNull @Initialized String userId, @UnknownKeyFor @NonNull @Initialized String appId, @UnknownKeyFor @NonNull @Initialized String clusterId) {
        this.routingKey = routingKey;
        this.body = body;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.headers = headers;
        this.deliveryMode = deliveryMode;
        this.priority = priority;
        this.correlationId = correlationId;
        this.replyTo = replyTo;
        this.expiration = expiration;
        this.messageId = messageId;
        this.timestamp = timestamp;
        this.type = type;
        this.userId = userId;
        this.appId = appId;
        this.clusterId = clusterId;
    }

    public @UnknownKeyFor @NonNull @Initialized String getRoutingKey() {
        return this.routingKey;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getBody() {
        return this.body;
    }

    public @UnknownKeyFor @NonNull @Initialized String getContentType() {
        return this.contentType;
    }

    public @UnknownKeyFor @NonNull @Initialized String getContentEncoding() {
        return this.contentEncoding;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getHeaders() {
        return this.headers;
    }

    public @UnknownKeyFor @NonNull @Initialized Integer getDeliveryMode() {
        return this.deliveryMode;
    }

    public @UnknownKeyFor @NonNull @Initialized Integer getPriority() {
        return this.priority;
    }

    public @UnknownKeyFor @NonNull @Initialized String getCorrelationId() {
        return this.correlationId;
    }

    public @UnknownKeyFor @NonNull @Initialized String getReplyTo() {
        return this.replyTo;
    }

    public @UnknownKeyFor @NonNull @Initialized String getExpiration() {
        return this.expiration;
    }

    public @UnknownKeyFor @NonNull @Initialized String getMessageId() {
        return this.messageId;
    }

    public @UnknownKeyFor @NonNull @Initialized Date getTimestamp() {
        return this.timestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized String getType() {
        return this.type;
    }

    public @UnknownKeyFor @NonNull @Initialized String getUserId() {
        return this.userId;
    }

    public @UnknownKeyFor @NonNull @Initialized String getAppId() {
        return this.appId;
    }

    public @UnknownKeyFor @NonNull @Initialized String getClusterId() {
        return this.clusterId;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized AMQP.BasicProperties createProperties() {
        return new AMQP.BasicProperties().builder().contentType(this.contentType).contentEncoding(this.contentEncoding).headers(this.headers).deliveryMode(this.deliveryMode).priority(this.priority).correlationId(this.correlationId).replyTo(this.replyTo).expiration(this.expiration).messageId(this.messageId).timestamp(this.timestamp).type(this.type).userId(this.userId).appId(this.appId).clusterId(this.clusterId).build();
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.routingKey, Arrays.hashCode(this.body), this.contentType, this.contentEncoding, this.deliveryMode, this.priority, this.correlationId, this.replyTo, this.expiration, this.messageId, this.timestamp, this.type, this.userId, this.appId, this.clusterId);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (obj instanceof RabbitMqMessage) {
            RabbitMqMessage other = (RabbitMqMessage)obj;
            return Objects.equals(this.routingKey, other.routingKey) && Arrays.equals(this.body, other.body) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.contentEncoding, other.contentEncoding) && Objects.equals(this.deliveryMode, other.deliveryMode) && Objects.equals(this.priority, other.priority) && Objects.equals(this.correlationId, other.correlationId) && Objects.equals(this.replyTo, other.replyTo) && Objects.equals(this.expiration, other.expiration) && Objects.equals(this.messageId, other.messageId) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.type, other.type) && Objects.equals(this.userId, other.userId) && Objects.equals(this.appId, other.appId) && Objects.equals(this.clusterId, other.clusterId);
        }
        return false;
    }
}

