/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.rabbitmq;

import com.google.auto.value.AutoValue;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.MessageProperties;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeoutException;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.rabbitmq.AutoValue_RabbitMqIO_Read;
import org.apache.beam.sdk.io.rabbitmq.AutoValue_RabbitMqIO_Write;
import org.apache.beam.sdk.io.rabbitmq.RabbitMqMessage;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class RabbitMqIO {
    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_RabbitMqIO_Read.Builder().setQueueDeclare(false).setExchangeDeclare(false).setMaxReadTime(null).setMaxNumRecords(Long.MAX_VALUE).setUseCorrelationId(false).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new AutoValue_RabbitMqIO_Write.Builder().setExchangeDeclare(false).setQueueDeclare(false).build();
    }

    private RabbitMqIO() {
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<RabbitMqMessage>, PCollection<?>> {
        abstract @Nullable @UnknownKeyFor @Initialized String uri();

        abstract @Nullable @UnknownKeyFor @Initialized String exchange();

        abstract @Nullable @UnknownKeyFor @Initialized String exchangeType();

        abstract @UnknownKeyFor @NonNull @Initialized boolean exchangeDeclare();

        abstract @Nullable @UnknownKeyFor @Initialized String queue();

        abstract @UnknownKeyFor @NonNull @Initialized boolean queueDeclare();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized Write withUri(@UnknownKeyFor @NonNull @Initialized String uri) {
            Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri can not be null");
            return this.builder().setUri(uri).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withExchange(@UnknownKeyFor @NonNull @Initialized String exchange, @UnknownKeyFor @NonNull @Initialized String exchangeType) {
            Preconditions.checkArgument((exchange != null ? 1 : 0) != 0, (Object)"exchange can not be null");
            Preconditions.checkArgument((exchangeType != null ? 1 : 0) != 0, (Object)"exchangeType can not be null");
            return this.builder().setExchange(exchange).setExchangeType(exchangeType).setExchangeDeclare(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withExchange(@UnknownKeyFor @NonNull @Initialized String exchange) {
            Preconditions.checkArgument((exchange != null ? 1 : 0) != 0, (Object)"exchange can not be null");
            return this.builder().setExchange(exchange).setExchangeDeclare(false).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withQueue(@UnknownKeyFor @NonNull @Initialized String queue) {
            Preconditions.checkArgument((queue != null ? 1 : 0) != 0, (Object)"queue can not be null");
            return this.builder().setQueue(queue).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withQueueDeclare(@UnknownKeyFor @NonNull @Initialized boolean queueDeclare) {
            return this.builder().setQueueDeclare(queueDeclare).build();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized RabbitMqMessage> input) {
            Preconditions.checkArgument((this.exchange() != null || this.queue() != null ? 1 : 0) != 0, (Object)"Either exchange or queue has to be specified");
            if (this.exchange() != null) {
                Preconditions.checkArgument((this.queue() == null ? 1 : 0) != 0, (Object)"Queue can't be set in the same time as exchange");
            }
            if (this.queue() != null) {
                Preconditions.checkArgument((this.exchange() == null ? 1 : 0) != 0, (Object)"Exchange can't be set in the same time as queue");
            }
            if (this.queueDeclare()) {
                Preconditions.checkArgument((this.queue() != null ? 1 : 0) != 0, (Object)"Queue is required for the queue declare");
            }
            if (this.exchangeDeclare()) {
                Preconditions.checkArgument((this.exchange() != null ? 1 : 0) != 0, (Object)"Exchange is required for the exchange declare");
            }
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new WriteFn(this)));
        }

        private static class WriteFn
        extends DoFn<RabbitMqMessage, Void> {
            private final @UnknownKeyFor @NonNull @Initialized Write spec;
            private transient @UnknownKeyFor @NonNull @Initialized ConnectionHandler connectionHandler;

            WriteFn(@UnknownKeyFor @NonNull @Initialized Write spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.connectionHandler = new ConnectionHandler(this.spec.uri());
                this.connectionHandler.start();
                Channel channel = this.connectionHandler.getChannel();
                if (this.spec.exchange() != null && this.spec.exchangeDeclare()) {
                    channel.exchangeDeclare(this.spec.exchange(), this.spec.exchangeType());
                }
                if (this.spec.queue() != null && this.spec.queueDeclare()) {
                    channel.queueDeclare(this.spec.queue(), true, false, false, null);
                }
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IOException {
                RabbitMqMessage message = (RabbitMqMessage)c.element();
                Channel channel = this.connectionHandler.getChannel();
                if (this.spec.exchange() != null) {
                    channel.basicPublish(this.spec.exchange(), message.getRoutingKey(), message.createProperties(), message.getBody());
                }
                if (this.spec.queue() != null) {
                    channel.basicPublish("", this.spec.queue(), MessageProperties.PERSISTENT_TEXT_PLAIN, message.getBody());
                }
            }

            @DoFn.Teardown
            public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
                if (this.connectionHandler != null) {
                    this.connectionHandler.stop();
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUri(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setExchange(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setExchangeType(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setExchangeDeclare(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setQueue(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setQueueDeclare(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }

    private static class UnboundedRabbitMqReader
    extends UnboundedSource.UnboundedReader<RabbitMqMessage> {
        private final @UnknownKeyFor @NonNull @Initialized RabbitMQSource source;
        private @UnknownKeyFor @NonNull @Initialized RabbitMqMessage current;
        private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] currentRecordId;
        private @UnknownKeyFor @NonNull @Initialized ConnectionHandler connectionHandler;
        private @UnknownKeyFor @NonNull @Initialized String queueName;
        private @UnknownKeyFor @NonNull @Initialized Instant currentTimestamp;
        private final @UnknownKeyFor @NonNull @Initialized RabbitMQCheckpointMark checkpointMark;

        UnboundedRabbitMqReader(@UnknownKeyFor @NonNull @Initialized RabbitMQSource source, @UnknownKeyFor @NonNull @Initialized RabbitMQCheckpointMark checkpointMark) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.source = source;
            this.current = null;
            this.checkpointMark = checkpointMark != null ? checkpointMark : new RabbitMQCheckpointMark();
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
            return this.checkpointMark.latestTimestamp;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark getCheckpointMark() {
            return this.checkpointMark;
        }

        public @UnknownKeyFor @NonNull @Initialized RabbitMQSource getCurrentSource() {
            return this.source;
        }

        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getCurrentRecordId() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            if (this.currentRecordId != null) {
                return this.currentRecordId;
            }
            return "".getBytes(StandardCharsets.UTF_8);
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() {
            if (this.currentTimestamp == null) {
                throw new NoSuchElementException();
            }
            return this.currentTimestamp;
        }

        public @UnknownKeyFor @NonNull @Initialized RabbitMqMessage getCurrent() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                this.connectionHandler = new ConnectionHandler(this.source.spec.uri());
                this.connectionHandler.start();
                Channel channel = this.connectionHandler.getChannel();
                this.queueName = this.source.spec.queue();
                if (this.source.spec.queueDeclare()) {
                    channel.queueDeclare(this.queueName, false, false, false, null);
                }
                if (this.source.spec.exchange() != null) {
                    if (this.source.spec.exchangeDeclare()) {
                        channel.exchangeDeclare(this.source.spec.exchange(), this.source.spec.exchangeType());
                    }
                    if (this.queueName == null) {
                        this.queueName = channel.queueDeclare().getQueue();
                    }
                    channel.queueBind(this.queueName, this.source.spec.exchange(), this.source.spec.routingKey());
                }
                this.checkpointMark.channel = channel;
                channel.txSelect();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return this.advance();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                Channel channel = this.connectionHandler.getChannel();
                GetResponse delivery = channel.basicGet(this.queueName, false);
                if (delivery == null) {
                    this.current = null;
                    this.currentRecordId = null;
                    this.currentTimestamp = null;
                    this.checkpointMark.advanceWatermark(Instant.now());
                    return false;
                }
                if (this.source.spec.useCorrelationId()) {
                    String correlationId = delivery.getProps().getCorrelationId();
                    if (correlationId == null) {
                        throw new IOException("RabbitMqIO.Read uses message correlation ID, but received message has a null correlation ID");
                    }
                    this.currentRecordId = correlationId.getBytes(StandardCharsets.UTF_8);
                }
                long deliveryTag = delivery.getEnvelope().getDeliveryTag();
                this.checkpointMark.sessionIds.add(deliveryTag);
                this.current = new RabbitMqMessage(this.source.spec.routingKey(), delivery);
                Date deliveryTimestamp = delivery.getProps().getTimestamp();
                this.currentTimestamp = deliveryTimestamp != null ? new Instant((Object)deliveryTimestamp) : Instant.now();
                this.checkpointMark.advanceWatermark(this.currentTimestamp);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return true;
        }

        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.connectionHandler != null) {
                this.connectionHandler.stop();
            }
        }
    }

    private static class RabbitMQCheckpointMark
    implements UnboundedSource.CheckpointMark,
    Serializable {
        transient @UnknownKeyFor @NonNull @Initialized Channel channel;
        @UnknownKeyFor @NonNull @Initialized Instant latestTimestamp = Instant.now();
        transient @UnknownKeyFor @NonNull @Initialized ConcurrentLinkedQueue<@UnknownKeyFor @NonNull @Initialized Long> sessionIds = new ConcurrentLinkedQueue();

        private RabbitMQCheckpointMark() {
        }

        private @UnknownKeyFor @NonNull @Initialized Object readResolve() {
            this.sessionIds = new ConcurrentLinkedQueue();
            return this;
        }

        public void advanceWatermark(@UnknownKeyFor @NonNull @Initialized Instant time) {
            if (time.isAfter((ReadableInstant)this.latestTimestamp)) {
                this.latestTimestamp = time;
            }
        }

        public void finalizeCheckpoint() throws @UnknownKeyFor @NonNull @Initialized IOException {
            Long sessionId = this.sessionIds.poll();
            while (sessionId != null) {
                this.channel.basicAck(sessionId.longValue(), false);
                sessionId = this.sessionIds.poll();
            }
            this.channel.txCommit();
            this.latestTimestamp = Instant.now();
        }
    }

    static class RabbitMQSource
    extends UnboundedSource<RabbitMqMessage, RabbitMQCheckpointMark> {
        final @UnknownKeyFor @NonNull @Initialized Read spec;

        RabbitMQSource(@UnknownKeyFor @NonNull @Initialized Read spec) {
            this.spec = spec;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized RabbitMqMessage> getOutputCoder() {
            return SerializableCoder.of(RabbitMqMessage.class);
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RabbitMQSource> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            ArrayList<RabbitMQSource> sources = new ArrayList<RabbitMQSource>();
            for (int i = 0; i < desiredNumSplits; ++i) {
                sources.add(this);
            }
            return sources;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<@UnknownKeyFor @NonNull @Initialized RabbitMqMessage> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized RabbitMQCheckpointMark checkpointMark) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return new UnboundedRabbitMqReader(this, checkpointMark);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized RabbitMQCheckpointMark> getCheckpointMarkCoder() {
            return SerializableCoder.of(RabbitMQCheckpointMark.class);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean requiresDeduping() {
            return this.spec.useCorrelationId();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<RabbitMqMessage>> {
        abstract @Nullable @UnknownKeyFor @Initialized String uri();

        abstract @Nullable @UnknownKeyFor @Initialized String queue();

        abstract @UnknownKeyFor @NonNull @Initialized boolean queueDeclare();

        abstract @Nullable @UnknownKeyFor @Initialized String exchange();

        abstract @Nullable @UnknownKeyFor @Initialized String exchangeType();

        abstract @UnknownKeyFor @NonNull @Initialized boolean exchangeDeclare();

        abstract @Nullable @UnknownKeyFor @Initialized String routingKey();

        abstract @UnknownKeyFor @NonNull @Initialized boolean useCorrelationId();

        abstract @UnknownKeyFor @NonNull @Initialized long maxNumRecords();

        abstract @Nullable @UnknownKeyFor @Initialized Duration maxReadTime();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized Read withUri(@UnknownKeyFor @NonNull @Initialized String uri) {
            Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri can not be null");
            return this.builder().setUri(uri).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQueue(@UnknownKeyFor @NonNull @Initialized String queue) {
            Preconditions.checkArgument((queue != null ? 1 : 0) != 0, (Object)"queue can not be null");
            return this.builder().setQueue(queue).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQueueDeclare(@UnknownKeyFor @NonNull @Initialized boolean queueDeclare) {
            return this.builder().setQueueDeclare(queueDeclare).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withExchange(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String type, @Nullable @UnknownKeyFor @Initialized String routingKey) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"exchange name can not be null");
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"exchange type can not be null");
            return this.builder().setExchange(name).setExchangeType(type).setRoutingKey(routingKey).setExchangeDeclare(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withExchange(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized String routingKey) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"exchange name can not be null");
            return this.builder().setExchange(name).setExchangeDeclare(false).setRoutingKey(routingKey).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long maxNumRecords) {
            Preconditions.checkArgument((this.maxReadTime() == null ? 1 : 0) != 0, (Object)"maxNumRecord and maxReadTime are exclusive");
            return this.builder().setMaxNumRecords(maxNumRecords).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration maxReadTime) {
            Preconditions.checkArgument((this.maxNumRecords() == Long.MAX_VALUE ? 1 : 0) != 0, (Object)"maxNumRecord and maxReadTime are exclusive");
            return this.builder().setMaxReadTime(maxReadTime).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withUseCorrelationId(@UnknownKeyFor @NonNull @Initialized boolean useCorrelationId) {
            return this.builder().setUseCorrelationId(useCorrelationId).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized RabbitMqMessage> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Read.Unbounded unbounded;
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from((UnboundedSource)new RabbitMQSource(this));
            if (this.maxNumRecords() < Long.MAX_VALUE || this.maxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.maxReadTime()).withMaxNumRecords(this.maxNumRecords());
            }
            return (PCollection)input.getPipeline().apply((PTransform)transform);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUri(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setQueue(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setQueueDeclare(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setExchange(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setExchangeType(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setExchangeDeclare(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRoutingKey(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUseCorrelationId(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }

    private static class ConnectionHandler {
        private final @UnknownKeyFor @NonNull @Initialized ConnectionFactory connectionFactory = new ConnectionFactory();
        private @UnknownKeyFor @NonNull @Initialized Connection connection;
        private @UnknownKeyFor @NonNull @Initialized Channel channel;

        public ConnectionHandler(@UnknownKeyFor @NonNull @Initialized String uri) throws @UnknownKeyFor @NonNull @Initialized URISyntaxException, @UnknownKeyFor @NonNull @Initialized NoSuchAlgorithmException, @UnknownKeyFor @NonNull @Initialized KeyManagementException {
            this.connectionFactory.setUri(uri);
            this.connectionFactory.setAutomaticRecoveryEnabled(true);
            this.connectionFactory.setConnectionTimeout(60000);
            this.connectionFactory.setNetworkRecoveryInterval(5000);
            this.connectionFactory.setRequestedHeartbeat(60);
            this.connectionFactory.setTopologyRecoveryEnabled(true);
            this.connectionFactory.setRequestedChannelMax(0);
            this.connectionFactory.setRequestedFrameMax(0);
        }

        public void start() throws @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.connection = this.connectionFactory.newConnection();
            this.channel = this.connection.createChannel();
            if (this.channel == null) {
                throw new IOException("No RabbitMQ channel available");
            }
        }

        public @UnknownKeyFor @NonNull @Initialized Channel getChannel() {
            return this.channel;
        }

        public void stop() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }
}

