/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.rabbitmq;

import org.apache.beam.sdk.io.rabbitmq.RabbitMqIO;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_RabbitMqIO_Read
extends RabbitMqIO.Read {
    private final @Nullable String uri;
    private final @Nullable String queue;
    private final boolean queueDeclare;
    private final @Nullable String exchange;
    private final @Nullable String exchangeType;
    private final boolean exchangeDeclare;
    private final @Nullable String routingKey;
    private final boolean useCorrelationId;
    private final long maxNumRecords;
    private final @Nullable Duration maxReadTime;

    private AutoValue_RabbitMqIO_Read(@Nullable String uri, @Nullable String queue, boolean queueDeclare, @Nullable String exchange, @Nullable String exchangeType, boolean exchangeDeclare, @Nullable String routingKey, boolean useCorrelationId, long maxNumRecords, @Nullable Duration maxReadTime) {
        this.uri = uri;
        this.queue = queue;
        this.queueDeclare = queueDeclare;
        this.exchange = exchange;
        this.exchangeType = exchangeType;
        this.exchangeDeclare = exchangeDeclare;
        this.routingKey = routingKey;
        this.useCorrelationId = useCorrelationId;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTime = maxReadTime;
    }

    @Override
    @Nullable String uri() {
        return this.uri;
    }

    @Override
    @Nullable String queue() {
        return this.queue;
    }

    @Override
    boolean queueDeclare() {
        return this.queueDeclare;
    }

    @Override
    @Nullable String exchange() {
        return this.exchange;
    }

    @Override
    @Nullable String exchangeType() {
        return this.exchangeType;
    }

    @Override
    boolean exchangeDeclare() {
        return this.exchangeDeclare;
    }

    @Override
    @Nullable String routingKey() {
        return this.routingKey;
    }

    @Override
    boolean useCorrelationId() {
        return this.useCorrelationId;
    }

    @Override
    long maxNumRecords() {
        return this.maxNumRecords;
    }

    @Override
    @Nullable Duration maxReadTime() {
        return this.maxReadTime;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RabbitMqIO.Read) {
            RabbitMqIO.Read that = (RabbitMqIO.Read)((Object)o);
            return (this.uri == null ? that.uri() == null : this.uri.equals(that.uri())) && (this.queue == null ? that.queue() == null : this.queue.equals(that.queue())) && this.queueDeclare == that.queueDeclare() && (this.exchange == null ? that.exchange() == null : this.exchange.equals(that.exchange())) && (this.exchangeType == null ? that.exchangeType() == null : this.exchangeType.equals(that.exchangeType())) && this.exchangeDeclare == that.exchangeDeclare() && (this.routingKey == null ? that.routingKey() == null : this.routingKey.equals(that.routingKey())) && this.useCorrelationId == that.useCorrelationId() && this.maxNumRecords == that.maxNumRecords() && (this.maxReadTime == null ? that.maxReadTime() == null : this.maxReadTime.equals((Object)that.maxReadTime()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.uri == null ? 0 : this.uri.hashCode();
        h$ *= 1000003;
        h$ ^= this.queue == null ? 0 : this.queue.hashCode();
        h$ *= 1000003;
        h$ ^= this.queueDeclare ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.exchange == null ? 0 : this.exchange.hashCode();
        h$ *= 1000003;
        h$ ^= this.exchangeType == null ? 0 : this.exchangeType.hashCode();
        h$ *= 1000003;
        h$ ^= this.exchangeDeclare ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.routingKey == null ? 0 : this.routingKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.useCorrelationId ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.maxNumRecords >>> 32 ^ this.maxNumRecords);
        h$ *= 1000003;
        return h$ ^= this.maxReadTime == null ? 0 : this.maxReadTime.hashCode();
    }

    @Override
    RabbitMqIO.Read.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends RabbitMqIO.Read.Builder {
        private @Nullable String uri;
        private @Nullable String queue;
        private Boolean queueDeclare;
        private @Nullable String exchange;
        private @Nullable String exchangeType;
        private Boolean exchangeDeclare;
        private @Nullable String routingKey;
        private Boolean useCorrelationId;
        private Long maxNumRecords;
        private @Nullable Duration maxReadTime;

        Builder() {
        }

        private Builder(RabbitMqIO.Read source) {
            this.uri = source.uri();
            this.queue = source.queue();
            this.queueDeclare = source.queueDeclare();
            this.exchange = source.exchange();
            this.exchangeType = source.exchangeType();
            this.exchangeDeclare = source.exchangeDeclare();
            this.routingKey = source.routingKey();
            this.useCorrelationId = source.useCorrelationId();
            this.maxNumRecords = source.maxNumRecords();
            this.maxReadTime = source.maxReadTime();
        }

        @Override
        RabbitMqIO.Read.Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        RabbitMqIO.Read.Builder setQueue(String queue) {
            this.queue = queue;
            return this;
        }

        @Override
        RabbitMqIO.Read.Builder setQueueDeclare(boolean queueDeclare) {
            this.queueDeclare = queueDeclare;
            return this;
        }

        @Override
        RabbitMqIO.Read.Builder setExchange(String exchange) {
            this.exchange = exchange;
            return this;
        }

        @Override
        RabbitMqIO.Read.Builder setExchangeType(String exchangeType) {
            this.exchangeType = exchangeType;
            return this;
        }

        @Override
        RabbitMqIO.Read.Builder setExchangeDeclare(boolean exchangeDeclare) {
            this.exchangeDeclare = exchangeDeclare;
            return this;
        }

        @Override
        RabbitMqIO.Read.Builder setRoutingKey(String routingKey) {
            this.routingKey = routingKey;
            return this;
        }

        @Override
        RabbitMqIO.Read.Builder setUseCorrelationId(boolean useCorrelationId) {
            this.useCorrelationId = useCorrelationId;
            return this;
        }

        @Override
        RabbitMqIO.Read.Builder setMaxNumRecords(long maxNumRecords) {
            this.maxNumRecords = maxNumRecords;
            return this;
        }

        @Override
        RabbitMqIO.Read.Builder setMaxReadTime(Duration maxReadTime) {
            this.maxReadTime = maxReadTime;
            return this;
        }

        @Override
        RabbitMqIO.Read build() {
            if (this.queueDeclare == null || this.exchangeDeclare == null || this.useCorrelationId == null || this.maxNumRecords == null) {
                StringBuilder missing = new StringBuilder();
                if (this.queueDeclare == null) {
                    missing.append(" queueDeclare");
                }
                if (this.exchangeDeclare == null) {
                    missing.append(" exchangeDeclare");
                }
                if (this.useCorrelationId == null) {
                    missing.append(" useCorrelationId");
                }
                if (this.maxNumRecords == null) {
                    missing.append(" maxNumRecords");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RabbitMqIO_Read(this.uri, this.queue, this.queueDeclare, this.exchange, this.exchangeType, this.exchangeDeclare, this.routingKey, this.useCorrelationId, this.maxNumRecords, this.maxReadTime);
        }
    }
}

