/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.pulsar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.beam.sdk.io.pulsar.FakeMessage;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

public class FakePulsarReader
implements Reader<byte[]> {
    private String topic;
    private List<FakeMessage> fakeMessages = new ArrayList<FakeMessage>();
    private int currentMsg;
    private long startTimestamp;
    private long endTimestamp;
    private boolean reachedEndOfTopic;
    private int numberOfMessages;

    public FakePulsarReader(String topic, int numberOfMessages) {
        this.numberOfMessages = numberOfMessages;
        this.setMock(topic, numberOfMessages);
    }

    public void setReachedEndOfTopic(boolean hasReachedEnd) {
        this.reachedEndOfTopic = hasReachedEnd;
    }

    public void setMock(String topic, int numberOfMessages) {
        this.topic = topic;
        for (int i = 0; i < numberOfMessages; ++i) {
            long timestamp = Instant.now().plus((ReadableDuration)Duration.standardSeconds((long)i)).getMillis();
            if (i == 0) {
                this.startTimestamp = timestamp;
            } else if (i == 99) {
                this.endTimestamp = timestamp;
            }
            this.fakeMessages.add(new FakeMessage(topic, timestamp, i, i, i));
        }
        this.currentMsg = 0;
    }

    public void reset() {
        this.reachedEndOfTopic = false;
        this.currentMsg = 0;
        this.emptyMockRecords();
        this.setMock(this.topic, this.numberOfMessages);
    }

    public void emptyMockRecords() {
        this.fakeMessages.clear();
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public String getTopic() {
        return this.topic;
    }

    public Message<byte[]> readNext() throws PulsarClientException {
        if (this.currentMsg == 0 && this.fakeMessages.isEmpty()) {
            return null;
        }
        Message msg = this.fakeMessages.get(this.currentMsg);
        if (this.currentMsg <= this.fakeMessages.size() - 1) {
            ++this.currentMsg;
        }
        return msg;
    }

    public Message<byte[]> readNext(int timeout, TimeUnit unit) throws PulsarClientException {
        return null;
    }

    public CompletableFuture<Message<byte[]>> readNextAsync() {
        return null;
    }

    public CompletableFuture<Void> closeAsync() {
        return null;
    }

    public boolean hasReachedEndOfTopic() {
        return this.reachedEndOfTopic;
    }

    public boolean hasMessageAvailable() throws PulsarClientException {
        return false;
    }

    public CompletableFuture<Boolean> hasMessageAvailableAsync() {
        return null;
    }

    public boolean isConnected() {
        return false;
    }

    public void seek(MessageId messageId) throws PulsarClientException {
    }

    public void seek(long timestamp) throws PulsarClientException {
        for (int i = 0; i < this.fakeMessages.size(); ++i) {
            if (timestamp != this.fakeMessages.get(i).getPublishTime()) continue;
            this.currentMsg = i;
            break;
        }
    }

    public CompletableFuture<Void> seekAsync(MessageId messageId) {
        return null;
    }

    public CompletableFuture<Void> seekAsync(long timestamp) {
        return null;
    }

    public CompletableFuture<Void> seekAsync(Function<String, Object> function) {
        return null;
    }

    public void seek(Function<String, Object> function) throws PulsarClientException {
    }

    public void close() throws IOException {
    }
}

