/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.pulsar;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.pulsar.FakePulsarReader;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.ReaderListener;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.transaction.TransactionBuilder;

public class FakePulsarClient
implements PulsarClient {
    private MockReaderBuilder readerBuilder;

    public FakePulsarClient(Reader<byte[]> reader) {
        this.setReader(reader);
    }

    public ProducerBuilder<byte[]> newProducer() {
        return null;
    }

    public <T> ProducerBuilder<T> newProducer(Schema<T> schema) {
        return null;
    }

    public ConsumerBuilder<byte[]> newConsumer() {
        return null;
    }

    public <T> ConsumerBuilder<T> newConsumer(Schema<T> schema) {
        return null;
    }

    public void setReader(Reader<byte[]> reader) {
        this.initReaderBuilder();
        this.readerBuilder.setReader(reader);
    }

    public void initReaderBuilder() {
        if (this.readerBuilder == null) {
            this.readerBuilder = new MockReaderBuilder();
        }
    }

    public ReaderBuilder<byte[]> newReader() {
        this.initReaderBuilder();
        return this.readerBuilder;
    }

    public <T> ReaderBuilder<T> newReader(Schema<T> schema) {
        return null;
    }

    public void updateServiceUrl(String serviceUrl) throws PulsarClientException {
    }

    public void serviceUrl(String serviceUrl) {
    }

    public CompletableFuture<List<String>> getPartitionsForTopic(String topic) {
        return null;
    }

    public void close() throws PulsarClientException {
    }

    public CompletableFuture<Void> closeAsync() {
        return null;
    }

    public void shutdown() throws PulsarClientException {
    }

    public boolean isClosed() {
        return false;
    }

    public TransactionBuilder newTransaction() throws PulsarClientException {
        return null;
    }

    static class MockReaderBuilder
    implements ReaderBuilder<byte[]> {
        private int numberOfMessages = 100;
        private String topic;
        private Reader<byte[]> reader;

        public void setReader(Reader<byte[]> reader) {
            this.reader = reader;
        }

        public Reader<byte[]> create() throws PulsarClientException {
            if (this.reader != null) {
                return this.reader;
            }
            this.reader = new FakePulsarReader(this.topic, this.numberOfMessages);
            return this.reader;
        }

        public CompletableFuture<Reader<byte[]>> createAsync() {
            return null;
        }

        public ReaderBuilder<byte[]> clone() {
            return null;
        }

        public ReaderBuilder<byte[]> topic(String topicName) {
            this.topic = topicName;
            return this;
        }

        public ReaderBuilder<byte[]> startMessageId(MessageId startMessageId) {
            return this;
        }

        public ReaderBuilder<byte[]> startMessageFromRollbackDuration(long rollbackDuration, TimeUnit timeunit) {
            return null;
        }

        public ReaderBuilder<byte[]> startMessageIdInclusive() {
            return null;
        }

        public ReaderBuilder<byte[]> readerListener(ReaderListener readerListener) {
            return null;
        }

        public ReaderBuilder<byte[]> cryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
            return null;
        }

        public ReaderBuilder<byte[]> defaultCryptoKeyReader(String privateKey) {
            return null;
        }

        public ReaderBuilder<byte[]> cryptoFailureAction(ConsumerCryptoFailureAction action) {
            return null;
        }

        public ReaderBuilder<byte[]> receiverQueueSize(int receiverQueueSize) {
            return null;
        }

        public ReaderBuilder<byte[]> readerName(String readerName) {
            return null;
        }

        public ReaderBuilder<byte[]> subscriptionRolePrefix(String subscriptionRolePrefix) {
            return null;
        }

        public ReaderBuilder<byte[]> subscriptionName(String subscriptionName) {
            return null;
        }

        public ReaderBuilder<byte[]> readCompacted(boolean readCompacted) {
            return null;
        }

        public ReaderBuilder<byte[]> keyHashRange(Range ... ranges) {
            return null;
        }

        public ReaderBuilder<byte[]> defaultCryptoKeyReader(Map privateKeys) {
            return null;
        }

        public ReaderBuilder<byte[]> topics(List topicNames) {
            return null;
        }

        public ReaderBuilder<byte[]> loadConf(Map config) {
            return null;
        }
    }
}

