/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.neo4j;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.beam.sdk.io.neo4j.Neo4jIO;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;

public class Neo4jTestUtil {
    public static final String NEO4J_VERSION = "latest";
    public static final String NEO4J_NETWORK_ALIAS = "neo4jcontainer";
    public static final String NEO4J_USERNAME = "neo4j";
    public static final String NEO4J_PASSWORD = "abcdefgh";
    public static final String NEO4J_DATABASE = "neo4j";

    public static final String getUrl(String hostname, int port) {
        return "neo4j://" + hostname + ":" + port;
    }

    public static Driver getDriver(String hostname, int port) throws URISyntaxException {
        return GraphDatabase.routingDriver(Arrays.asList(new URI(Neo4jTestUtil.getUrl(hostname, port))), (AuthToken)AuthTokens.basic((String)"neo4j", (String)NEO4J_PASSWORD), (Config)Config.builder().build());
    }

    public static Session getSession(Driver driver, boolean withDatabase) {
        SessionConfig.Builder builder = SessionConfig.builder();
        if (withDatabase) {
            builder = builder.withDatabase("neo4j");
        }
        return driver.session(builder.build());
    }

    public static Neo4jIO.DriverConfiguration getDriverConfiguration(String hostname, int port) {
        return Neo4jIO.DriverConfiguration.create((String)Neo4jTestUtil.getUrl(hostname, port), (String)"neo4j", (String)NEO4J_PASSWORD);
    }

    public static void executeOnNeo4j(String hostname, int port, String cypher, boolean useDatabase) throws Exception {
        try (Driver driver = Neo4jTestUtil.getDriver(hostname, port);
             Session session = Neo4jTestUtil.getSession(driver, useDatabase);){
            session.run(cypher);
        }
    }
}

