/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.neo4j;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.neo4j.Neo4jIO;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.neo4j.driver.Config;

@RunWith(value=JUnit4.class)
public class Neo4jIOTest {
    @Test
    public void testDriverConfigurationCreate() throws Exception {
        Neo4jIO.DriverConfiguration driverConfiguration = Neo4jIO.DriverConfiguration.create((String)"someUrl", (String)"username", (String)"password");
        Assert.assertEquals((Object)"someUrl", (Object)driverConfiguration.getUrl().get());
        Assert.assertEquals((Object)"username", (Object)driverConfiguration.getUsername().get());
        Assert.assertEquals((Object)"password", (Object)driverConfiguration.getPassword().get());
    }

    @Test
    public void testDriverConfigurationWith() throws Exception {
        Neo4jIO.DriverConfiguration driverConfiguration = Neo4jIO.DriverConfiguration.create();
        Config config = Config.builder().withEncryption().withConnectionAcquisitionTimeout(54321L, TimeUnit.MILLISECONDS).withConnectionTimeout(43210L, TimeUnit.MILLISECONDS).withConnectionLivenessCheckTimeout(32109L, TimeUnit.MILLISECONDS).withMaxConnectionLifetime(21098L, TimeUnit.MILLISECONDS).withMaxConnectionPoolSize(101).build();
        driverConfiguration = driverConfiguration.withConfig(config);
        Config configVerify = driverConfiguration.getConfig();
        Assert.assertNotNull((Object)configVerify);
        Assert.assertEquals((Object)true, (Object)configVerify.encrypted());
        Assert.assertEquals((long)54321L, (long)configVerify.connectionAcquisitionTimeoutMillis());
        Assert.assertEquals((long)43210L, (long)configVerify.connectionTimeoutMillis());
        Assert.assertEquals((long)32109L, (long)configVerify.idleTimeBeforeConnectionTest());
        Assert.assertEquals((long)21098L, (long)configVerify.maxConnectionLifetimeMillis());
        Assert.assertEquals((long)101L, (long)configVerify.maxConnectionPoolSize());
        driverConfiguration = driverConfiguration.withUrl("url1");
        Assert.assertEquals((Object)"url1", (Object)driverConfiguration.getUrl().get());
        driverConfiguration = driverConfiguration.withUrls(Arrays.asList("url2", "url3", "url4"));
        Assert.assertEquals((long)3L, (long)((List)driverConfiguration.getUrls().get()).size());
        driverConfiguration = driverConfiguration.withUsername("username");
        Assert.assertEquals((Object)"username", (Object)driverConfiguration.getUsername().get());
        driverConfiguration = driverConfiguration.withPassword("password");
        Assert.assertEquals((Object)"password", (Object)driverConfiguration.getPassword().get());
    }

    @Test
    public void testDriverConfigurationErrors() throws Exception {
        Neo4jIO.DriverConfiguration driverConfiguration = Neo4jIO.DriverConfiguration.create();
        try {
            driverConfiguration.withUrl((String)null);
            Assert.fail((String)"Null URL is not reported");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            driverConfiguration.withUsername((String)null);
            Assert.fail((String)"Null user is not reported");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            driverConfiguration.withUsername("");
        }
        catch (Exception e) {
            throw new AssertionError("Empty user string should not throw an error", e);
        }
        try {
            driverConfiguration.withPassword((String)null);
            Assert.fail((String)"Null password is not reported");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            driverConfiguration.withPassword("");
        }
        catch (Exception e) {
            throw new AssertionError("Empty password string should not throw an error", e);
        }
    }
}

