/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.neo4j;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.StringUtils;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.neo4j.AutoValue_Neo4jIO_DriverConfiguration;
import org.apache.beam.sdk.io.neo4j.AutoValue_Neo4jIO_ReadAll;
import org.apache.beam.sdk.io.neo4j.AutoValue_Neo4jIO_WriteUnwind;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.TransactionWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class Neo4jIO {
    private static final Logger LOG = LoggerFactory.getLogger(Neo4jIO.class);

    public static <ParameterT, OutputT> ReadAll<ParameterT, OutputT> readAll() {
        return new AutoValue_Neo4jIO_ReadAll.Builder().build();
    }

    public static <ParameterT> WriteUnwind<ParameterT> writeUnwind() {
        return new AutoValue_Neo4jIO_WriteUnwind.Builder().setBatchSize((ValueProvider<Long>)ValueProvider.StaticValueProvider.of((Object)5000L)).build();
    }

    private static <ParameterT, OutputT> PCollection<OutputT> getOutputPCollection(PCollection<ParameterT> input, DoFn<ParameterT, OutputT> writeFn, @Nullable Coder<OutputT> coder) {
        PCollection output = (PCollection)input.apply((PTransform)ParDo.of(writeFn));
        if (coder != null) {
            output.setCoder(coder);
            try {
                TypeDescriptor typeDesc = coder.getEncodedTypeDescriptor();
                SchemaRegistry registry = input.getPipeline().getSchemaRegistry();
                Schema schema = registry.getSchema(typeDesc);
                output.setSchema(schema, typeDesc, registry.getToRowFunction(typeDesc), registry.getFromRowFunction(typeDesc));
            }
            catch (NoSuchSchemaException noSuchSchemaException) {
                // empty catch block
            }
        }
        return output;
    }

    private static <T> T getProvidedValue(@Nullable ValueProvider<T> valueProvider) {
        if (valueProvider == null) {
            return null;
        }
        return (T)valueProvider.get();
    }

    private static class WriteUnwindFn<ParameterT>
    extends ReadWriteFn<ParameterT, Void> {
        private final @NonNull String cypher;
        private final @Nullable SerializableFunction<ParameterT, Map<String, Object>> parametersFunction;
        private final boolean logCypher;
        private final long batchSize;
        private final @NonNull String unwindMapName;
        private long elementsInput;
        private boolean loggingDone;
        private List<Map<String, Object>> unwindList;

        private WriteUnwindFn(@NonNull SerializableFunction<Void, Driver> driverProviderFn, @NonNull SessionConfig sessionConfig, @NonNull TransactionConfig transactionConfig, @NonNull String cypher, @Nullable SerializableFunction<ParameterT, Map<String, Object>> parametersFunction, long batchSize, boolean logCypher, String unwindMapName) {
            super(driverProviderFn, sessionConfig, transactionConfig);
            this.cypher = cypher;
            this.parametersFunction = parametersFunction;
            this.logCypher = logCypher;
            this.batchSize = batchSize;
            this.unwindMapName = unwindMapName;
            this.unwindList = new ArrayList<Map<String, Object>>();
            this.elementsInput = 0L;
            this.loggingDone = false;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            Object parameters = context.element();
            if (this.parametersFunction != null) {
                this.unwindList.add((Map)this.parametersFunction.apply(parameters));
            } else {
                this.unwindList.add(Collections.emptyMap());
            }
            ++this.elementsInput;
            if (this.elementsInput >= this.batchSize) {
                this.executeCypherUnwindStatement();
            }
        }

        private void executeCypherUnwindStatement() {
            if (this.elementsInput == 0L) {
                return;
            }
            HashMap<String, Object> parametersMap = new HashMap<String, Object>();
            parametersMap.put(this.unwindMapName, this.unwindList);
            TransactionWork transactionWork = transaction -> {
                Result result = transaction.run(this.cypher, parametersMap);
                while (result.hasNext()) {
                    result.next();
                }
                return null;
            };
            if (this.logCypher && !this.loggingDone) {
                String parametersString = this.getParametersString(parametersMap);
                LOG.info("Starting a write transaction for unwind statement cypher: " + this.cypher + ", parameters: " + parametersString);
                this.loggingDone = true;
            }
            if (this.driverSession.session == null) {
                throw new RuntimeException("neo4j session was not initialized correctly");
            }
            try {
                this.driverSession.session.writeTransaction(transactionWork, this.transactionConfig);
            }
            catch (Exception e) {
                throw new RuntimeException("Error writing " + this.unwindList.size() + " rows to Neo4j with Cypher: " + this.cypher, e);
            }
            this.unwindList.clear();
            this.elementsInput = 0L;
        }

        @Override
        @DoFn.FinishBundle
        public void finishBundle() {
            this.executeCypherUnwindStatement();
        }
    }

    @AutoValue
    public static abstract class WriteUnwind<ParameterT>
    extends PTransform<PCollection<ParameterT>, PDone> {
        abstract @Nullable SerializableFunction<Void, Driver> getDriverProviderFn();

        abstract @Nullable ValueProvider<SessionConfig> getSessionConfig();

        abstract @Nullable ValueProvider<String> getCypher();

        abstract @Nullable ValueProvider<String> getUnwindMapName();

        abstract @Nullable ValueProvider<TransactionConfig> getTransactionConfig();

        abstract @Nullable SerializableFunction<ParameterT, Map<String, Object>> getParametersFunction();

        abstract @Nullable ValueProvider<Long> getBatchSize();

        abstract @Nullable ValueProvider<Boolean> getLogCypher();

        abstract Builder<ParameterT> toBuilder();

        public WriteUnwind<ParameterT> withDriverConfiguration(DriverConfiguration config) {
            return this.toBuilder().setDriverProviderFn(new DriverProviderFromDriverConfiguration(config)).build();
        }

        public WriteUnwind<ParameterT> withCypher(String cypher) {
            Preconditions.checkArgument((cypher != null ? 1 : 0) != 0, (Object)"Neo4jIO.writeUnwind().withCypher(cypher) called with null cypher");
            return this.withCypher((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)cypher));
        }

        public WriteUnwind<ParameterT> withCypher(ValueProvider<String> cypher) {
            Preconditions.checkArgument((cypher != null ? 1 : 0) != 0, (Object)"Neo4jIO.writeUnwind().withCypher(cypher) called with null cypher");
            return this.toBuilder().setCypher(cypher).build();
        }

        public WriteUnwind<ParameterT> withUnwindMapName(String mapName) {
            Preconditions.checkArgument((mapName != null ? 1 : 0) != 0, (Object)"Neo4jIO.writeUnwind().withUnwindMapName(mapName) called with null mapName");
            return this.withUnwindMapName((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)mapName));
        }

        public WriteUnwind<ParameterT> withUnwindMapName(ValueProvider<String> mapName) {
            Preconditions.checkArgument((mapName != null ? 1 : 0) != 0, (Object)"Neo4jIO.writeUnwind().withUnwindMapName(mapName) called with null mapName");
            return this.toBuilder().setUnwindMapName(mapName).build();
        }

        public WriteUnwind<ParameterT> withTransactionConfig(TransactionConfig transactionConfig) {
            Preconditions.checkArgument((transactionConfig != null ? 1 : 0) != 0, (Object)"Neo4jIO.writeUnwind().withTransactionConfig(transactionConfig) called with null transactionConfig");
            return this.withTransactionConfig((ValueProvider<TransactionConfig>)ValueProvider.StaticValueProvider.of((Object)transactionConfig));
        }

        public WriteUnwind<ParameterT> withTransactionConfig(ValueProvider<TransactionConfig> transactionConfig) {
            Preconditions.checkArgument((transactionConfig != null ? 1 : 0) != 0, (Object)"Neo4jIO.writeUnwind().withTransactionConfig(transactionConfig) called with null transactionConfig");
            return this.toBuilder().setTransactionConfig(transactionConfig).build();
        }

        public WriteUnwind<ParameterT> withSessionConfig(SessionConfig sessionConfig) {
            Preconditions.checkArgument((sessionConfig != null ? 1 : 0) != 0, (Object)"Neo4jIO.writeUnwind().withSessionConfig(sessionConfig) called with null sessionConfig");
            return this.withSessionConfig((ValueProvider<SessionConfig>)ValueProvider.StaticValueProvider.of((Object)sessionConfig));
        }

        public WriteUnwind<ParameterT> withSessionConfig(ValueProvider<SessionConfig> sessionConfig) {
            Preconditions.checkArgument((sessionConfig != null ? 1 : 0) != 0, (Object)"Neo4jIO.writeUnwind().withSessionConfig(sessionConfig) called with null sessionConfig");
            return this.toBuilder().setSessionConfig(sessionConfig).build();
        }

        public WriteUnwind<ParameterT> withBatchSize(long batchSize) {
            Preconditions.checkArgument((batchSize > 0L ? 1 : 0) != 0, (Object)"Neo4jIO.writeUnwind().withBatchSize(batchSize) called with batchSize<=0");
            return this.withBatchSize((ValueProvider<Long>)ValueProvider.StaticValueProvider.of((Object)batchSize));
        }

        public WriteUnwind<ParameterT> withBatchSize(ValueProvider<Long> batchSize) {
            Preconditions.checkArgument((batchSize != null && (Long)batchSize.get() >= 0L ? 1 : 0) != 0, (Object)"Neo4jIO.readAll().withBatchSize(batchSize) called with batchSize<=0");
            return this.toBuilder().setBatchSize(batchSize).build();
        }

        public WriteUnwind<ParameterT> withParametersFunction(SerializableFunction<ParameterT, Map<String, Object>> parametersFunction) {
            Preconditions.checkArgument((parametersFunction != null ? 1 : 0) != 0, (Object)"Neo4jIO.readAll().withParametersFunction(parametersFunction) called with null parametersFunction");
            return this.toBuilder().setParametersFunction(parametersFunction).build();
        }

        public WriteUnwind<ParameterT> withCypherLogging() {
            return this.toBuilder().setLogCypher((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)Boolean.TRUE)).build();
        }

        public PDone expand(PCollection<ParameterT> input) {
            Boolean logCypher;
            String cypher;
            TransactionConfig transactionConfig;
            SerializableFunction<Void, Driver> driverProviderFn = this.getDriverProviderFn();
            SerializableFunction<ParameterT, Map<String, Object>> parametersFunction = this.getParametersFunction();
            SessionConfig sessionConfig = (SessionConfig)Neo4jIO.getProvidedValue(this.getSessionConfig());
            if (sessionConfig == null) {
                sessionConfig = SessionConfig.defaultConfig();
            }
            if ((transactionConfig = (TransactionConfig)Neo4jIO.getProvidedValue(this.getTransactionConfig())) == null) {
                transactionConfig = TransactionConfig.empty();
            }
            Preconditions.checkArgument(((cypher = (String)Neo4jIO.getProvidedValue(this.getCypher())) != null ? 1 : 0) != 0, (Object)"please provide an unwind cypher statement to execute");
            String unwindMapName = (String)Neo4jIO.getProvidedValue(this.getUnwindMapName());
            Preconditions.checkArgument((unwindMapName != null ? 1 : 0) != 0, (Object)"please provide an unwind map name");
            Long batchSize = (Long)Neo4jIO.getProvidedValue(this.getBatchSize());
            if (batchSize == null || batchSize <= 0L) {
                batchSize = 5000L;
            }
            if ((logCypher = (Boolean)Neo4jIO.getProvidedValue(this.getLogCypher())) == null) {
                logCypher = Boolean.FALSE;
            }
            if (driverProviderFn == null) {
                throw new RuntimeException("please provide a driver provider");
            }
            if (parametersFunction == null) {
                throw new RuntimeException("please provide a parameters function");
            }
            WriteUnwindFn writeFn = new WriteUnwindFn(driverProviderFn, sessionConfig, transactionConfig, cypher, parametersFunction, batchSize, logCypher, unwindMapName);
            input.apply((PTransform)ParDo.of(writeFn));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"cypher", this.getCypher()));
            SerializableFunction<Void, Driver> driverProviderFn = this.getDriverProviderFn();
            if (driverProviderFn != null && driverProviderFn instanceof HasDisplayData) {
                ((HasDisplayData)driverProviderFn).populateDisplayData(builder);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<ParameterT> {
            Builder() {
            }

            abstract Builder<ParameterT> setDriverProviderFn(SerializableFunction<Void, Driver> var1);

            abstract Builder<ParameterT> setSessionConfig(ValueProvider<SessionConfig> var1);

            abstract Builder<ParameterT> setTransactionConfig(ValueProvider<TransactionConfig> var1);

            abstract Builder<ParameterT> setCypher(ValueProvider<String> var1);

            abstract Builder<ParameterT> setUnwindMapName(ValueProvider<String> var1);

            abstract Builder<ParameterT> setParametersFunction(SerializableFunction<ParameterT, Map<String, Object>> var1);

            abstract Builder<ParameterT> setBatchSize(ValueProvider<Long> var1);

            abstract Builder<ParameterT> setLogCypher(ValueProvider<Boolean> var1);

            abstract WriteUnwind<ParameterT> build();
        }
    }

    public static class DriverProviderFromDriverConfiguration
    implements SerializableFunction<Void, Driver>,
    HasDisplayData {
        private final DriverConfiguration config;

        private DriverProviderFromDriverConfiguration(DriverConfiguration config) {
            this.config = config;
        }

        public static SerializableFunction<Void, Driver> of(DriverConfiguration config) {
            return new DriverProviderFromDriverConfiguration(config);
        }

        public Driver apply(Void input) {
            return this.config.buildDriver();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.config.populateDisplayData(builder);
        }
    }

    private static class ReadFn<ParameterT, OutputT>
    extends ReadWriteFn<ParameterT, OutputT> {
        protected final @NonNull String cypher;
        protected final @NonNull RowMapper<OutputT> rowMapper;
        protected final @Nullable SerializableFunction<ParameterT, Map<String, Object>> parametersFunction;
        private final boolean writeTransaction;
        private final boolean logCypher;

        private ReadFn(@NonNull SerializableFunction<Void, Driver> driverProviderFn, @NonNull SessionConfig sessionConfig, @NonNull TransactionConfig transactionConfig, @NonNull String cypher, @NonNull RowMapper<OutputT> rowMapper, @Nullable SerializableFunction<ParameterT, Map<String, Object>> parametersFunction, boolean writeTransaction, boolean logCypher) {
            super(driverProviderFn, sessionConfig, transactionConfig);
            this.cypher = cypher;
            this.rowMapper = rowMapper;
            this.parametersFunction = parametersFunction;
            this.writeTransaction = writeTransaction;
            this.logCypher = logCypher;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            Object parameters = context.element();
            Map parametersMap = this.parametersFunction != null ? (Map)this.parametersFunction.apply(parameters) : Collections.emptyMap();
            this.executeReadCypherStatement(context, parametersMap);
        }

        private void executeReadCypherStatement(DoFn.ProcessContext processContext, Map<String, Object> parametersMap) {
            TransactionWork transactionWork = transaction -> {
                Result result = transaction.run(this.cypher, parametersMap);
                while (result.hasNext()) {
                    Record record = result.next();
                    try {
                        OutputT outputT = this.rowMapper.mapRow(record);
                        processContext.output(outputT);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("error mapping Neo4j record to row", e);
                    }
                }
                return null;
            };
            if (this.logCypher) {
                String parametersString = this.getParametersString(parametersMap);
                String readWrite = this.writeTransaction ? "write" : "read";
                LOG.info("Starting a " + readWrite + " transaction for cypher: " + this.cypher + ", parameters: " + parametersString);
            }
            if (this.driverSession.session == null) {
                throw new RuntimeException("neo4j session was not initialized correctly");
            }
            if (this.writeTransaction) {
                this.driverSession.session.writeTransaction(transactionWork, this.transactionConfig);
            } else {
                this.driverSession.session.readTransaction(transactionWork, this.transactionConfig);
            }
        }
    }

    private static class ReadWriteFn<ParameterT, OutputT>
    extends DoFn<ParameterT, OutputT> {
        protected final @NonNull SerializableFunction<Void, Driver> driverProviderFn;
        protected final @NonNull SessionConfig sessionConfig;
        protected final @NonNull TransactionConfig transactionConfig;
        protected transient @NonNull DriverSession driverSession;

        protected ReadWriteFn(@NonNull SerializableFunction<Void, Driver> driverProviderFn, @NonNull SessionConfig sessionConfig, @NonNull TransactionConfig transactionConfig) {
            this.driverProviderFn = driverProviderFn;
            this.sessionConfig = sessionConfig;
            this.transactionConfig = transactionConfig;
            this.driverSession = DriverSession.emptyClosed();
        }

        @DoFn.Setup
        public void setup() {
        }

        protected @NonNull Driver createDriver() {
            Driver driver = (Driver)this.driverProviderFn.apply(null);
            if (driver == null) {
                throw new RuntimeException("null driver given by driver provider");
            }
            return driver;
        }

        protected @Initialized @NonNull DriverSession buildDriverSession() {
            @NonNull Driver driver = this.createDriver();
            @NonNull Session session = driver.session(this.sessionConfig);
            return new DriverSession(driver, session);
        }

        @DoFn.StartBundle
        public void startBundle() {
            if (this.driverSession == null || this.driverSession.closed.get()) {
                this.driverSession = this.buildDriverSession();
            }
        }

        @DoFn.FinishBundle
        public void finishBundle() {
            this.cleanUpDriverSession();
        }

        protected void finalize() {
            this.cleanUpDriverSession();
        }

        protected void cleanUpDriverSession() {
            if (!this.driverSession.closed.get()) {
                try {
                    if (this.driverSession.session != null) {
                        this.driverSession.session.close();
                    }
                    if (this.driverSession.driver != null) {
                        this.driverSession.driver.close();
                    }
                }
                finally {
                    this.driverSession.closed.set(true);
                }
            }
        }

        protected String getParametersString(Map<String, Object> parametersMap) {
            StringBuilder parametersString = new StringBuilder();
            parametersMap.keySet().forEach(key -> {
                if (parametersString.length() > 0) {
                    parametersString.append(',');
                }
                parametersString.append((String)key).append('=');
                Object value = parametersMap.get(key);
                if (value == null) {
                    parametersString.append("<null>");
                } else {
                    parametersString.append(value);
                }
            });
            return parametersString.toString();
        }

        protected static class DriverSession {
            public @Nullable Driver driver;
            public @Nullable Session session;
            public @NonNull AtomicBoolean closed;

            protected DriverSession(Driver driver, Session session) {
                this.driver = driver;
                this.session = session;
                this.closed = new AtomicBoolean(false);
            }

            private DriverSession() {
                this.driver = null;
                this.session = null;
                this.closed = new AtomicBoolean(true);
            }

            protected static @NonNull DriverSession emptyClosed() {
                return new DriverSession();
            }
        }
    }

    @AutoValue
    public static abstract class ReadAll<ParameterT, OutputT>
    extends PTransform<PCollection<ParameterT>, PCollection<OutputT>> {
        abstract @Nullable SerializableFunction<Void, Driver> getDriverProviderFn();

        abstract @Nullable SessionConfig getSessionConfig();

        abstract @Nullable TransactionConfig getTransactionConfig();

        abstract @Nullable ValueProvider<String> getCypher();

        abstract @Nullable ValueProvider<Boolean> getWriteTransaction();

        abstract @Nullable RowMapper<OutputT> getRowMapper();

        abstract @Nullable SerializableFunction<ParameterT, Map<String, Object>> getParametersFunction();

        abstract @Nullable Coder<OutputT> getCoder();

        abstract @Nullable ValueProvider<Boolean> getLogCypher();

        abstract Builder<ParameterT, OutputT> toBuilder();

        public ReadAll<ParameterT, OutputT> withDriverConfiguration(DriverConfiguration config) {
            return this.toBuilder().setDriverProviderFn(new DriverProviderFromDriverConfiguration(config)).build();
        }

        public ReadAll<ParameterT, OutputT> withCypher(String cypher) {
            Preconditions.checkArgument((cypher != null ? 1 : 0) != 0, (Object)"Neo4jIO.readAll().withCypher(cypher) called with null cypher");
            return this.withCypher((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)cypher));
        }

        public ReadAll<ParameterT, OutputT> withCypher(ValueProvider<String> cypher) {
            Preconditions.checkArgument((cypher != null ? 1 : 0) != 0, (Object)"Neo4jIO.readAll().withCypher(cypher) called with null cypher");
            return this.toBuilder().setCypher(cypher).build();
        }

        public ReadAll<ParameterT, OutputT> withSessionConfig(SessionConfig sessionConfig) {
            Preconditions.checkArgument((sessionConfig != null ? 1 : 0) != 0, (Object)"Neo4jIO.readAll().withSessionConfig(sessionConfig) called with null sessionConfig");
            return this.toBuilder().setSessionConfig(sessionConfig).build();
        }

        public ReadAll<ParameterT, OutputT> withTransactionConfig(TransactionConfig transactionConfig) {
            Preconditions.checkArgument((transactionConfig != null ? 1 : 0) != 0, (Object)"Neo4jIO.readAll().withTransactionConfig(transactionConfig) called with null transactionConfig");
            return this.toBuilder().setTransactionConfig(transactionConfig).build();
        }

        public ReadAll<ParameterT, OutputT> withRowMapper(RowMapper<OutputT> rowMapper) {
            Preconditions.checkArgument((rowMapper != null ? 1 : 0) != 0, (Object)"Neo4jIO.readAll().withRowMapper(rowMapper) called with null rowMapper");
            return this.toBuilder().setRowMapper(rowMapper).build();
        }

        public ReadAll<ParameterT, OutputT> withParametersFunction(SerializableFunction<ParameterT, Map<String, Object>> parametersFunction) {
            Preconditions.checkArgument((parametersFunction != null ? 1 : 0) != 0, (Object)"Neo4jIO.readAll().withParametersFunction(parametersFunction) called with null parametersFunction");
            return this.toBuilder().setParametersFunction(parametersFunction).build();
        }

        public ReadAll<ParameterT, OutputT> withCoder(Coder<OutputT> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"Neo4jIO.readAll().withCoder(coder) called with null coder");
            return this.toBuilder().setCoder(coder).build();
        }

        public ReadAll<ParameterT, OutputT> withReadTransaction() {
            return this.toBuilder().setWriteTransaction((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)Boolean.FALSE)).build();
        }

        public ReadAll<ParameterT, OutputT> withWriteTransaction() {
            return this.toBuilder().setWriteTransaction((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)Boolean.TRUE)).build();
        }

        public ReadAll<ParameterT, OutputT> withCypherLogging() {
            return this.toBuilder().setLogCypher((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)Boolean.TRUE)).build();
        }

        public PCollection<OutputT> expand(PCollection<ParameterT> input) {
            Boolean logCypher;
            Boolean writeTransaction;
            TransactionConfig transactionConfig;
            SerializableFunction<Void, Driver> driverProviderFn = this.getDriverProviderFn();
            RowMapper<OutputT> rowMapper = this.getRowMapper();
            SerializableFunction & Serializable parametersFunction = this.getParametersFunction();
            String cypher = (String)Neo4jIO.getProvidedValue(this.getCypher());
            Preconditions.checkArgument((cypher != null ? 1 : 0) != 0, (Object)"please provide a cypher statement to execute");
            SessionConfig sessionConfig = this.getSessionConfig();
            if (sessionConfig == null) {
                sessionConfig = SessionConfig.defaultConfig();
            }
            if ((transactionConfig = this.getTransactionConfig()) == null) {
                transactionConfig = TransactionConfig.empty();
            }
            if ((writeTransaction = (Boolean)Neo4jIO.getProvidedValue(this.getWriteTransaction())) == null) {
                writeTransaction = Boolean.FALSE;
            }
            if ((logCypher = (Boolean)Neo4jIO.getProvidedValue(this.getLogCypher())) == null) {
                logCypher = Boolean.FALSE;
            }
            if (driverProviderFn == null) {
                throw new RuntimeException("please provide a driver provider");
            }
            if (rowMapper == null) {
                throw new RuntimeException("please provide a row mapper");
            }
            if (parametersFunction == null) {
                parametersFunction = (SerializableFunction & Serializable)t -> Collections.emptyMap();
            }
            ReadFn readFn = new ReadFn(driverProviderFn, sessionConfig, transactionConfig, cypher, rowMapper, parametersFunction, writeTransaction, logCypher);
            return Neo4jIO.getOutputPCollection(input, readFn, this.getCoder());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            String cypher = (String)Neo4jIO.getProvidedValue(this.getCypher());
            if (cypher == null) {
                cypher = "";
            }
            builder.add(DisplayData.item((String)"cypher", (String)cypher));
            SerializableFunction<Void, Driver> driverProviderFn = this.getDriverProviderFn();
            if (driverProviderFn != null && driverProviderFn instanceof HasDisplayData) {
                ((HasDisplayData)driverProviderFn).populateDisplayData(builder);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<ParameterT, OutputT> {
            Builder() {
            }

            abstract Builder<ParameterT, OutputT> setDriverProviderFn(SerializableFunction<Void, Driver> var1);

            abstract Builder<ParameterT, OutputT> setCypher(ValueProvider<String> var1);

            abstract Builder<ParameterT, OutputT> setSessionConfig(SessionConfig var1);

            abstract Builder<ParameterT, OutputT> setTransactionConfig(TransactionConfig var1);

            abstract Builder<ParameterT, OutputT> setWriteTransaction(ValueProvider<Boolean> var1);

            abstract Builder<ParameterT, OutputT> setRowMapper(RowMapper<OutputT> var1);

            abstract Builder<ParameterT, OutputT> setParametersFunction(SerializableFunction<ParameterT, Map<String, Object>> var1);

            abstract Builder<ParameterT, OutputT> setCoder(Coder<OutputT> var1);

            abstract Builder<ParameterT, OutputT> setLogCypher(ValueProvider<Boolean> var1);

            abstract ReadAll<ParameterT, OutputT> build();
        }
    }

    @AutoValue
    public static abstract class DriverConfiguration
    implements Serializable {
        public static DriverConfiguration create() {
            return new AutoValue_Neo4jIO_DriverConfiguration.Builder().build().withDefaultConfig(true).withConfig(Config.defaultConfig());
        }

        public static DriverConfiguration create(String url, String username, String password) {
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url can not be null");
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"username can not be null");
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"password can not be null");
            return new AutoValue_Neo4jIO_DriverConfiguration.Builder().build().withDefaultConfig(true).withConfig(Config.defaultConfig()).withUrl(url).withUsername(username).withPassword(password);
        }

        abstract @Nullable ValueProvider<String> getUrl();

        abstract @Nullable ValueProvider<List<String>> getUrls();

        abstract @Nullable ValueProvider<String> getUsername();

        abstract @Nullable ValueProvider<String> getPassword();

        abstract @Nullable Config getConfig();

        abstract @Nullable ValueProvider<Boolean> getHasDefaultConfig();

        abstract Builder builder();

        public DriverConfiguration withUrl(String url) {
            return this.withUrl((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)url));
        }

        public DriverConfiguration withUrl(ValueProvider<String> url) {
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (String)"a neo4j connection URL can not be empty or null", url);
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)((CharSequence)url.get())), (String)"a neo4j connection URL can not be empty or null", url);
            return this.builder().setUrl(url).build();
        }

        public DriverConfiguration withUrls(List<String> urls) {
            return this.withUrls((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(urls));
        }

        public DriverConfiguration withUrls(ValueProvider<List<String>> urls) {
            Preconditions.checkArgument((urls != null ? 1 : 0) != 0, (String)"a list of neo4j connection URLs can not be empty or null", urls);
            Preconditions.checkArgument((urls.get() != null && !((List)urls.get()).isEmpty() ? 1 : 0) != 0, (String)"a neo4j connection URL can not be empty or null", urls);
            return this.builder().setUrls(urls).build();
        }

        public DriverConfiguration withConfig(Config config) {
            return this.builder().setConfig(config).build();
        }

        public DriverConfiguration withUsername(String username) {
            return this.withUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username));
        }

        public DriverConfiguration withUsername(ValueProvider<String> username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (String)"neo4j username can not be null", username);
            Preconditions.checkArgument((username.get() != null ? 1 : 0) != 0, (String)"neo4j username can not be null", username);
            return this.builder().setUsername(username).build();
        }

        public DriverConfiguration withPassword(String password) {
            return this.withPassword((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)password));
        }

        public DriverConfiguration withPassword(ValueProvider<String> password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (String)"neo4j password can not be null", password);
            Preconditions.checkArgument((password.get() != null ? 1 : 0) != 0, (String)"neo4j password can not be null", password);
            return this.builder().setPassword(password).build();
        }

        public DriverConfiguration withDefaultConfig(boolean useDefault) {
            return this.withDefaultConfig((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)useDefault));
        }

        public DriverConfiguration withDefaultConfig(ValueProvider<Boolean> useDefault) {
            Preconditions.checkArgument((useDefault != null ? 1 : 0) != 0, (String)"withDefaultConfig parameter useDefault can not be null", useDefault);
            Preconditions.checkArgument((useDefault.get() != null ? 1 : 0) != 0, (String)"withDefaultConfig parameter useDefault can not be null", useDefault);
            return this.builder().setHasDefaultConfig(useDefault).build();
        }

        void populateDisplayData(DisplayData.Builder builder) {
            builder.addIfNotNull(DisplayData.item((String)"neo4j-url", this.getUrl()));
            builder.addIfNotNull(DisplayData.item((String)"neo4j-username", this.getUsername()));
            builder.addIfNotNull(DisplayData.item((String)"neo4j-password", (String)(this.getPassword() != null ? "<provided>" : "<not-provided>")));
        }

        Driver buildDriver() {
            List providedUrls;
            Config config = this.getConfig();
            if (config == null) {
                throw new RuntimeException("please provide a neo4j config");
            }
            Boolean hasDefaultConfig = (Boolean)Neo4jIO.getProvidedValue(this.getHasDefaultConfig());
            if (hasDefaultConfig != null && hasDefaultConfig.booleanValue()) {
                config = Config.defaultConfig();
            }
            ArrayList<URI> uris = new ArrayList<URI>();
            String url = (String)Neo4jIO.getProvidedValue(this.getUrl());
            if (url != null) {
                try {
                    uris.add(new URI(url));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Error creating URI from URL '" + url + "'", e);
                }
            }
            if ((providedUrls = (List)Neo4jIO.getProvidedValue(this.getUrls())) != null) {
                for (String providedUrl : providedUrls) {
                    try {
                        uris.add(new URI(providedUrl));
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException("Error creating URI '" + providedUrl + "' from a list of " + providedUrls.size() + " URLs", e);
                    }
                }
            }
            AuthToken authTokens = this.getAuthToken((String)Neo4jIO.getProvidedValue(this.getUsername()), (String)Neo4jIO.getProvidedValue(this.getPassword()));
            Driver driver = uris.size() > 1 ? GraphDatabase.routingDriver(uris, (AuthToken)authTokens, (Config)config) : GraphDatabase.driver((URI)((URI)uris.get(0)), (AuthToken)authTokens, (Config)config);
            return driver;
        }

        protected AuthToken getAuthToken(String username, String password) {
            if (username != null && password != null) {
                return AuthTokens.basic((String)username, (String)password);
            }
            return AuthTokens.none();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setUrl(ValueProvider<String> var1);

            abstract Builder setUrls(ValueProvider<List<String>> var1);

            abstract Builder setUsername(ValueProvider<String> var1);

            abstract Builder setPassword(ValueProvider<String> var1);

            abstract Builder setConfig(Config var1);

            abstract Builder setHasDefaultConfig(ValueProvider<Boolean> var1);

            abstract DriverConfiguration build();
        }
    }

    @FunctionalInterface
    public static interface RowMapper<T>
    extends Serializable {
        public T mapRow(Record var1) throws Exception;
    }
}

