
package org.apache.beam.sdk.io.mqtt;

import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_MqttIO_Read extends MqttIO.Read {

  private final MqttIO.ConnectionConfiguration connectionConfiguration;
  private final long maxNumRecords;
  private final Duration maxReadTime;

  private AutoValue_MqttIO_Read(
      @Nullable MqttIO.ConnectionConfiguration connectionConfiguration,
      long maxNumRecords,
      @Nullable Duration maxReadTime) {
    this.connectionConfiguration = connectionConfiguration;
    this.maxNumRecords = maxNumRecords;
    this.maxReadTime = maxReadTime;
  }

  @Nullable
  @Override
  MqttIO.ConnectionConfiguration connectionConfiguration() {
    return connectionConfiguration;
  }

  @Override
  long maxNumRecords() {
    return maxNumRecords;
  }

  @Nullable
  @Override
  Duration maxReadTime() {
    return maxReadTime;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MqttIO.Read) {
      MqttIO.Read that = (MqttIO.Read) o;
      return ((this.connectionConfiguration == null) ? (that.connectionConfiguration() == null) : this.connectionConfiguration.equals(that.connectionConfiguration()))
           && (this.maxNumRecords == that.maxNumRecords())
           && ((this.maxReadTime == null) ? (that.maxReadTime() == null) : this.maxReadTime.equals(that.maxReadTime()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (connectionConfiguration == null) ? 0 : this.connectionConfiguration.hashCode();
    h *= 1000003;
    h ^= (int) ((this.maxNumRecords >>> 32) ^ this.maxNumRecords);
    h *= 1000003;
    h ^= (maxReadTime == null) ? 0 : this.maxReadTime.hashCode();
    return h;
  }

  @Override
  MqttIO.Read.Builder builder() {
    return new Builder(this);
  }

  static final class Builder extends MqttIO.Read.Builder {
    private MqttIO.ConnectionConfiguration connectionConfiguration;
    private Long maxNumRecords;
    private Duration maxReadTime;
    Builder() {
    }
    private Builder(MqttIO.Read source) {
      this.connectionConfiguration = source.connectionConfiguration();
      this.maxNumRecords = source.maxNumRecords();
      this.maxReadTime = source.maxReadTime();
    }
    @Override
    MqttIO.Read.Builder setConnectionConfiguration(@Nullable MqttIO.ConnectionConfiguration connectionConfiguration) {
      this.connectionConfiguration = connectionConfiguration;
      return this;
    }
    @Override
    MqttIO.Read.Builder setMaxNumRecords(long maxNumRecords) {
      this.maxNumRecords = maxNumRecords;
      return this;
    }
    @Override
    MqttIO.Read.Builder setMaxReadTime(@Nullable Duration maxReadTime) {
      this.maxReadTime = maxReadTime;
      return this;
    }
    @Override
    MqttIO.Read build() {
      String missing = "";
      if (this.maxNumRecords == null) {
        missing += " maxNumRecords";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MqttIO_Read(
          this.connectionConfiguration,
          this.maxNumRecords,
          this.maxReadTime);
    }
  }

}
