/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import com.google.common.collect.ImmutableMap;
import com.mongodb.MongoClient;
import java.util.Date;
import java.util.Map;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.common.HashingFn;
import org.apache.beam.sdk.io.common.IOITHelper;
import org.apache.beam.sdk.io.common.IOTestPipelineOptions;
import org.apache.beam.sdk.io.mongodb.MongoDbIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.bson.Document;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MongoDBIOIT {
    private static final Map<Integer, String> EXPECTED_HASHES = ImmutableMap.of((Object)1000, (Object)"75a0d5803418444e76ae5b421662764c", (Object)100000, (Object)"3bc762dc1c291904e3c7f577774c6276", (Object)10000000, (Object)"e5e0503902018c83e8c8977ef437feba");
    private static MongoDBPipelineOptions options;
    private static String collection;
    @Rule
    public final TestPipeline writePipeline = TestPipeline.create();
    @Rule
    public final TestPipeline readPipeline = TestPipeline.create();

    @BeforeClass
    public static void setUp() {
        PipelineOptionsFactory.register(MongoDBPipelineOptions.class);
        options = (MongoDBPipelineOptions)TestPipeline.testingPipelineOptions().as(MongoDBPipelineOptions.class);
        collection = String.format("test_%s", new Date().getTime());
    }

    @AfterClass
    public static void tearDown() {
        new MongoClient(options.getMongoDBHostName()).getDatabase(options.getMongoDBDatabaseName()).drop();
    }

    @Test
    public void testWriteAndRead() {
        String mongoUrl = String.format("mongodb://%s:%s", options.getMongoDBHostName(), options.getMongoDBPort());
        ((PCollection)((PCollection)this.writePipeline.apply("Generate sequence", (PTransform)GenerateSequence.from((long)0L).to((long)options.getNumberOfRecords().intValue()))).apply("Produce documents", (PTransform)MapElements.via((SimpleFunction)new LongToDocumentFn()))).apply("Write documents to MongoDB", (PTransform)MongoDbIO.write().withUri(mongoUrl).withDatabase(options.getMongoDBDatabaseName()).withCollection(collection));
        this.writePipeline.run().waitUntilFinish();
        PCollection consolidatedHashcode = (PCollection)((PCollection)((PCollection)this.readPipeline.apply("Read all documents", (PTransform)MongoDbIO.read().withUri(mongoUrl).withDatabase(options.getMongoDBDatabaseName()).withCollection(collection))).apply("Map documents to Strings", (PTransform)MapElements.via((SimpleFunction)new DocumentToStringFn()))).apply("Calculate hashcode", (PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new HashingFn()));
        String expectedHash = IOITHelper.getHashForRecordCount((int)options.getNumberOfRecords(), EXPECTED_HASHES);
        PAssert.thatSingleton((PCollection)consolidatedHashcode).isEqualTo((Object)expectedHash);
        this.readPipeline.run().waitUntilFinish();
    }

    private static class DocumentToStringFn
    extends SimpleFunction<Document, String> {
        private DocumentToStringFn() {
        }

        public String apply(Document input) {
            return input.getString((Object)"scientist");
        }
    }

    private static class LongToDocumentFn
    extends SimpleFunction<Long, Document> {
        private LongToDocumentFn() {
        }

        public Document apply(Long input) {
            return Document.parse((String)String.format("{\"scientist\":\"Test %s\"}", input));
        }
    }

    public static interface MongoDBPipelineOptions
    extends IOTestPipelineOptions {
        @Description(value="MongoDB host (host name/ip address)")
        @Default.String(value="mongodb-host")
        public String getMongoDBHostName();

        public void setMongoDBHostName(String var1);

        @Description(value="Port for MongoDB")
        @Default.Integer(value=27017)
        public Integer getMongoDBPort();

        public void setMongoDBPort(Integer var1);

        @Description(value="Mongo database name")
        @Default.String(value="beam")
        public String getMongoDBDatabaseName();

        public void setMongoDBDatabaseName(String var1);
    }
}

