
package org.apache.beam.sdk.io.mongodb;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_MongoDbIO_Write extends MongoDbIO.Write {

  private final String uri;
  private final boolean keepAlive;
  private final int maxConnectionIdleTime;
  private final String database;
  private final String collection;
  private final long batchSize;

  private AutoValue_MongoDbIO_Write(
      @Nullable String uri,
      boolean keepAlive,
      int maxConnectionIdleTime,
      @Nullable String database,
      @Nullable String collection,
      long batchSize) {
    this.uri = uri;
    this.keepAlive = keepAlive;
    this.maxConnectionIdleTime = maxConnectionIdleTime;
    this.database = database;
    this.collection = collection;
    this.batchSize = batchSize;
  }

  @Nullable
  @Override
  String uri() {
    return uri;
  }

  @Override
  boolean keepAlive() {
    return keepAlive;
  }

  @Override
  int maxConnectionIdleTime() {
    return maxConnectionIdleTime;
  }

  @Nullable
  @Override
  String database() {
    return database;
  }

  @Nullable
  @Override
  String collection() {
    return collection;
  }

  @Override
  long batchSize() {
    return batchSize;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MongoDbIO.Write) {
      MongoDbIO.Write that = (MongoDbIO.Write) o;
      return ((this.uri == null) ? (that.uri() == null) : this.uri.equals(that.uri()))
           && (this.keepAlive == that.keepAlive())
           && (this.maxConnectionIdleTime == that.maxConnectionIdleTime())
           && ((this.database == null) ? (that.database() == null) : this.database.equals(that.database()))
           && ((this.collection == null) ? (that.collection() == null) : this.collection.equals(that.collection()))
           && (this.batchSize == that.batchSize());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (uri == null) ? 0 : this.uri.hashCode();
    h *= 1000003;
    h ^= this.keepAlive ? 1231 : 1237;
    h *= 1000003;
    h ^= this.maxConnectionIdleTime;
    h *= 1000003;
    h ^= (database == null) ? 0 : this.database.hashCode();
    h *= 1000003;
    h ^= (collection == null) ? 0 : this.collection.hashCode();
    h *= 1000003;
    h ^= (int) ((this.batchSize >>> 32) ^ this.batchSize);
    return h;
  }

  @Override
  MongoDbIO.Write.Builder builder() {
    return new Builder(this);
  }

  static final class Builder extends MongoDbIO.Write.Builder {
    private String uri;
    private Boolean keepAlive;
    private Integer maxConnectionIdleTime;
    private String database;
    private String collection;
    private Long batchSize;
    Builder() {
    }
    private Builder(MongoDbIO.Write source) {
      this.uri = source.uri();
      this.keepAlive = source.keepAlive();
      this.maxConnectionIdleTime = source.maxConnectionIdleTime();
      this.database = source.database();
      this.collection = source.collection();
      this.batchSize = source.batchSize();
    }
    @Override
    MongoDbIO.Write.Builder setUri(@Nullable String uri) {
      this.uri = uri;
      return this;
    }
    @Override
    MongoDbIO.Write.Builder setKeepAlive(boolean keepAlive) {
      this.keepAlive = keepAlive;
      return this;
    }
    @Override
    MongoDbIO.Write.Builder setMaxConnectionIdleTime(int maxConnectionIdleTime) {
      this.maxConnectionIdleTime = maxConnectionIdleTime;
      return this;
    }
    @Override
    MongoDbIO.Write.Builder setDatabase(@Nullable String database) {
      this.database = database;
      return this;
    }
    @Override
    MongoDbIO.Write.Builder setCollection(@Nullable String collection) {
      this.collection = collection;
      return this;
    }
    @Override
    MongoDbIO.Write.Builder setBatchSize(long batchSize) {
      this.batchSize = batchSize;
      return this;
    }
    @Override
    MongoDbIO.Write build() {
      String missing = "";
      if (this.keepAlive == null) {
        missing += " keepAlive";
      }
      if (this.maxConnectionIdleTime == null) {
        missing += " maxConnectionIdleTime";
      }
      if (this.batchSize == null) {
        missing += " batchSize";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MongoDbIO_Write(
          this.uri,
          this.keepAlive,
          this.maxConnectionIdleTime,
          this.database,
          this.collection,
          this.batchSize);
    }
  }

}
