
package org.apache.beam.sdk.io.mongodb;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_MongoDbIO_Read extends MongoDbIO.Read {

  private final String uri;
  private final boolean keepAlive;
  private final int maxConnectionIdleTime;
  private final String database;
  private final String collection;
  private final String filter;
  private final int numSplits;

  private AutoValue_MongoDbIO_Read(
      @Nullable String uri,
      boolean keepAlive,
      int maxConnectionIdleTime,
      @Nullable String database,
      @Nullable String collection,
      @Nullable String filter,
      int numSplits) {
    this.uri = uri;
    this.keepAlive = keepAlive;
    this.maxConnectionIdleTime = maxConnectionIdleTime;
    this.database = database;
    this.collection = collection;
    this.filter = filter;
    this.numSplits = numSplits;
  }

  @Nullable
  @Override
  String uri() {
    return uri;
  }

  @Override
  boolean keepAlive() {
    return keepAlive;
  }

  @Override
  int maxConnectionIdleTime() {
    return maxConnectionIdleTime;
  }

  @Nullable
  @Override
  String database() {
    return database;
  }

  @Nullable
  @Override
  String collection() {
    return collection;
  }

  @Nullable
  @Override
  String filter() {
    return filter;
  }

  @Override
  int numSplits() {
    return numSplits;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MongoDbIO.Read) {
      MongoDbIO.Read that = (MongoDbIO.Read) o;
      return ((this.uri == null) ? (that.uri() == null) : this.uri.equals(that.uri()))
           && (this.keepAlive == that.keepAlive())
           && (this.maxConnectionIdleTime == that.maxConnectionIdleTime())
           && ((this.database == null) ? (that.database() == null) : this.database.equals(that.database()))
           && ((this.collection == null) ? (that.collection() == null) : this.collection.equals(that.collection()))
           && ((this.filter == null) ? (that.filter() == null) : this.filter.equals(that.filter()))
           && (this.numSplits == that.numSplits());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (uri == null) ? 0 : this.uri.hashCode();
    h *= 1000003;
    h ^= this.keepAlive ? 1231 : 1237;
    h *= 1000003;
    h ^= this.maxConnectionIdleTime;
    h *= 1000003;
    h ^= (database == null) ? 0 : this.database.hashCode();
    h *= 1000003;
    h ^= (collection == null) ? 0 : this.collection.hashCode();
    h *= 1000003;
    h ^= (filter == null) ? 0 : this.filter.hashCode();
    h *= 1000003;
    h ^= this.numSplits;
    return h;
  }

  @Override
  MongoDbIO.Read.Builder builder() {
    return new Builder(this);
  }

  static final class Builder extends MongoDbIO.Read.Builder {
    private String uri;
    private Boolean keepAlive;
    private Integer maxConnectionIdleTime;
    private String database;
    private String collection;
    private String filter;
    private Integer numSplits;
    Builder() {
    }
    private Builder(MongoDbIO.Read source) {
      this.uri = source.uri();
      this.keepAlive = source.keepAlive();
      this.maxConnectionIdleTime = source.maxConnectionIdleTime();
      this.database = source.database();
      this.collection = source.collection();
      this.filter = source.filter();
      this.numSplits = source.numSplits();
    }
    @Override
    MongoDbIO.Read.Builder setUri(@Nullable String uri) {
      this.uri = uri;
      return this;
    }
    @Override
    MongoDbIO.Read.Builder setKeepAlive(boolean keepAlive) {
      this.keepAlive = keepAlive;
      return this;
    }
    @Override
    MongoDbIO.Read.Builder setMaxConnectionIdleTime(int maxConnectionIdleTime) {
      this.maxConnectionIdleTime = maxConnectionIdleTime;
      return this;
    }
    @Override
    MongoDbIO.Read.Builder setDatabase(@Nullable String database) {
      this.database = database;
      return this;
    }
    @Override
    MongoDbIO.Read.Builder setCollection(@Nullable String collection) {
      this.collection = collection;
      return this;
    }
    @Override
    MongoDbIO.Read.Builder setFilter(@Nullable String filter) {
      this.filter = filter;
      return this;
    }
    @Override
    MongoDbIO.Read.Builder setNumSplits(int numSplits) {
      this.numSplits = numSplits;
      return this;
    }
    @Override
    MongoDbIO.Read build() {
      String missing = "";
      if (this.keepAlive == null) {
        missing += " keepAlive";
      }
      if (this.maxConnectionIdleTime == null) {
        missing += " maxConnectionIdleTime";
      }
      if (this.numSplits == null) {
        missing += " numSplits";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MongoDbIO_Read(
          this.uri,
          this.keepAlive,
          this.maxConnectionIdleTime,
          this.database,
          this.collection,
          this.filter,
          this.numSplits);
    }
  }

}
