
package org.apache.beam.sdk.io.mongodb;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_MongoDbIO_Write extends MongoDbIO.Write {

  private final String uri;
  private final String database;
  private final String collection;
  private final long batchSize;

  private AutoValue_MongoDbIO_Write(
      @Nullable String uri,
      @Nullable String database,
      @Nullable String collection,
      long batchSize) {
    this.uri = uri;
    this.database = database;
    this.collection = collection;
    this.batchSize = batchSize;
  }

  @Nullable
  @Override
  String uri() {
    return uri;
  }

  @Nullable
  @Override
  String database() {
    return database;
  }

  @Nullable
  @Override
  String collection() {
    return collection;
  }

  @Override
  long batchSize() {
    return batchSize;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MongoDbIO.Write) {
      MongoDbIO.Write that = (MongoDbIO.Write) o;
      return ((this.uri == null) ? (that.uri() == null) : this.uri.equals(that.uri()))
           && ((this.database == null) ? (that.database() == null) : this.database.equals(that.database()))
           && ((this.collection == null) ? (that.collection() == null) : this.collection.equals(that.collection()))
           && (this.batchSize == that.batchSize());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (uri == null) ? 0 : this.uri.hashCode();
    h *= 1000003;
    h ^= (database == null) ? 0 : this.database.hashCode();
    h *= 1000003;
    h ^= (collection == null) ? 0 : this.collection.hashCode();
    h *= 1000003;
    h ^= (this.batchSize >>> 32) ^ this.batchSize;
    return h;
  }

  @Override
  public MongoDbIO.Write.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends MongoDbIO.Write.Builder {
    private String uri;
    private String database;
    private String collection;
    private Long batchSize;
    Builder() {
    }
    Builder(MongoDbIO.Write source) {
      this.uri = source.uri();
      this.database = source.database();
      this.collection = source.collection();
      this.batchSize = source.batchSize();
    }
    @Override
    public MongoDbIO.Write.Builder setUri(@Nullable String uri) {
      this.uri = uri;
      return this;
    }
    @Override
    public MongoDbIO.Write.Builder setDatabase(@Nullable String database) {
      this.database = database;
      return this;
    }
    @Override
    public MongoDbIO.Write.Builder setCollection(@Nullable String collection) {
      this.collection = collection;
      return this;
    }
    @Override
    public MongoDbIO.Write.Builder setBatchSize(long batchSize) {
      this.batchSize = batchSize;
      return this;
    }
    @Override
    public MongoDbIO.Write build() {
      String missing = "";
      if (batchSize == null) {
        missing += " batchSize";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MongoDbIO_Write(
          this.uri,
          this.database,
          this.collection,
          this.batchSize);
    }
  }

}
