/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.ExpiredIteratorException;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.LimitExceededException;
import com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import com.amazonaws.services.kinesis.model.StreamDescription;
import java.util.List;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.assertj.core.api.Assertions;
import org.joda.time.Instant;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SimplifiedKinesisClientTest {
    private static final String STREAM = "stream";
    private static final String SHARD_1 = "shard-01";
    private static final String SHARD_2 = "shard-02";
    private static final String SHARD_3 = "shard-03";
    private static final String SHARD_ITERATOR = "iterator";
    private static final String SEQUENCE_NUMBER = "abc123";
    @Mock
    private AmazonKinesis kinesis;
    @InjectMocks
    private SimplifiedKinesisClient underTest;

    @Test
    public void shouldReturnIteratorStartingWithSequenceNumber() throws Exception {
        BDDMockito.given((Object)this.kinesis.getShardIterator(new GetShardIteratorRequest().withStreamName(STREAM).withShardId(SHARD_1).withShardIteratorType(ShardIteratorType.AT_SEQUENCE_NUMBER).withStartingSequenceNumber(SEQUENCE_NUMBER))).willReturn((Object)new GetShardIteratorResult().withShardIterator(SHARD_ITERATOR));
        String stream = this.underTest.getShardIterator(STREAM, SHARD_1, ShardIteratorType.AT_SEQUENCE_NUMBER, SEQUENCE_NUMBER, null);
        Assertions.assertThat((String)stream).isEqualTo((Object)SHARD_ITERATOR);
    }

    @Test
    public void shouldReturnIteratorStartingWithTimestamp() throws Exception {
        Instant timestamp = Instant.now();
        BDDMockito.given((Object)this.kinesis.getShardIterator(new GetShardIteratorRequest().withStreamName(STREAM).withShardId(SHARD_1).withShardIteratorType(ShardIteratorType.AT_SEQUENCE_NUMBER).withTimestamp(timestamp.toDate()))).willReturn((Object)new GetShardIteratorResult().withShardIterator(SHARD_ITERATOR));
        String stream = this.underTest.getShardIterator(STREAM, SHARD_1, ShardIteratorType.AT_SEQUENCE_NUMBER, null, timestamp);
        Assertions.assertThat((String)stream).isEqualTo((Object)SHARD_ITERATOR);
    }

    @Test
    public void shouldHandleExpiredIterationExceptionForGetShardIterator() {
        this.shouldHandleGetShardIteratorError((Exception)new ExpiredIteratorException(""), ExpiredIteratorException.class);
    }

    @Test
    public void shouldHandleLimitExceededExceptionForGetShardIterator() {
        this.shouldHandleGetShardIteratorError((Exception)new LimitExceededException(""), TransientKinesisException.class);
    }

    @Test
    public void shouldHandleProvisionedThroughputExceededExceptionForGetShardIterator() {
        this.shouldHandleGetShardIteratorError((Exception)new ProvisionedThroughputExceededException(""), TransientKinesisException.class);
    }

    @Test
    public void shouldHandleServiceErrorForGetShardIterator() {
        this.shouldHandleGetShardIteratorError((Exception)this.newAmazonServiceException(AmazonServiceException.ErrorType.Service), TransientKinesisException.class);
    }

    @Test
    public void shouldHandleClientErrorForGetShardIterator() {
        this.shouldHandleGetShardIteratorError((Exception)this.newAmazonServiceException(AmazonServiceException.ErrorType.Client), RuntimeException.class);
    }

    @Test
    public void shouldHandleUnexpectedExceptionForGetShardIterator() {
        this.shouldHandleGetShardIteratorError(new NullPointerException(), RuntimeException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldHandleGetShardIteratorError(Exception thrownException, Class<? extends Exception> expectedExceptionClass) {
        GetShardIteratorRequest request = new GetShardIteratorRequest().withStreamName(STREAM).withShardId(SHARD_1).withShardIteratorType(ShardIteratorType.LATEST);
        BDDMockito.given((Object)this.kinesis.getShardIterator(request)).willThrow(new Throwable[]{thrownException});
        try {
            this.underTest.getShardIterator(STREAM, SHARD_1, ShardIteratorType.LATEST, null, null);
            Assertions.failBecauseExceptionWasNotThrown(expectedExceptionClass);
        }
        catch (Exception e) {
            try {
                Assertions.assertThat((Throwable)e).isExactlyInstanceOf(expectedExceptionClass);
            }
            catch (Throwable throwable) {
                Mockito.reset((Object[])new AmazonKinesis[]{this.kinesis});
                throw throwable;
            }
            Mockito.reset((Object[])new AmazonKinesis[]{this.kinesis});
        }
        Mockito.reset((Object[])new AmazonKinesis[]{this.kinesis});
    }

    @Test
    public void shouldListAllShards() throws Exception {
        Shard shard1 = new Shard().withShardId(SHARD_1);
        Shard shard2 = new Shard().withShardId(SHARD_2);
        Shard shard3 = new Shard().withShardId(SHARD_3);
        BDDMockito.given((Object)this.kinesis.describeStream(STREAM, null)).willReturn((Object)new DescribeStreamResult().withStreamDescription(new StreamDescription().withShards(new Shard[]{shard1, shard2}).withHasMoreShards(Boolean.valueOf(true))));
        BDDMockito.given((Object)this.kinesis.describeStream(STREAM, SHARD_2)).willReturn((Object)new DescribeStreamResult().withStreamDescription(new StreamDescription().withShards(new Shard[]{shard3}).withHasMoreShards(Boolean.valueOf(false))));
        List shards = this.underTest.listShards(STREAM);
        Assertions.assertThat((List)shards).containsOnly((Object[])new Shard[]{shard1, shard2, shard3});
    }

    @Test
    public void shouldHandleExpiredIterationExceptionForShardListing() {
        this.shouldHandleShardListingError((Exception)new ExpiredIteratorException(""), ExpiredIteratorException.class);
    }

    @Test
    public void shouldHandleLimitExceededExceptionForShardListing() {
        this.shouldHandleShardListingError((Exception)new LimitExceededException(""), TransientKinesisException.class);
    }

    @Test
    public void shouldHandleProvisionedThroughputExceededExceptionForShardListing() {
        this.shouldHandleShardListingError((Exception)new ProvisionedThroughputExceededException(""), TransientKinesisException.class);
    }

    @Test
    public void shouldHandleServiceErrorForShardListing() {
        this.shouldHandleShardListingError((Exception)this.newAmazonServiceException(AmazonServiceException.ErrorType.Service), TransientKinesisException.class);
    }

    @Test
    public void shouldHandleClientErrorForShardListing() {
        this.shouldHandleShardListingError((Exception)this.newAmazonServiceException(AmazonServiceException.ErrorType.Client), RuntimeException.class);
    }

    @Test
    public void shouldHandleUnexpectedExceptionForShardListing() {
        this.shouldHandleShardListingError(new NullPointerException(), RuntimeException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldHandleShardListingError(Exception thrownException, Class<? extends Exception> expectedExceptionClass) {
        BDDMockito.given((Object)this.kinesis.describeStream(STREAM, null)).willThrow(new Throwable[]{thrownException});
        try {
            this.underTest.listShards(STREAM);
            Assertions.failBecauseExceptionWasNotThrown(expectedExceptionClass);
        }
        catch (Exception e) {
            try {
                Assertions.assertThat((Throwable)e).isExactlyInstanceOf(expectedExceptionClass);
            }
            catch (Throwable throwable) {
                Mockito.reset((Object[])new AmazonKinesis[]{this.kinesis});
                throw throwable;
            }
            Mockito.reset((Object[])new AmazonKinesis[]{this.kinesis});
        }
        Mockito.reset((Object[])new AmazonKinesis[]{this.kinesis});
    }

    private AmazonServiceException newAmazonServiceException(AmazonServiceException.ErrorType errorType) {
        AmazonServiceException exception = new AmazonServiceException("");
        exception.setErrorType(errorType);
        return exception;
    }
}

