/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.services.kinesis.model.ExpiredIteratorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.beam.sdk.io.kinesis.CustomOptional;
import org.apache.beam.sdk.io.kinesis.GetKinesisRecordsResult;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.RecordFilter;
import org.apache.beam.sdk.io.kinesis.ShardCheckpoint;
import org.apache.beam.sdk.io.kinesis.ShardRecordsIterator;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class ShardRecordsIteratorTest {
    private static final String INITIAL_ITERATOR = "INITIAL_ITERATOR";
    private static final String SECOND_ITERATOR = "SECOND_ITERATOR";
    private static final String SECOND_REFRESHED_ITERATOR = "SECOND_REFRESHED_ITERATOR";
    private static final String THIRD_ITERATOR = "THIRD_ITERATOR";
    private static final String STREAM_NAME = "STREAM_NAME";
    private static final String SHARD_ID = "SHARD_ID";
    @Mock
    private SimplifiedKinesisClient kinesisClient;
    @Mock
    private ShardCheckpoint firstCheckpoint;
    @Mock
    private ShardCheckpoint aCheckpoint;
    @Mock
    private ShardCheckpoint bCheckpoint;
    @Mock
    private ShardCheckpoint cCheckpoint;
    @Mock
    private ShardCheckpoint dCheckpoint;
    @Mock
    private GetKinesisRecordsResult firstResult;
    @Mock
    private GetKinesisRecordsResult secondResult;
    @Mock
    private GetKinesisRecordsResult thirdResult;
    @Mock
    private KinesisRecord a;
    @Mock
    private KinesisRecord b;
    @Mock
    private KinesisRecord c;
    @Mock
    private KinesisRecord d;
    @Mock
    private RecordFilter recordFilter;
    private ShardRecordsIterator iterator;

    @Before
    public void setUp() throws IOException, TransientKinesisException {
        Mockito.when((Object)this.firstCheckpoint.getShardIterator(this.kinesisClient)).thenReturn((Object)INITIAL_ITERATOR);
        Mockito.when((Object)this.firstCheckpoint.getStreamName()).thenReturn((Object)STREAM_NAME);
        Mockito.when((Object)this.firstCheckpoint.getShardId()).thenReturn((Object)SHARD_ID);
        Mockito.when((Object)this.firstCheckpoint.moveAfter(this.a)).thenReturn((Object)this.aCheckpoint);
        Mockito.when((Object)this.aCheckpoint.moveAfter(this.b)).thenReturn((Object)this.bCheckpoint);
        Mockito.when((Object)this.aCheckpoint.getStreamName()).thenReturn((Object)STREAM_NAME);
        Mockito.when((Object)this.aCheckpoint.getShardId()).thenReturn((Object)SHARD_ID);
        Mockito.when((Object)this.bCheckpoint.moveAfter(this.c)).thenReturn((Object)this.cCheckpoint);
        Mockito.when((Object)this.bCheckpoint.getStreamName()).thenReturn((Object)STREAM_NAME);
        Mockito.when((Object)this.bCheckpoint.getShardId()).thenReturn((Object)SHARD_ID);
        Mockito.when((Object)this.cCheckpoint.moveAfter(this.d)).thenReturn((Object)this.dCheckpoint);
        Mockito.when((Object)this.cCheckpoint.getStreamName()).thenReturn((Object)STREAM_NAME);
        Mockito.when((Object)this.cCheckpoint.getShardId()).thenReturn((Object)SHARD_ID);
        Mockito.when((Object)this.dCheckpoint.getStreamName()).thenReturn((Object)STREAM_NAME);
        Mockito.when((Object)this.dCheckpoint.getShardId()).thenReturn((Object)SHARD_ID);
        Mockito.when((Object)this.kinesisClient.getRecords(INITIAL_ITERATOR, STREAM_NAME, SHARD_ID)).thenReturn((Object)this.firstResult);
        Mockito.when((Object)this.kinesisClient.getRecords(SECOND_ITERATOR, STREAM_NAME, SHARD_ID)).thenReturn((Object)this.secondResult);
        Mockito.when((Object)this.kinesisClient.getRecords(THIRD_ITERATOR, STREAM_NAME, SHARD_ID)).thenReturn((Object)this.thirdResult);
        Mockito.when((Object)this.firstResult.getNextShardIterator()).thenReturn((Object)SECOND_ITERATOR);
        Mockito.when((Object)this.secondResult.getNextShardIterator()).thenReturn((Object)THIRD_ITERATOR);
        Mockito.when((Object)this.thirdResult.getNextShardIterator()).thenReturn((Object)THIRD_ITERATOR);
        Mockito.when((Object)this.firstResult.getRecords()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.secondResult.getRecords()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.thirdResult.getRecords()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.recordFilter.apply(Matchers.anyListOf(KinesisRecord.class), (ShardCheckpoint)Matchers.any(ShardCheckpoint.class))).thenAnswer((Answer)new IdentityAnswer());
        this.iterator = new ShardRecordsIterator(this.firstCheckpoint, this.kinesisClient, this.recordFilter);
    }

    @Test
    public void returnsAbsentIfNoRecordsPresent() throws IOException, TransientKinesisException {
        Assertions.assertThat((Object)this.iterator.next()).isEqualTo((Object)CustomOptional.absent());
        Assertions.assertThat((Object)this.iterator.next()).isEqualTo((Object)CustomOptional.absent());
        Assertions.assertThat((Object)this.iterator.next()).isEqualTo((Object)CustomOptional.absent());
    }

    @Test
    public void goesThroughAvailableRecords() throws IOException, TransientKinesisException {
        Mockito.when((Object)this.firstResult.getRecords()).thenReturn(Arrays.asList(this.a, this.b, this.c));
        Mockito.when((Object)this.secondResult.getRecords()).thenReturn(Collections.singletonList(this.d));
        Assertions.assertThat((Object)this.iterator.getCheckpoint()).isEqualTo((Object)this.firstCheckpoint);
        Assertions.assertThat((Object)this.iterator.next()).isEqualTo((Object)CustomOptional.of((Object)this.a));
        Assertions.assertThat((Object)this.iterator.getCheckpoint()).isEqualTo((Object)this.aCheckpoint);
        Assertions.assertThat((Object)this.iterator.next()).isEqualTo((Object)CustomOptional.of((Object)this.b));
        Assertions.assertThat((Object)this.iterator.getCheckpoint()).isEqualTo((Object)this.bCheckpoint);
        Assertions.assertThat((Object)this.iterator.next()).isEqualTo((Object)CustomOptional.of((Object)this.c));
        Assertions.assertThat((Object)this.iterator.getCheckpoint()).isEqualTo((Object)this.cCheckpoint);
        Assertions.assertThat((Object)this.iterator.next()).isEqualTo((Object)CustomOptional.of((Object)this.d));
        Assertions.assertThat((Object)this.iterator.getCheckpoint()).isEqualTo((Object)this.dCheckpoint);
        Assertions.assertThat((Object)this.iterator.next()).isEqualTo((Object)CustomOptional.absent());
        Assertions.assertThat((Object)this.iterator.getCheckpoint()).isEqualTo((Object)this.dCheckpoint);
    }

    @Test
    public void refreshesExpiredIterator() throws IOException, TransientKinesisException {
        Mockito.when((Object)this.firstResult.getRecords()).thenReturn(Collections.singletonList(this.a));
        Mockito.when((Object)this.secondResult.getRecords()).thenReturn(Collections.singletonList(this.b));
        Mockito.when((Object)this.kinesisClient.getRecords(SECOND_ITERATOR, STREAM_NAME, SHARD_ID)).thenThrow(new Class[]{ExpiredIteratorException.class});
        Mockito.when((Object)this.aCheckpoint.getShardIterator(this.kinesisClient)).thenReturn((Object)SECOND_REFRESHED_ITERATOR);
        Mockito.when((Object)this.kinesisClient.getRecords(SECOND_REFRESHED_ITERATOR, STREAM_NAME, SHARD_ID)).thenReturn((Object)this.secondResult);
        Assertions.assertThat((Object)this.iterator.next()).isEqualTo((Object)CustomOptional.of((Object)this.a));
        Assertions.assertThat((Object)this.iterator.next()).isEqualTo((Object)CustomOptional.of((Object)this.b));
        Assertions.assertThat((Object)this.iterator.next()).isEqualTo((Object)CustomOptional.absent());
    }

    private static class IdentityAnswer
    implements Answer<Object> {
        private IdentityAnswer() {
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            return invocation.getArguments()[0];
        }
    }
}

