/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.beam.sdk.io.kinesis.RoundRobin;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class RoundRobinTest {
    @Test(expected=IllegalArgumentException.class)
    public void doesNotAllowCreationWithEmptyCollection() {
        new RoundRobin(Collections.emptyList());
    }

    @Test
    public void goesThroughElementsInCycle() {
        ArrayList input = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        RoundRobin roundRobin = new RoundRobin((Iterable)Lists.newArrayList((Iterable)input));
        input.addAll(input);
        for (String element : input) {
            Assertions.assertThat((String)((String)roundRobin.getCurrent())).isEqualTo((Object)element);
            Assertions.assertThat((String)((String)roundRobin.getCurrent())).isEqualTo((Object)element);
            roundRobin.moveForward();
        }
    }

    @Test
    public void usualIteratorGoesThroughElementsOnce() {
        ArrayList input = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        RoundRobin roundRobin = new RoundRobin((Iterable)input);
        Assertions.assertThat((Iterable)roundRobin).hasSize(3).containsOnly((Object[])input.toArray(new String[0]));
    }
}

