/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.RecordFilter;
import org.apache.beam.sdk.io.kinesis.ShardCheckpoint;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RecordFilterTest {
    @Mock
    private ShardCheckpoint checkpoint;
    @Mock
    private KinesisRecord record1;
    @Mock
    private KinesisRecord record2;
    @Mock
    private KinesisRecord record3;
    @Mock
    private KinesisRecord record4;
    @Mock
    private KinesisRecord record5;

    @Test
    public void shouldFilterOutRecordsBeforeOrAtCheckpoint() {
        BDDMockito.given((Object)this.checkpoint.isBeforeOrAt(this.record1)).willReturn((Object)false);
        BDDMockito.given((Object)this.checkpoint.isBeforeOrAt(this.record2)).willReturn((Object)true);
        BDDMockito.given((Object)this.checkpoint.isBeforeOrAt(this.record3)).willReturn((Object)true);
        BDDMockito.given((Object)this.checkpoint.isBeforeOrAt(this.record4)).willReturn((Object)false);
        BDDMockito.given((Object)this.checkpoint.isBeforeOrAt(this.record5)).willReturn((Object)true);
        ArrayList records = Lists.newArrayList((Object[])new KinesisRecord[]{this.record1, this.record2, this.record3, this.record4, this.record5});
        RecordFilter underTest = new RecordFilter();
        List retainedRecords = underTest.apply((List)records, this.checkpoint);
        Assertions.assertThat((List)retainedRecords).containsOnly((Object[])new KinesisRecord[]{this.record2, this.record3, this.record5});
    }

    @Test
    public void shouldNotFailOnEmptyList() {
        List records = Collections.emptyList();
        RecordFilter underTest = new RecordFilter();
        List retainedRecords = underTest.apply(records, this.checkpoint);
        Assertions.assertThat((List)retainedRecords).isEmpty();
    }
}

