/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.PutRecordsResultEntry;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.io.kinesis.KinesisTestOptions;

public class KinesisUploader {
    public static final int MAX_NUMBER_OF_RECORDS_IN_BATCH = 499;

    public static void uploadAll(List<String> data, KinesisTestOptions options) {
        AmazonKinesisClient client = (AmazonKinesisClient)new AmazonKinesisClient((AWSCredentialsProvider)new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(options.getAwsAccessKey(), options.getAwsSecretKey()))).withRegion(Regions.fromName((String)options.getAwsKinesisRegion()));
        List partitions = Lists.partition(data, (int)499);
        for (List partition : partitions) {
            PutRecordsResult result;
            ArrayList allRecords = Lists.newArrayList();
            for (String row : partition) {
                allRecords.add(new PutRecordsRequestEntry().withData(ByteBuffer.wrap(row.getBytes(Charsets.UTF_8))).withPartitionKey(Integer.toString(row.hashCode())));
            }
            do {
                result = client.putRecords(new PutRecordsRequest().withStreamName(options.getAwsKinesisStream()).withRecords((Collection)allRecords));
                ArrayList failedRecords = Lists.newArrayList();
                int i = 0;
                for (PutRecordsResultEntry row : result.getRecords()) {
                    if (row.getErrorCode() != null) {
                        failedRecords.add(allRecords.get(i));
                    }
                    ++i;
                }
                allRecords = failedRecords;
            } while (result.getFailedRecordCount() > 0);
        }
    }
}

