/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.io.kinesis.CheckpointGenerator;
import org.apache.beam.sdk.io.kinesis.CustomOptional;
import org.apache.beam.sdk.io.kinesis.KinesisReader;
import org.apache.beam.sdk.io.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.ShardCheckpoint;
import org.apache.beam.sdk.io.kinesis.ShardRecordsIterator;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KinesisReaderTest {
    @Mock
    private SimplifiedKinesisClient kinesis;
    @Mock
    private CheckpointGenerator generator;
    @Mock
    private ShardCheckpoint firstCheckpoint;
    @Mock
    private ShardCheckpoint secondCheckpoint;
    @Mock
    private ShardRecordsIterator firstIterator;
    @Mock
    private ShardRecordsIterator secondIterator;
    @Mock
    private KinesisRecord a;
    @Mock
    private KinesisRecord b;
    @Mock
    private KinesisRecord c;
    @Mock
    private KinesisRecord d;
    private KinesisReader reader;

    @Before
    public void setUp() throws IOException, TransientKinesisException {
        Mockito.when((Object)this.generator.generate(this.kinesis)).thenReturn((Object)new KinesisReaderCheckpoint(Arrays.asList(this.firstCheckpoint, this.secondCheckpoint)));
        Mockito.when((Object)this.firstCheckpoint.getShardRecordsIterator(this.kinesis)).thenReturn((Object)this.firstIterator);
        Mockito.when((Object)this.secondCheckpoint.getShardRecordsIterator(this.kinesis)).thenReturn((Object)this.secondIterator);
        Mockito.when((Object)this.firstIterator.next()).thenReturn((Object)CustomOptional.absent());
        Mockito.when((Object)this.secondIterator.next()).thenReturn((Object)CustomOptional.absent());
        this.reader = new KinesisReader(this.kinesis, this.generator, null);
    }

    @Test
    public void startReturnsFalseIfNoDataAtTheBeginning() throws IOException {
        Assertions.assertThat((boolean)this.reader.start()).isFalse();
    }

    @Test(expected=NoSuchElementException.class)
    public void throwsNoSuchElementExceptionIfNoData() throws IOException {
        this.reader.start();
        this.reader.getCurrent();
    }

    @Test
    public void startReturnsTrueIfSomeDataAvailable() throws IOException, TransientKinesisException {
        Mockito.when((Object)this.firstIterator.next()).thenReturn((Object)CustomOptional.of((Object)this.a)).thenReturn((Object)CustomOptional.absent());
        Assertions.assertThat((boolean)this.reader.start()).isTrue();
    }

    @Test
    public void advanceReturnsFalseIfThereIsTransientExceptionInKinesis() throws IOException, TransientKinesisException {
        this.reader.start();
        Mockito.when((Object)this.firstIterator.next()).thenThrow(new Class[]{TransientKinesisException.class});
        Assertions.assertThat((boolean)this.reader.advance()).isFalse();
    }

    @Test
    public void readsThroughAllDataAvailable() throws IOException, TransientKinesisException {
        Mockito.when((Object)this.firstIterator.next()).thenReturn((Object)CustomOptional.absent()).thenReturn((Object)CustomOptional.of((Object)this.a)).thenReturn((Object)CustomOptional.absent()).thenReturn((Object)CustomOptional.of((Object)this.b)).thenReturn((Object)CustomOptional.absent());
        Mockito.when((Object)this.secondIterator.next()).thenReturn((Object)CustomOptional.of((Object)this.c)).thenReturn((Object)CustomOptional.absent()).thenReturn((Object)CustomOptional.of((Object)this.d)).thenReturn((Object)CustomOptional.absent());
        Assertions.assertThat((boolean)this.reader.start()).isTrue();
        Assertions.assertThat((Object)this.reader.getCurrent()).isEqualTo((Object)this.c);
        Assertions.assertThat((boolean)this.reader.advance()).isTrue();
        Assertions.assertThat((Object)this.reader.getCurrent()).isEqualTo((Object)this.a);
        Assertions.assertThat((boolean)this.reader.advance()).isTrue();
        Assertions.assertThat((Object)this.reader.getCurrent()).isEqualTo((Object)this.d);
        Assertions.assertThat((boolean)this.reader.advance()).isTrue();
        Assertions.assertThat((Object)this.reader.getCurrent()).isEqualTo((Object)this.b);
        Assertions.assertThat((boolean)this.reader.advance()).isFalse();
    }
}

