/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.regions.Regions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.kinesis.KinesisIO;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.KinesisTestOptions;
import org.apache.beam.sdk.io.kinesis.KinesisUploader;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class KinesisReaderIT {
    private static final long PIPELINE_STARTUP_TIME = TimeUnit.SECONDS.toMillis(10L);
    private ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    @Rule
    public final transient TestPipeline p = TestPipeline.create();

    @Ignore
    @Test
    public void readsDataFromRealKinesisStream() throws IOException, InterruptedException, ExecutionException {
        KinesisTestOptions options = this.readKinesisOptions();
        List<String> testData = this.prepareTestData(1000);
        Future<?> future = this.startTestPipeline(testData, options);
        KinesisUploader.uploadAll(testData, options);
        future.get();
    }

    private List<String> prepareTestData(int count) {
        ArrayList data = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            data.add(RandomStringUtils.randomAlphabetic((int)32));
        }
        return data;
    }

    private Future<?> startTestPipeline(List<String> testData, KinesisTestOptions options) throws InterruptedException {
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)KinesisIO.Read.from((String)options.getAwsKinesisStream(), (Instant)Instant.now()).using(options.getAwsAccessKey(), options.getAwsSecretKey(), Regions.fromName((String)options.getAwsKinesisRegion())).withMaxReadTime(Duration.standardMinutes((long)3L)))).apply((PTransform)ParDo.of((DoFn)new RecordDataToString()));
        PAssert.that((PCollection)result).containsInAnyOrder(testData);
        Future<Void> future = this.singleThreadExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PipelineResult result = KinesisReaderIT.this.p.run();
                PipelineResult.State state = result.getState();
                while (state != PipelineResult.State.DONE && state != PipelineResult.State.FAILED) {
                    Thread.sleep(1000L);
                    state = result.getState();
                }
                Assertions.assertThat((Comparable)state).isEqualTo((Object)PipelineResult.State.DONE);
                return null;
            }
        });
        Thread.sleep(PIPELINE_STARTUP_TIME);
        return future;
    }

    private KinesisTestOptions readKinesisOptions() {
        PipelineOptionsFactory.register(KinesisTestOptions.class);
        return (KinesisTestOptions)TestPipeline.testingPipelineOptions().as(KinesisTestOptions.class);
    }

    private static class RecordDataToString
    extends DoFn<KinesisRecord, String> {
        private RecordDataToString() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Preconditions.checkNotNull((Object)c.element(), (Object)"Null record given");
            c.output((Object)new String(((KinesisRecord)c.element()).getData().array(), StandardCharsets.UTF_8));
        }
    }
}

