/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Shard;
import java.util.Arrays;
import org.apache.beam.sdk.io.kinesis.DynamicCheckpointGenerator;
import org.apache.beam.sdk.io.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DynamicCheckpointGeneratorTest {
    @Mock
    private SimplifiedKinesisClient kinesisClient;
    @Mock
    private Shard shard1;
    @Mock
    private Shard shard2;
    @Mock
    private Shard shard3;

    @Test
    public void shouldMapAllShardsToCheckpoints() throws Exception {
        BDDMockito.given((Object)this.shard1.getShardId()).willReturn((Object)"shard-01");
        BDDMockito.given((Object)this.shard2.getShardId()).willReturn((Object)"shard-02");
        BDDMockito.given((Object)this.shard3.getShardId()).willReturn((Object)"shard-03");
        BDDMockito.given((Object)this.kinesisClient.listShards("stream")).willReturn(Arrays.asList(this.shard1, this.shard2, this.shard3));
        StartingPoint startingPoint = new StartingPoint(InitialPositionInStream.LATEST);
        DynamicCheckpointGenerator underTest = new DynamicCheckpointGenerator("stream", startingPoint);
        KinesisReaderCheckpoint checkpoint = underTest.generate(this.kinesisClient);
        Assertions.assertThat((Iterable)checkpoint).hasSize(3);
    }
}

