/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.regions.Region;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.AddTagsToStreamRequest;
import com.amazonaws.services.kinesis.model.AddTagsToStreamResult;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.CreateStreamResult;
import com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodResult;
import com.amazonaws.services.kinesis.model.DeleteStreamRequest;
import com.amazonaws.services.kinesis.model.DeleteStreamResult;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.DisableEnhancedMonitoringRequest;
import com.amazonaws.services.kinesis.model.DisableEnhancedMonitoringResult;
import com.amazonaws.services.kinesis.model.EnableEnhancedMonitoringRequest;
import com.amazonaws.services.kinesis.model.EnableEnhancedMonitoringResult;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodResult;
import com.amazonaws.services.kinesis.model.ListStreamsRequest;
import com.amazonaws.services.kinesis.model.ListStreamsResult;
import com.amazonaws.services.kinesis.model.ListTagsForStreamRequest;
import com.amazonaws.services.kinesis.model.ListTagsForStreamResult;
import com.amazonaws.services.kinesis.model.MergeShardsRequest;
import com.amazonaws.services.kinesis.model.MergeShardsResult;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.services.kinesis.model.RemoveTagsFromStreamRequest;
import com.amazonaws.services.kinesis.model.RemoveTagsFromStreamResult;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import com.amazonaws.services.kinesis.model.SplitShardRequest;
import com.amazonaws.services.kinesis.model.SplitShardResult;
import com.amazonaws.services.kinesis.model.StreamDescription;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kinesis.KinesisClientProvider;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.joda.time.Instant;

class AmazonKinesisMock
implements AmazonKinesis {
    private final List<List<Record>> shardedData;
    private final int numberOfRecordsPerGet;

    public AmazonKinesisMock(List<List<Record>> shardedData, int numberOfRecordsPerGet) {
        this.shardedData = shardedData;
        this.numberOfRecordsPerGet = numberOfRecordsPerGet;
    }

    public GetRecordsResult getRecords(GetRecordsRequest getRecordsRequest) {
        String[] shardIteratorParts = getRecordsRequest.getShardIterator().split(":");
        int shardId = Integer.parseInt(shardIteratorParts[0]);
        int startingRecord = Integer.parseInt(shardIteratorParts[1]);
        List<Record> shardData = this.shardedData.get(shardId);
        int toIndex = Math.min(startingRecord + this.numberOfRecordsPerGet, shardData.size());
        int fromIndex = Math.min(startingRecord, toIndex);
        return new GetRecordsResult().withRecords(shardData.subList(fromIndex, toIndex)).withNextShardIterator(String.format("%s:%s", shardId, toIndex));
    }

    public GetShardIteratorResult getShardIterator(GetShardIteratorRequest getShardIteratorRequest) {
        ShardIteratorType shardIteratorType = ShardIteratorType.fromValue((String)getShardIteratorRequest.getShardIteratorType());
        if (shardIteratorType != ShardIteratorType.TRIM_HORIZON) {
            throw new RuntimeException("Not implemented");
        }
        String shardIterator = String.format("%s:%s", getShardIteratorRequest.getShardId(), 0);
        return new GetShardIteratorResult().withShardIterator(shardIterator);
    }

    public DescribeStreamResult describeStream(String streamName, String exclusiveStartShardId) {
        int nextShardId = 0;
        if (exclusiveStartShardId != null) {
            nextShardId = Integer.parseInt(exclusiveStartShardId) + 1;
        }
        boolean hasMoreShards = nextShardId + 1 < this.shardedData.size();
        ArrayList shards = Lists.newArrayList();
        if (nextShardId < this.shardedData.size()) {
            shards.add(new Shard().withShardId(Integer.toString(nextShardId)));
        }
        return new DescribeStreamResult().withStreamDescription(new StreamDescription().withHasMoreShards(Boolean.valueOf(hasMoreShards)).withShards((Collection)shards));
    }

    public void setEndpoint(String endpoint) {
    }

    public void setRegion(Region region) {
    }

    public AddTagsToStreamResult addTagsToStream(AddTagsToStreamRequest addTagsToStreamRequest) {
        throw new RuntimeException("Not implemented");
    }

    public CreateStreamResult createStream(CreateStreamRequest createStreamRequest) {
        throw new RuntimeException("Not implemented");
    }

    public CreateStreamResult createStream(String streamName, Integer shardCount) {
        throw new RuntimeException("Not implemented");
    }

    public DecreaseStreamRetentionPeriodResult decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) {
        throw new RuntimeException("Not implemented");
    }

    public DeleteStreamResult deleteStream(DeleteStreamRequest deleteStreamRequest) {
        throw new RuntimeException("Not implemented");
    }

    public DeleteStreamResult deleteStream(String streamName) {
        throw new RuntimeException("Not implemented");
    }

    public DescribeStreamResult describeStream(DescribeStreamRequest describeStreamRequest) {
        throw new RuntimeException("Not implemented");
    }

    public DescribeStreamResult describeStream(String streamName) {
        throw new RuntimeException("Not implemented");
    }

    public DescribeStreamResult describeStream(String streamName, Integer limit, String exclusiveStartShardId) {
        throw new RuntimeException("Not implemented");
    }

    public DisableEnhancedMonitoringResult disableEnhancedMonitoring(DisableEnhancedMonitoringRequest disableEnhancedMonitoringRequest) {
        throw new RuntimeException("Not implemented");
    }

    public EnableEnhancedMonitoringResult enableEnhancedMonitoring(EnableEnhancedMonitoringRequest enableEnhancedMonitoringRequest) {
        throw new RuntimeException("Not implemented");
    }

    public GetShardIteratorResult getShardIterator(String streamName, String shardId, String shardIteratorType) {
        throw new RuntimeException("Not implemented");
    }

    public GetShardIteratorResult getShardIterator(String streamName, String shardId, String shardIteratorType, String startingSequenceNumber) {
        throw new RuntimeException("Not implemented");
    }

    public IncreaseStreamRetentionPeriodResult increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) {
        throw new RuntimeException("Not implemented");
    }

    public ListStreamsResult listStreams(ListStreamsRequest listStreamsRequest) {
        throw new RuntimeException("Not implemented");
    }

    public ListStreamsResult listStreams() {
        throw new RuntimeException("Not implemented");
    }

    public ListStreamsResult listStreams(String exclusiveStartStreamName) {
        throw new RuntimeException("Not implemented");
    }

    public ListStreamsResult listStreams(Integer limit, String exclusiveStartStreamName) {
        throw new RuntimeException("Not implemented");
    }

    public ListTagsForStreamResult listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) {
        throw new RuntimeException("Not implemented");
    }

    public MergeShardsResult mergeShards(MergeShardsRequest mergeShardsRequest) {
        throw new RuntimeException("Not implemented");
    }

    public MergeShardsResult mergeShards(String streamName, String shardToMerge, String adjacentShardToMerge) {
        throw new RuntimeException("Not implemented");
    }

    public PutRecordResult putRecord(PutRecordRequest putRecordRequest) {
        throw new RuntimeException("Not implemented");
    }

    public PutRecordResult putRecord(String streamName, ByteBuffer data, String partitionKey) {
        throw new RuntimeException("Not implemented");
    }

    public PutRecordResult putRecord(String streamName, ByteBuffer data, String partitionKey, String sequenceNumberForOrdering) {
        throw new RuntimeException("Not implemented");
    }

    public PutRecordsResult putRecords(PutRecordsRequest putRecordsRequest) {
        throw new RuntimeException("Not implemented");
    }

    public RemoveTagsFromStreamResult removeTagsFromStream(RemoveTagsFromStreamRequest removeTagsFromStreamRequest) {
        throw new RuntimeException("Not implemented");
    }

    public SplitShardResult splitShard(SplitShardRequest splitShardRequest) {
        throw new RuntimeException("Not implemented");
    }

    public SplitShardResult splitShard(String streamName, String shardToSplit, String newStartingHashKey) {
        throw new RuntimeException("Not implemented");
    }

    public void shutdown() {
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        throw new RuntimeException("Not implemented");
    }

    static class Provider
    implements KinesisClientProvider {
        private final List<List<TestData>> shardedData;
        private final int numberOfRecordsPerGet;

        public Provider(List<List<TestData>> shardedData, int numberOfRecordsPerGet) {
            this.shardedData = shardedData;
            this.numberOfRecordsPerGet = numberOfRecordsPerGet;
        }

        public AmazonKinesis get() {
            return new AmazonKinesisMock(Lists.transform(this.shardedData, (Function)new Function<List<TestData>, List<Record>>(){

                public List<Record> apply(@Nullable List<TestData> testDatas) {
                    return Lists.transform(testDatas, (Function)new Function<TestData, Record>(){

                        public Record apply(@Nullable TestData testData) {
                            return testData.convertToRecord();
                        }
                    });
                }
            }), this.numberOfRecordsPerGet);
        }
    }

    static class TestData
    implements Serializable {
        private final String data;
        private final Instant arrivalTimestamp;
        private final String sequenceNumber;

        public TestData(KinesisRecord record) {
            this(new String(record.getData().array()), record.getApproximateArrivalTimestamp(), record.getSequenceNumber());
        }

        public TestData(String data, Instant arrivalTimestamp, String sequenceNumber) {
            this.data = data;
            this.arrivalTimestamp = arrivalTimestamp;
            this.sequenceNumber = sequenceNumber;
        }

        public Record convertToRecord() {
            return new Record().withApproximateArrivalTimestamp(this.arrivalTimestamp.toDate()).withData(ByteBuffer.wrap(this.data.getBytes())).withSequenceNumber(this.sequenceNumber).withPartitionKey("");
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }
    }
}

