/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.beam.sdk.io.kafka.KafkaMocks;
import org.apache.beam.sdk.io.kafka.KafkaSourceDescriptor;
import org.apache.beam.sdk.io.kafka.WatchForKafkaTopicPartitions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class WatchForKafkaTopicPartitionsTest {
    public static final TestPipelineOptions OPTIONS = (TestPipelineOptions)TestPipeline.testingPipelineOptions().as(TestPipelineOptions.class);
    @Rule
    public final transient TestPipeline p = TestPipeline.fromOptions((PipelineOptions)OPTIONS);

    @Test
    public void testGetAllTopicPartitions() throws Exception {
        Consumer mockConsumer = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)mockConsumer.listTopics()).thenReturn((Object)ImmutableMap.of((Object)"topic1", (Object)ImmutableList.of((Object)new PartitionInfo("topic1", 0, null, null, null), (Object)new PartitionInfo("topic1", 1, null, null, null)), (Object)"topic2", (Object)ImmutableList.of((Object)new PartitionInfo("topic2", 0, null, null, null), (Object)new PartitionInfo("topic2", 1, null, null, null))));
        Assert.assertEquals((Object)ImmutableList.of((Object)new TopicPartition("topic1", 0), (Object)new TopicPartition("topic1", 1), (Object)new TopicPartition("topic2", 0), (Object)new TopicPartition("topic2", 1)), (Object)WatchForKafkaTopicPartitions.getAllTopicPartitions((SerializableFunction & Serializable)input -> mockConsumer, null, null, null));
    }

    @Test
    public void testGetAllTopicPartitionsWithGivenTopics() throws Exception {
        ImmutableSet givenTopics = ImmutableSet.of((Object)"topic1", (Object)"topic2");
        Consumer mockConsumer = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)mockConsumer.partitionsFor("topic1")).thenReturn((Object)ImmutableList.of((Object)new PartitionInfo("topic1", 0, null, null, null), (Object)new PartitionInfo("topic1", 1, null, null, null)));
        Mockito.when((Object)mockConsumer.partitionsFor("topic2")).thenReturn((Object)ImmutableList.of((Object)new PartitionInfo("topic2", 0, null, null, null), (Object)new PartitionInfo("topic2", 1, null, null, null)));
        ((Consumer)Mockito.verify((Object)mockConsumer, (VerificationMode)Mockito.never())).listTopics();
        Assert.assertEquals((Object)ImmutableList.of((Object)new TopicPartition("topic1", 0), (Object)new TopicPartition("topic1", 1), (Object)new TopicPartition("topic2", 0), (Object)new TopicPartition("topic2", 1)), (Object)WatchForKafkaTopicPartitions.getAllTopicPartitions((SerializableFunction & Serializable)input -> mockConsumer, null, (Set)givenTopics, null));
    }

    @Test
    public void testGetAllTopicPartitionsWithGivenPattern() throws Exception {
        Consumer mockConsumer = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)mockConsumer.listTopics()).thenReturn((Object)ImmutableMap.of((Object)"topic1", (Object)ImmutableList.of((Object)new PartitionInfo("topic1", 0, null, null, null), (Object)new PartitionInfo("topic1", 1, null, null, null)), (Object)"topic2", (Object)ImmutableList.of((Object)new PartitionInfo("topic2", 0, null, null, null), (Object)new PartitionInfo("topic2", 1, null, null, null)), (Object)"topicA", (Object)ImmutableList.of((Object)new PartitionInfo("topicA", 0, null, null, null), (Object)new PartitionInfo("topicA", 1, null, null, null)), (Object)"topicB", (Object)ImmutableList.of((Object)new PartitionInfo("topicB", 0, null, null, null), (Object)new PartitionInfo("topicB", 1, null, null, null))));
        Assert.assertEquals((Object)ImmutableList.of((Object)new TopicPartition("topic1", 0), (Object)new TopicPartition("topic1", 1), (Object)new TopicPartition("topic2", 0), (Object)new TopicPartition("topic2", 1)), (Object)WatchForKafkaTopicPartitions.getAllTopicPartitions((SerializableFunction & Serializable)input -> mockConsumer, null, null, (Pattern)Pattern.compile("topic[0-9]")));
        Assert.assertEquals((Object)ImmutableList.of((Object)new TopicPartition("topicA", 0), (Object)new TopicPartition("topicA", 1), (Object)new TopicPartition("topicB", 0), (Object)new TopicPartition("topicB", 1)), (Object)WatchForKafkaTopicPartitions.getAllTopicPartitions((SerializableFunction & Serializable)input -> mockConsumer, null, null, (Pattern)Pattern.compile("topic[A-Z]")));
    }

    @Test
    public void testPartitionSingle() {
        ImmutableSet givenTopics = ImmutableSet.of((Object)"topic1");
        WatchForKafkaTopicPartitions watchForKafkaTopicPartitions = new WatchForKafkaTopicPartitions(Duration.millis((long)1L), (SerializableFunction & Serializable)input -> new KafkaMocks.PartitionGrowthMockConsumer((List<List<KV<String, Integer>>>)ImmutableList.of((Object)ImmutableList.of((Object)KV.of((Object)"topic1", (Object)0)))), null, null, (Set)givenTopics, null, null, null);
        PCollection descriptors = (PCollection)this.p.apply((PTransform)watchForKafkaTopicPartitions);
        PAssert.that((PCollection)descriptors).containsInAnyOrder(new SerializableMatcher[]{new KafkaSourceDescriptionMatcher("topic1", 0)});
        this.p.run().waitUntilFinish(Duration.millis((long)10L));
    }

    @Test
    public void testPartitionGrowth() {
        ImmutableSet givenTopics = ImmutableSet.of((Object)"topic1");
        WatchForKafkaTopicPartitions watchForKafkaTopicPartitions = new WatchForKafkaTopicPartitions(Duration.millis((long)1L), (SerializableFunction & Serializable)input -> new KafkaMocks.PartitionGrowthMockConsumer((List<List<KV<String, Integer>>>)ImmutableList.of((Object)ImmutableList.of((Object)KV.of((Object)"topic1", (Object)0)), (Object)ImmutableList.of((Object)KV.of((Object)"topic1", (Object)0), (Object)KV.of((Object)"topic1", (Object)1)))), null, null, (Set)givenTopics, null, null, null);
        PCollection descriptors = (PCollection)this.p.apply((PTransform)watchForKafkaTopicPartitions);
        PAssert.that((PCollection)descriptors).containsInAnyOrder(new SerializableMatcher[]{new KafkaSourceDescriptionMatcher("topic1", 0), new KafkaSourceDescriptionMatcher("topic1", 1)});
        this.p.run().waitUntilFinish(Duration.millis((long)10L));
    }

    static {
        OPTIONS.setBlockOnRun(false);
    }

    private static class KafkaSourceDescriptionMatcher
    extends BaseMatcher<KafkaSourceDescriptor>
    implements SerializableMatcher<KafkaSourceDescriptor> {
        private String topic;
        private int partition;

        KafkaSourceDescriptionMatcher(String topic, int partition) {
            this.topic = topic;
            this.partition = partition;
        }

        public void describeMismatch(Object actual, Description mismatchDescription) {
        }

        public void describeTo(Description description) {
        }

        public boolean matches(Object o) {
            if (o instanceof KafkaSourceDescriptor) {
                KafkaSourceDescriptor descriptor = (KafkaSourceDescriptor)o;
                return descriptor.getTopic().equals(this.topic) && descriptor.getPartition() == this.partition;
            }
            return false;
        }
    }
}

