/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaMocks {

    public static final class PartitionGrowthMockConsumer
    extends MockConsumer<byte[], byte[]>
    implements Serializable {
        private List<List<KV<String, Integer>>> partitions;
        private int index = 0;

        public PartitionGrowthMockConsumer() {
            super(null);
        }

        public PartitionGrowthMockConsumer(List<List<KV<String, Integer>>> partitions) {
            super(null);
            this.partitions = partitions;
        }

        public synchronized List<PartitionInfo> partitionsFor(String topic) {
            List<KV<String, Integer>> partitionInfos = this.partitions.get(this.index);
            ++this.index;
            return partitionInfos.stream().map(kv -> new PartitionInfo((String)kv.getKey(), ((Integer)kv.getValue()).intValue(), null, null, null)).collect(Collectors.toList());
        }
    }

    public static final class PositionErrorConsumerFactory
    implements SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> {
        public MockConsumer<byte[], byte[]> apply(Map<String, Object> input) {
            if (input.containsKey("group.id")) {
                return new PositionErrorConsumer();
            }
            MockConsumer<byte[], byte[]> consumer = new MockConsumer<byte[], byte[]>(null){

                public synchronized long position(TopicPartition partition) {
                    return 1L;
                }

                public synchronized ConsumerRecords<byte[], byte[]> poll(long timeout) {
                    return ConsumerRecords.empty();
                }
            };
            consumer.updatePartitions("topic_a", Collections.singletonList(new PartitionInfo("topic_a", 1, new Node(1, "myServer1", 9092), null, null)));
            return consumer;
        }
    }

    public static final class PositionErrorConsumer
    extends MockConsumer<byte[], byte[]> {
        public PositionErrorConsumer() {
            super(null);
        }

        public synchronized long position(TopicPartition partition) {
            throw new KafkaException("fakeException");
        }

        public synchronized List<PartitionInfo> partitionsFor(String topic) {
            return Collections.singletonList(new PartitionInfo("topic_a", 1, new Node(1, "myServer1", 9092), null, null));
        }
    }

    public static final class SendErrorProducerFactory
    implements SerializableFunction<Map<String, Object>, Producer<Integer, Long>> {
        public Producer<Integer, Long> apply(Map<String, Object> input) {
            return new SendErrorProducer();
        }
    }

    public static final class SendErrorProducer
    extends MockProducer<Integer, Long> {
        public SendErrorProducer() {
            super(false, (Serializer)new IntegerSerializer(), (Serializer)new LongSerializer());
        }

        public synchronized Future<RecordMetadata> send(ProducerRecord<Integer, Long> record, Callback callback) {
            throw new KafkaException("fakeException");
        }
    }
}

