/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Map;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaIOUtils;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KafkaIOUtilsTest {
    @Test
    public void testOffsetConsumerConfigOverrides() throws Exception {
        KafkaIO.Read spec = KafkaIO.read().withBootstrapServers("broker_1:9092,broker_2:9092").withTopic("my_topic").withOffsetConsumerConfigOverrides(null);
        Map offsetConfig = KafkaIOUtils.getOffsetConsumerConfig((String)"name", (Map)spec.getOffsetConsumerConfig(), (Map)spec.getConsumerConfig());
        Assert.assertTrue((boolean)offsetConfig.get("group.id").toString().matches("name_offset_consumer_\\d+_none"));
        Assert.assertEquals((Object)false, offsetConfig.get("enable.auto.commit"));
        Assert.assertEquals((Object)"read_uncommitted", offsetConfig.get("isolation.level"));
        String offsetGroupId = "group.offsetConsumer";
        KafkaIO.Read spec2 = KafkaIO.read().withBootstrapServers("broker_1:9092,broker_2:9092").withTopic("my_topic").withOffsetConsumerConfigOverrides((Map)ImmutableMap.of((Object)"group.id", (Object)offsetGroupId));
        offsetConfig = KafkaIOUtils.getOffsetConsumerConfig((String)"name2", (Map)spec2.getOffsetConsumerConfig(), (Map)spec2.getConsumerConfig());
        Assert.assertEquals((Object)offsetGroupId, offsetConfig.get("group.id"));
        Assert.assertEquals((Object)false, offsetConfig.get("enable.auto.commit"));
        Assert.assertEquals((Object)"read_uncommitted", offsetConfig.get("isolation.level"));
    }
}

