/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaIOReadImplementationCompatibility;
import org.apache.beam.sdk.io.kafka.KafkaIOTest;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.CaseFormat;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KafkaIOReadImplementationCompatibilityTest {
    @Rule
    public final transient TestPipeline p = TestPipeline.create();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testKafkaIOReadPropertiesEnumValuePresence() {
        Set<String> properties = KafkaIOReadImplementationCompatibilityTest.getGetterPropertyNamesInUpperUnderscore(KafkaIO.Read.class);
        Set<String> enums = KafkaIOReadImplementationCompatibilityTest.getEnumValueNamesInUpperUnderscore(KafkaIOReadImplementationCompatibility.KafkaIOReadProperties.class);
        Sets.SetView missingEnums = Sets.difference(properties, enums);
        Sets.SetView unnecessaryEnums = Sets.difference(enums, properties);
        MatcherAssert.assertThat((String)"There are missing 'KafkaIOReadProperties' enum values!", (Object)missingEnums, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((String)"There are unnecessary 'KafkaIOReadProperties' enum values present!", (Object)unnecessaryEnums, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    private static Set<String> getGetterPropertyNamesInUpperUnderscore(Class<?> clazz) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (Method method : clazz.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || Void.TYPE.equals(method.getReturnType()) || method.getParameterCount() != 0) continue;
            for (String prefix : new String[]{"get", "is"}) {
                String methodName = method.getName();
                if (!methodName.startsWith(prefix) || methodName.length() <= prefix.length()) continue;
                String propertyName = methodName.substring(prefix.length());
                result.add(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, propertyName));
            }
        }
        return result;
    }

    private static Set<String> getEnumValueNamesInUpperUnderscore(Class<? extends Enum<?>> enumClazz) {
        return Stream.of(enumClazz.getEnumConstants()).map(v -> v.name()).collect(Collectors.toSet());
    }

    @Test
    public void testPrimitiveKafkaIOReadPropertiesDefaultValueExistence() {
        for (KafkaIOReadImplementationCompatibility.KafkaIOReadProperties properties : KafkaIOReadImplementationCompatibility.KafkaIOReadProperties.values()) {
            if (!properties.getGetterMethod().getReturnType().isPrimitive()) continue;
            MatcherAssert.assertThat((String)("KafkaIOReadProperties." + properties + " should have a default value!"), (Object)properties.getDefaultValue(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
    }

    private void testReadTransformCreationWithImplementationBoundProperties(Function<KafkaIO.Read<Integer, Long>, KafkaIO.Read<Integer, Long>> kafkaReadDecorator) {
        this.p.apply((PTransform)kafkaReadDecorator.apply(KafkaIOTest.mkKafkaReadTransform(1000, null, new KafkaIOTest.ValueAsTimestampFn())));
        this.p.run();
    }

    private Function<KafkaIO.Read<Integer, Long>, KafkaIO.Read<Integer, Long>> legacyDecoratorFunction() {
        return read -> read.withMaxReadTime(Duration.millis((long)10L));
    }

    private Function<KafkaIO.Read<Integer, Long>, KafkaIO.Read<Integer, Long>> sdfDecoratorFunction() {
        return read -> read.withStopReadTime(Instant.ofEpochMilli((long)10L));
    }

    @Test
    public void testReadTransformCreationWithLegacyImplementationBoundProperty() {
        this.testReadTransformCreationWithImplementationBoundProperties(this.legacyDecoratorFunction());
    }

    @Test
    public void testReadTransformCreationWithSdfImplementationBoundProperty() {
        this.testReadTransformCreationWithImplementationBoundProperties(this.sdfDecoratorFunction());
    }

    @Test
    public void testReadTransformCreationWithBothImplementationBoundProperties() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("every configured property");
        this.thrown.expectMessage("Not supported implementations");
        this.thrown.expectMessage("SDF");
        this.thrown.expectMessage("MAX_READ_TIME");
        this.thrown.expectMessage("LEGACY");
        this.thrown.expectMessage("STOP_READ_TIME");
        this.testReadTransformCreationWithImplementationBoundProperties(this.legacyDecoratorFunction().andThen(this.sdfDecoratorFunction()));
    }
}

