/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.io.kafka.KafkaCommitOffset;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaSourceDescriptor;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KafkaCommitOffsetTest {
    private final TopicPartition partition = new TopicPartition("topic", 0);
    private final KafkaCommitOffsetMockConsumer consumer = new KafkaCommitOffsetMockConsumer(null);

    @Test
    public void testCommitOffsetDoFn() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("group.id", "group1");
        KafkaIO.ReadSourceDescriptors descriptors = KafkaIO.ReadSourceDescriptors.read().withBootstrapServers("bootstrap_server").withConsumerConfigUpdates(configMap).withConsumerFactoryFn((SerializableFunction)new SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>>(){

            public Consumer<byte[], byte[]> apply(Map<String, Object> input) {
                Assert.assertEquals((Object)"group1", (Object)input.get("group.id"));
                return KafkaCommitOffsetTest.this.consumer;
            }
        });
        KafkaCommitOffset.CommitOffsetDoFn doFn = new KafkaCommitOffset.CommitOffsetDoFn(descriptors);
        doFn.processElement(KV.of((Object)KafkaSourceDescriptor.of((TopicPartition)this.partition, null, null, null, null, null), (Object)1L));
        Assert.assertEquals((long)2L, (long)this.consumer.commit.get(this.partition).offset());
    }

    private static class KafkaCommitOffsetMockConsumer
    extends MockConsumer<byte[], byte[]> {
        public Map<TopicPartition, OffsetAndMetadata> commit;

        public KafkaCommitOffsetMockConsumer(OffsetResetStrategy offsetResetStrategy) {
            super(offsetResetStrategy);
        }

        public synchronized void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
            this.commitAsync(offsets, null);
            this.commit = offsets;
        }
    }
}

