/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.kafka.ConsumerSpEL;
import org.apache.beam.sdk.io.kafka.ProducerRecordCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ConsumerSpEL.class})
public class ProducerRecordCoderTest {
    @Test
    public void testCoderIsSerializableWithWellKnownCoderType() {
        CoderProperties.coderSerializable((Coder)ProducerRecordCoder.of((Coder)GlobalWindow.Coder.INSTANCE, (Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testProducerRecordSerializableWithHeaders() throws IOException {
        RecordHeaders headers = new RecordHeaders();
        headers.add("headerKey", "headerVal".getBytes(StandardCharsets.UTF_8));
        this.verifySerialization((Headers)headers, 0, System.currentTimeMillis());
    }

    @Test
    public void testProducerRecordSerializableWithoutHeaders() throws IOException {
        ConsumerRecord consumerRecord = new ConsumerRecord("", 0, 0L, (Object)"", (Object)"");
        this.verifySerialization(consumerRecord.headers(), 0, System.currentTimeMillis());
    }

    @Test
    public void testProducerRecordSerializableWithPartition() throws IOException {
        ProducerRecord<String, String> decodedRecord = this.verifySerialization(1, System.currentTimeMillis());
        Assert.assertEquals((long)1L, (long)decodedRecord.partition().intValue());
    }

    @Test
    public void testProducerRecordSerializableWithoutPartition() throws IOException {
        ProducerRecord<String, String> decodedRecord = this.verifySerialization(null, System.currentTimeMillis());
        Assert.assertNull((Object)decodedRecord.partition());
    }

    @Test
    public void testProducerRecordSerializableWithTimestamp() throws IOException {
        long timestamp = System.currentTimeMillis();
        ProducerRecord<String, String> decodedRecord = this.verifySerialization(1, timestamp);
        Assert.assertEquals((long)timestamp, (long)decodedRecord.timestamp());
    }

    @Test
    public void testProducerRecordSerializableWithoutTimestamp() throws IOException {
        ProducerRecord<String, String> decodedRecord = this.verifySerialization(1, null);
        Assert.assertNull((Object)decodedRecord.timestamp());
    }

    @Test
    public void testProducerRecordStructuralValueWithHeadersApi() throws IOException {
        RecordHeaders headers = new RecordHeaders();
        headers.add("headerKey", "headerVal".getBytes(StandardCharsets.UTF_8));
        ProducerRecordCoder producerRecordCoder = ProducerRecordCoder.of((Coder)ByteArrayCoder.of(), (Coder)ByteArrayCoder.of());
        ProducerRecord producerRecord = new ProducerRecord("topic", Integer.valueOf(1), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8), (Iterable)headers);
        ProducerRecord testProducerRecord = (ProducerRecord)producerRecordCoder.structuralValue(producerRecord);
        Assert.assertEquals((Object)testProducerRecord.headers(), (Object)headers);
    }

    @Test
    public void testProducerRecordStructuralValueWithoutHeadersApi() throws IOException {
        RecordHeaders headers = new RecordHeaders();
        headers.add("headerKey", "headerVal".getBytes(StandardCharsets.UTF_8));
        ProducerRecordCoder producerRecordCoder = ProducerRecordCoder.of((Coder)ByteArrayCoder.of(), (Coder)ByteArrayCoder.of());
        ProducerRecord producerRecord = new ProducerRecord("topic", Integer.valueOf(1), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8), (Iterable)headers);
        PowerMockito.mockStatic(ConsumerSpEL.class, (Class[])new Class[0]);
        Mockito.when((Object)ConsumerSpEL.hasHeaders()).thenReturn((Object)false);
        ProducerRecord testProducerRecord = (ProducerRecord)producerRecordCoder.structuralValue(producerRecord);
        Assert.assertEquals((Object)testProducerRecord.headers(), (Object)new RecordHeaders());
    }

    private ProducerRecord<String, String> verifySerialization(Integer partition, Long timestamp) throws IOException {
        return this.verifySerialization(null, partition, timestamp);
    }

    private ProducerRecord<String, String> verifySerialization(Headers headers, Integer partition, Long timestamp) throws IOException {
        ProducerRecord producerRecord = new ProducerRecord("topic", partition, timestamp, (Object)"key", (Object)"value", (Iterable)headers);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ProducerRecordCoder producerRecordCoder = ProducerRecordCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of());
        producerRecordCoder.encode(producerRecord, (OutputStream)outputStream);
        ProducerRecord decodedRecord = producerRecordCoder.decode((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        Assert.assertEquals((Object)producerRecord, (Object)decodedRecord);
        return decodedRecord;
    }
}

