/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Map;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.kafka.LocalDeserializerProvider;
import org.apache.beam.sdk.io.kafka.serialization.InstantDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LocalDeserializerProviderTest {
    @Rule
    public ExpectedException cannotInferException = ExpectedException.none();

    @Test
    public void testInferKeyCoder() {
        CoderRegistry registry = CoderRegistry.createDefault();
        Assert.assertTrue((boolean)(LocalDeserializerProvider.of(LongDeserializer.class).getCoder(registry).getValueCoder() instanceof VarLongCoder));
        Assert.assertTrue((boolean)(LocalDeserializerProvider.of(StringDeserializer.class).getCoder(registry).getValueCoder() instanceof StringUtf8Coder));
        Assert.assertTrue((boolean)(LocalDeserializerProvider.of(InstantDeserializer.class).getCoder(registry).getValueCoder() instanceof InstantCoder));
        Assert.assertTrue((boolean)(LocalDeserializerProvider.of(DeserializerWithInterfaces.class).getCoder(registry).getValueCoder() instanceof VarLongCoder));
    }

    @Test
    public void testInferKeyCoderFailure() throws Exception {
        this.cannotInferException.expect(RuntimeException.class);
        CoderRegistry registry = CoderRegistry.createDefault();
        LocalDeserializerProvider.of(NonInferableObjectDeserializer.class).getCoder(registry);
    }

    private static class NonInferableObjectDeserializer
    implements Deserializer<NonInferableObject> {
        private NonInferableObjectDeserializer() {
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public NonInferableObject deserialize(String topic, byte[] bytes) {
            return new NonInferableObject();
        }

        public void close() {
        }
    }

    private static class NonInferableObject {
        private NonInferableObject() {
        }
    }

    private static class DeserializerWithInterfaces
    implements DummyInterface<String>,
    DummyNonparametricInterface,
    Deserializer<Long> {
        private DeserializerWithInterfaces() {
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public Long deserialize(String topic, byte[] bytes) {
            return 0L;
        }

        public void close() {
        }
    }

    private static interface DummyNonparametricInterface {
    }

    private static interface DummyInterface<T> {
    }
}

