/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.testutil.MockSchemaRegistry;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.io.kafka.ConfluentSchemaRegistryDeserializerProvider;
import org.apache.beam.sdk.io.kafka.DeserializerProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConfluentSchemaRegistryDeserializerProviderTest {
    private static final String AVRO_SCHEMA_STRING = "{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"AvroGeneratedUser\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"favorite_number\", \"type\": [\"int\", \"null\"]},\n     {\"name\": \"favorite_color\", \"type\": [\"string\", \"null\"]}\n ]\n}";
    private static final Schema AVRO_SCHEMA = new Schema.Parser().parse("{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"AvroGeneratedUser\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"favorite_number\", \"type\": [\"int\", \"null\"]},\n     {\"name\": \"favorite_color\", \"type\": [\"string\", \"null\"]}\n ]\n}");
    private static final String AVRO_SCHEMA_V1_STRING = "{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"AvroGeneratedUser\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"age\", \"type\": \"int\"},\n     {\"name\": \"favorite_number\", \"type\": [\"int\", \"null\"]},\n     {\"name\": \"favorite_color\", \"type\": [\"string\", \"null\"]}\n ]\n}";
    private static final Schema AVRO_SCHEMA_V1 = new Schema.Parser().parse("{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"AvroGeneratedUser\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"age\", \"type\": \"int\"},\n     {\"name\": \"favorite_number\", \"type\": [\"int\", \"null\"]},\n     {\"name\": \"favorite_color\", \"type\": [\"string\", \"null\"]}\n ]\n}");

    @Test
    public void testGetCoder() {
        String schemaRegistryUrl = "mock://my-scope-name";
        String subject = "mytopic";
        SchemaRegistryClient mockRegistryClient = ConfluentSchemaRegistryDeserializerProviderTest.mockSchemaRegistryClient(schemaRegistryUrl, subject);
        CoderRegistry coderRegistry = CoderRegistry.createDefault();
        AvroCoder coderV0 = (AvroCoder)ConfluentSchemaRegistryDeserializerProviderTest.mockDeserializerProvider(schemaRegistryUrl, subject, null).getCoder(coderRegistry);
        Assert.assertEquals((Object)AVRO_SCHEMA, (Object)coderV0.getSchema());
        try {
            Integer version = mockRegistryClient.getVersion(subject, AVRO_SCHEMA_V1);
            AvroCoder coderV1 = (AvroCoder)ConfluentSchemaRegistryDeserializerProviderTest.mockDeserializerProvider(schemaRegistryUrl, subject, version).getCoder(coderRegistry);
            Assert.assertEquals((Object)AVRO_SCHEMA_V1, (Object)coderV1.getSchema());
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException("Unable to register schema for subject: " + subject, e);
        }
    }

    @Test
    public void testDeserialize() {
        String schemaRegistryUrl = "mock://my-scope-name";
        String subject = "mytopic";
        SchemaRegistryClient mockRegistryClient = ConfluentSchemaRegistryDeserializerProviderTest.mockSchemaRegistryClient(schemaRegistryUrl, subject);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auto.register.schemas", true);
        map.put("schema.registry.url", schemaRegistryUrl);
        KafkaAvroSerializer serializer = new KafkaAvroSerializer(mockRegistryClient);
        serializer.configure(map, true);
        byte[] bytes = serializer.serialize(subject, (Object)new GenericRecordBuilder(AVRO_SCHEMA_V1).set("name", (Object)"KeyName").set("age", (Object)1).set("favorite_number", (Object)2).set("favorite_color", (Object)"color3").build());
        Object deserialized = ConfluentSchemaRegistryDeserializerProviderTest.mockDeserializerProvider(schemaRegistryUrl, subject, null).getDeserializer(new HashMap(), true).deserialize(subject, bytes);
        GenericData.Record expected = new GenericRecordBuilder(AVRO_SCHEMA).set("name", (Object)"KeyName").set("favorite_number", (Object)2).set("favorite_color", (Object)"color3").build();
        Assert.assertEquals((Object)expected, (Object)deserialized);
    }

    static <T> DeserializerProvider<T> mockDeserializerProvider(String schemaRegistryUrl, String subject, Integer version) {
        return new ConfluentSchemaRegistryDeserializerProvider((SerializableFunction & Serializable)input -> ConfluentSchemaRegistryDeserializerProviderTest.mockSchemaRegistryClient(schemaRegistryUrl, subject), schemaRegistryUrl, subject, version);
    }

    private static SchemaRegistryClient mockSchemaRegistryClient(String schemaRegistryUrl, String subject) {
        SchemaRegistryClient mockRegistryClient = MockSchemaRegistry.getClientForScope((String)schemaRegistryUrl);
        try {
            mockRegistryClient.register(subject, AVRO_SCHEMA_V1);
            mockRegistryClient.register(subject, AVRO_SCHEMA);
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException("Unable to register schema for subject: " + subject, e);
        }
        return mockRegistryClient;
    }
}

