/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdks.java.io.kafka.repackaged.com.google.common.base.Joiner;

@DefaultCoder(value=AvroCoder.class)
public class KafkaCheckpointMark
implements UnboundedSource.CheckpointMark {
    private List<PartitionMark> partitions;

    private KafkaCheckpointMark() {
    }

    public KafkaCheckpointMark(List<PartitionMark> partitions) {
        this.partitions = partitions;
    }

    public List<PartitionMark> getPartitions() {
        return this.partitions;
    }

    public void finalizeCheckpoint() throws IOException {
    }

    public String toString() {
        return "KafkaCheckpointMark{partitions=" + Joiner.on(",").join(this.partitions) + '}';
    }

    public static class PartitionMark
    implements Serializable {
        private String topic;
        private int partition;
        private long nextOffset;

        private PartitionMark() {
        }

        public PartitionMark(String topic, int partition, long offset) {
            this.topic = topic;
            this.partition = partition;
            this.nextOffset = offset;
        }

        public String getTopic() {
            return this.topic;
        }

        public int getPartition() {
            return this.partition;
        }

        public long getNextOffset() {
            return this.nextOffset;
        }

        public String toString() {
            return "PartitionMark{topic='" + this.topic + '\'' + ", partition=" + this.partition + ", nextOffset=" + this.nextOffset + '}';
        }
    }
}

