/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.Serializer;

final class AutoValue_KafkaIO_Write<K, V>
extends KafkaIO.Write<K, V> {
    private final String topic;
    private final Map<String, Object> producerConfig;
    private final SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn;
    private final Class<? extends Serializer<K>> keySerializer;
    private final Class<? extends Serializer<V>> valueSerializer;

    private AutoValue_KafkaIO_Write(@Nullable String topic, Map<String, Object> producerConfig, @Nullable SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn, @Nullable Class<? extends Serializer<K>> keySerializer, @Nullable Class<? extends Serializer<V>> valueSerializer) {
        this.topic = topic;
        this.producerConfig = producerConfig;
        this.producerFactoryFn = producerFactoryFn;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    @Nullable
    String getTopic() {
        return this.topic;
    }

    @Override
    Map<String, Object> getProducerConfig() {
        return this.producerConfig;
    }

    @Override
    @Nullable
    SerializableFunction<Map<String, Object>, Producer<K, V>> getProducerFactoryFn() {
        return this.producerFactoryFn;
    }

    @Override
    @Nullable
    Class<? extends Serializer<K>> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    @Nullable
    Class<? extends Serializer<V>> getValueSerializer() {
        return this.valueSerializer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaIO.Write) {
            KafkaIO.Write that = (KafkaIO.Write)((Object)o);
            return (this.topic == null ? that.getTopic() == null : this.topic.equals(that.getTopic())) && this.producerConfig.equals(that.getProducerConfig()) && (this.producerFactoryFn == null ? that.getProducerFactoryFn() == null : this.producerFactoryFn.equals(that.getProducerFactoryFn())) && (this.keySerializer == null ? that.getKeySerializer() == null : this.keySerializer.equals(that.getKeySerializer())) && (this.valueSerializer == null ? that.getValueSerializer() == null : this.valueSerializer.equals(that.getValueSerializer()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.topic == null ? 0 : this.topic.hashCode();
        h *= 1000003;
        h ^= this.producerConfig.hashCode();
        h *= 1000003;
        h ^= this.producerFactoryFn == null ? 0 : this.producerFactoryFn.hashCode();
        h *= 1000003;
        h ^= this.keySerializer == null ? 0 : this.keySerializer.hashCode();
        h *= 1000003;
        return h ^= this.valueSerializer == null ? 0 : this.valueSerializer.hashCode();
    }

    @Override
    KafkaIO.Write.Builder<K, V> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<K, V>
    extends KafkaIO.Write.Builder<K, V> {
        private String topic;
        private Map<String, Object> producerConfig;
        private SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn;
        private Class<? extends Serializer<K>> keySerializer;
        private Class<? extends Serializer<V>> valueSerializer;

        Builder() {
        }

        private Builder(KafkaIO.Write<K, V> source) {
            this.topic = source.getTopic();
            this.producerConfig = source.getProducerConfig();
            this.producerFactoryFn = source.getProducerFactoryFn();
            this.keySerializer = source.getKeySerializer();
            this.valueSerializer = source.getValueSerializer();
        }

        @Override
        KafkaIO.Write.Builder<K, V> setTopic(@Nullable String topic) {
            this.topic = topic;
            return this;
        }

        @Override
        KafkaIO.Write.Builder<K, V> setProducerConfig(Map<String, Object> producerConfig) {
            if (producerConfig == null) {
                throw new NullPointerException("Null producerConfig");
            }
            this.producerConfig = producerConfig;
            return this;
        }

        @Override
        KafkaIO.Write.Builder<K, V> setProducerFactoryFn(@Nullable SerializableFunction<Map<String, Object>, Producer<K, V>> producerFactoryFn) {
            this.producerFactoryFn = producerFactoryFn;
            return this;
        }

        @Override
        KafkaIO.Write.Builder<K, V> setKeySerializer(@Nullable Class<? extends Serializer<K>> keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        @Override
        KafkaIO.Write.Builder<K, V> setValueSerializer(@Nullable Class<? extends Serializer<V>> valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        @Override
        KafkaIO.Write<K, V> build() {
            String missing = "";
            if (this.producerConfig == null) {
                missing = missing + " producerConfig";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KafkaIO_Write(this.topic, this.producerConfig, this.producerFactoryFn, this.keySerializer, this.valueSerializer);
        }
    }
}

