/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.io.kafka.KafkaRecordCoder;
import org.apache.beam.sdk.io.kafka.KafkaTimestampType;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KafkaRecordCoderTest {
    @Test
    public void testCoderIsSerializableWithWellKnownCoderType() {
        CoderProperties.coderSerializable((Coder)KafkaRecordCoder.of((Coder)GlobalWindow.Coder.INSTANCE, (Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testKafkaRecordSerializableWithHeaders() throws IOException {
        RecordHeaders headers = new RecordHeaders();
        headers.add("headerKey", "headerVal".getBytes(StandardCharsets.UTF_8));
        this.verifySerialization((Headers)headers);
    }

    @Test
    public void testKafkaRecordSerializableWithoutHeaders() throws IOException {
        ConsumerRecord consumerRecord = new ConsumerRecord("", 0, 0L, (Object)"", (Object)"");
        this.verifySerialization(consumerRecord.headers());
    }

    private void verifySerialization(Headers headers) throws IOException {
        KafkaRecord kafkaRecord = new KafkaRecord("topic", 0, 0L, 0L, KafkaTimestampType.CREATE_TIME, headers, (Object)"key", (Object)"value");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        KafkaRecordCoder kafkaRecordCoder = KafkaRecordCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of());
        kafkaRecordCoder.encode(kafkaRecord, (OutputStream)outputStream);
        KafkaRecord decodedRecord = kafkaRecordCoder.decode((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        Assert.assertEquals((Object)kafkaRecord, (Object)decodedRecord);
    }
}

