/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.sdk.io.kafka.KafkaTimestampType;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class ConsumerSpEL {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerSpEL.class);
    private SpelParserConfiguration config = new SpelParserConfiguration(true, true);
    private ExpressionParser parser = new SpelExpressionParser(this.config);
    private Expression seek2endExpression = this.parser.parseExpression("#consumer.seekToEnd(#tp)");
    private Expression assignExpression = this.parser.parseExpression("#consumer.assign(#tp)");
    private boolean hasRecordTimestamp = false;
    private boolean hasOffsetsForTimes = false;

    static boolean hasHeaders() {
        boolean clientHasHeaders = false;
        try {
            clientHasHeaders = "org.apache.kafka.common.header.Headers".equals(ConsumerRecord.class.getMethod("headers", null).getReturnType().getName());
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("Headers is not available");
        }
        return clientHasHeaders;
    }

    public ConsumerSpEL() {
        try {
            this.hasRecordTimestamp = ConsumerRecord.class.getMethod("timestamp", null).getReturnType().equals(Long.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("Timestamp for Kafka message is not available.");
        }
        try {
            this.hasOffsetsForTimes = Consumer.class.getMethod("offsetsForTimes", Map.class).getReturnType().equals(Map.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.debug("OffsetsForTimes is not available.");
        }
    }

    public void evaluateSeek2End(Consumer consumer, TopicPartition topicPartition) {
        StandardEvaluationContext mapContext = new StandardEvaluationContext();
        mapContext.setVariable("consumer", (Object)consumer);
        mapContext.setVariable("tp", (Object)topicPartition);
        this.seek2endExpression.getValue((EvaluationContext)mapContext);
    }

    public void evaluateAssign(Consumer consumer, Collection<TopicPartition> topicPartitions) {
        StandardEvaluationContext mapContext = new StandardEvaluationContext();
        mapContext.setVariable("consumer", (Object)consumer);
        mapContext.setVariable("tp", topicPartitions);
        this.assignExpression.getValue((EvaluationContext)mapContext);
    }

    public long getRecordTimestamp(ConsumerRecord<byte[], byte[]> rawRecord) {
        if (this.hasRecordTimestamp) {
            return rawRecord.timestamp();
        }
        return -1L;
    }

    public KafkaTimestampType getRecordTimestampType(ConsumerRecord<byte[], byte[]> rawRecord) {
        if (this.hasRecordTimestamp) {
            return KafkaTimestampType.forOrdinal(rawRecord.timestampType().ordinal());
        }
        return KafkaTimestampType.NO_TIMESTAMP_TYPE;
    }

    public boolean hasOffsetsForTimes() {
        return this.hasOffsetsForTimes;
    }

    public long offsetForTime(Consumer<?, ?> consumer, TopicPartition topicPartition, Instant time) {
        Preconditions.checkArgument((boolean)this.hasOffsetsForTimes, (Object)"This Kafka Client must support Consumer.OffsetsForTimes().");
        OffsetAndTimestamp offsetAndTimestamp = (OffsetAndTimestamp)Iterables.getOnlyElement(consumer.offsetsForTimes((Map)ImmutableMap.of((Object)topicPartition, (Object)time.getMillis())).values());
        if (offsetAndTimestamp == null) {
            throw new RuntimeException("There are no messages has a timestamp that is greater than or equals to the target time or the message format version in this partition is before 0.10.0, topicPartition is: " + topicPartition);
        }
        return offsetAndTimestamp.offset();
    }
}

