/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka.upgrade;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.upgrade.KafkaIOTranslation;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.construction.TransformUpgrader;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KafkaIOTranslationTest {
    static final Map<String, String> READ_TRANSFORM_SCHEMA_MAPPING = new HashMap<String, String>();
    static final Map<String, String> WRITE_TRANSFORM_SCHEMA_MAPPING;

    @Test
    public void testReCreateReadTransformFromRow() throws Exception {
        HashMap<String, String> consumerConfig = new HashMap<String, String>();
        consumerConfig.put("dummyconfig", "dummyvalue");
        KafkaIO.Read readTransform = KafkaIO.read().withBootstrapServers("dummykafkaserver").withTopicPartitions(IntStream.range(0, 1).mapToObj(i -> new TopicPartition("dummytopic", i)).collect(Collectors.toList())).withConsumerConfigUpdates(consumerConfig);
        KafkaIOTranslation.KafkaIOReadWithMetadataTranslator translator = new KafkaIOTranslation.KafkaIOReadWithMetadataTranslator();
        Row row = translator.toConfigRow(readTransform);
        KafkaIO.Read readTransformFromRow = translator.fromConfigRow(row, PipelineOptionsFactory.create());
        Assert.assertNotNull(readTransformFromRow.getConsumerConfig().get("bootstrap.servers"));
        Assert.assertEquals((Object)"dummykafkaserver", readTransformFromRow.getConsumerConfig().get("bootstrap.servers"));
        Assert.assertEquals((long)1L, (long)readTransformFromRow.getTopicPartitions().size());
        Assert.assertEquals((Object)"dummytopic", (Object)((TopicPartition)readTransformFromRow.getTopicPartitions().get(0)).topic());
        Assert.assertEquals((long)0L, (long)((TopicPartition)readTransformFromRow.getTopicPartitions().get(0)).partition());
    }

    @Test
    public void testReCreateReadTransformWithTopics() throws Exception {
        HashMap<String, String> consumerConfig = new HashMap<String, String>();
        consumerConfig.put("dummyconfig", "dummyvalue");
        KafkaIO.Read readTransform = KafkaIO.read().withBootstrapServers("dummykafkaserver").withTopic("dummytopic").withConsumerConfigUpdates(consumerConfig);
        KafkaIOTranslation.KafkaIOReadWithMetadataTranslator translator = new KafkaIOTranslation.KafkaIOReadWithMetadataTranslator();
        Row row = translator.toConfigRow(readTransform);
        KafkaIO.Read readTransformFromRow = translator.fromConfigRow(row, PipelineOptionsFactory.create());
        Assert.assertNotNull(readTransformFromRow.getConsumerConfig().get("bootstrap.servers"));
        Assert.assertEquals((Object)"dummykafkaserver", readTransformFromRow.getConsumerConfig().get("bootstrap.servers"));
        Assert.assertEquals((long)1L, (long)readTransformFromRow.getTopics().size());
        Assert.assertEquals((Object)"dummytopic", readTransformFromRow.getTopics().get(0));
    }

    @Test
    public void testReadTransformRowIncludesAllFields() throws Exception {
        ImmutableList fieldsToIgnore = ImmutableList.of((Object)"getBadRecordRouter", (Object)"getBadRecordErrorHandler");
        List getMethodNames = Arrays.stream(KafkaIO.Read.class.getDeclaredMethods()).map(method -> method.getName()).filter(methodName -> methodName.startsWith("get")).filter(arg_0 -> KafkaIOTranslationTest.lambda$testReadTransformRowIncludesAllFields$3((List)fieldsToIgnore, arg_0)).collect(Collectors.toList());
        Assert.assertTrue((getMethodNames.size() > 0 ? 1 : 0) != 0);
        for (String getMethodName : getMethodNames) {
            Assert.assertTrue((String)("Method " + getMethodName + " will not be tracked when upgrading the 'KafkaIO.Read' transform. Please update 'KafkaIOTranslation.KafkaIOReadWithMetadataTranslator' to track the new method and update this test."), (boolean)READ_TRANSFORM_SCHEMA_MAPPING.keySet().contains(getMethodName));
        }
        READ_TRANSFORM_SCHEMA_MAPPING.values().stream().forEach(fieldName -> Assert.assertTrue((String)("Field name " + fieldName + " was not found in the read transform schema defined in KafkaIOReadWithMetadataTranslator."), (boolean)KafkaIOTranslation.KafkaIOReadWithMetadataTranslator.schema.getFieldNames().contains(fieldName)));
    }

    @Test
    public void testReCreateWriteTransformFromRow() throws Exception {
        HashMap<String, String> producerConfig = new HashMap<String, String>();
        producerConfig.put("dummyconfig", "dummyvalue");
        KafkaIO.Write writeTransform = KafkaIO.write().withBootstrapServers("dummybootstrapserver").withTopic("dummytopic").withProducerConfigUpdates(producerConfig);
        KafkaIOTranslation.KafkaIOWriteTranslator translator = new KafkaIOTranslation.KafkaIOWriteTranslator();
        Row row = translator.toConfigRow(writeTransform);
        KafkaIO.Write writeTransformFromRow = translator.fromConfigRow(row, PipelineOptionsFactory.create());
        KafkaIO.WriteRecords writeRecordsTransform = writeTransformFromRow.getWriteRecordsTransform();
        Assert.assertNotNull(writeRecordsTransform.getProducerConfig().get("bootstrap.servers"));
        Assert.assertEquals((Object)"dummybootstrapserver", writeRecordsTransform.getProducerConfig().get("bootstrap.servers"));
        Assert.assertEquals((Object)"dummytopic", (Object)writeRecordsTransform.getTopic());
        Map producerConfigFromRow = writeRecordsTransform.getProducerConfig();
        Assert.assertTrue((boolean)producerConfigFromRow.containsKey("dummyconfig"));
        Assert.assertEquals((Object)"dummyvalue", producerConfigFromRow.get("dummyconfig"));
    }

    @Test
    public void testWriteTransformRowIncludesAllFields() throws Exception {
        ImmutableList fieldsToIgnore = ImmutableList.of((Object)"getBadRecordRouter", (Object)"getBadRecordErrorHandler");
        List getMethodNames = Arrays.stream(KafkaIO.WriteRecords.class.getDeclaredMethods()).map(method -> method.getName()).filter(methodName -> methodName.startsWith("get")).filter(arg_0 -> KafkaIOTranslationTest.lambda$testWriteTransformRowIncludesAllFields$7((List)fieldsToIgnore, arg_0)).collect(Collectors.toList());
        Assert.assertTrue((getMethodNames.size() > 0 ? 1 : 0) != 0);
        for (String getMethodName : getMethodNames) {
            Assert.assertTrue((String)("Method " + getMethodName + " will not be tracked when upgrading the 'KafkaIO.Write' transform. Please update 'KafkaIOTranslation.KafkaIOWriteTranslator' to track the new method and update this test."), (boolean)WRITE_TRANSFORM_SCHEMA_MAPPING.keySet().contains(getMethodName));
        }
        WRITE_TRANSFORM_SCHEMA_MAPPING.values().stream().forEach(fieldName -> Assert.assertTrue((String)("Field name " + fieldName + " was not found in the write transform schema defined in KafkaIOWriteWithMetadataTranslator."), (boolean)KafkaIOTranslation.KafkaIOWriteTranslator.schema.getFieldNames().contains(fieldName)));
    }

    @Test
    public void testReadTransformURNDiscovery() {
        KafkaIO.Read readTransform = KafkaIO.read().withBootstrapServers("dummykafkaserver").withTopicPartitions(IntStream.range(0, 1).mapToObj(i -> new TopicPartition("dummytopic", i)).collect(Collectors.toList()));
        Assert.assertEquals((Object)"beam:transform:org.apache.beam:kafka_read_with_metadata:v2", (Object)TransformUpgrader.findUpgradeURN((PTransform)readTransform));
    }

    @Test
    public void testWriteTransformURNDiscovery() {
        KafkaIO.Write writeTransform = KafkaIO.write().withBootstrapServers("dummybootstrapserver").withTopic("dummytopic");
        Assert.assertEquals((Object)"beam:transform:org.apache.beam:kafka_write:v2", (Object)TransformUpgrader.findUpgradeURN((PTransform)writeTransform));
    }

    private static /* synthetic */ boolean lambda$testWriteTransformRowIncludesAllFields$7(List fieldsToIgnore, String methodName) {
        return !fieldsToIgnore.contains(methodName);
    }

    private static /* synthetic */ boolean lambda$testReadTransformRowIncludesAllFields$3(List fieldsToIgnore, String methodName) {
        return !fieldsToIgnore.contains(methodName);
    }

    static {
        READ_TRANSFORM_SCHEMA_MAPPING.put("getConsumerConfig", "consumer_config");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getTopics", "topics");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getTopicPartitions", "topic_partitions");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getTopicPattern", "topic_pattern");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getKeyCoder", "key_coder");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getValueCoder", "value_coder");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getConsumerFactoryFn", "consumer_factory_fn");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getWatermarkFn", "watermark_fn");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getMaxNumRecords", "max_num_records");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getMaxReadTime", "max_read_time");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getStartReadTime", "start_read_time");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getStopReadTime", "stop_read_time");
        READ_TRANSFORM_SCHEMA_MAPPING.put("isCommitOffsetsInFinalizeEnabled", "is_commit_offset_finalize_enabled");
        READ_TRANSFORM_SCHEMA_MAPPING.put("isDynamicRead", "is_dynamic_read");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getWatchTopicPartitionDuration", "watch_topic_partition_duration");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getTimestampPolicyFactory", "timestamp_policy_factory");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getOffsetConsumerConfig", "offset_consumer_config");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getKeyDeserializerProvider", "key_deserializer_provider");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getValueDeserializerProvider", "value_deserializer_provider");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getCheckStopReadingFn", "check_stop_reading_fn");
        READ_TRANSFORM_SCHEMA_MAPPING.put("getConsumerPollingTimeout", "consumer_polling_timeout");
        WRITE_TRANSFORM_SCHEMA_MAPPING = new HashMap<String, String>();
        WRITE_TRANSFORM_SCHEMA_MAPPING.put("getTopic", "topic");
        WRITE_TRANSFORM_SCHEMA_MAPPING.put("getProducerConfig", "producer_config");
        WRITE_TRANSFORM_SCHEMA_MAPPING.put("getProducerFactoryFn", "producer_factory_fn");
        WRITE_TRANSFORM_SCHEMA_MAPPING.put("getKeySerializer", "key_serializer");
        WRITE_TRANSFORM_SCHEMA_MAPPING.put("getValueSerializer", "value_serializer");
        WRITE_TRANSFORM_SCHEMA_MAPPING.put("getPublishTimestampFunction", "publish_timestamp_fn");
        WRITE_TRANSFORM_SCHEMA_MAPPING.put("isEOS", "eos");
        WRITE_TRANSFORM_SCHEMA_MAPPING.put("getSinkGroupId", "sink_group_id");
        WRITE_TRANSFORM_SCHEMA_MAPPING.put("getNumShards", "num_shards");
        WRITE_TRANSFORM_SCHEMA_MAPPING.put("getConsumerFactoryFn", "consumer_factory_fn");
    }
}

