/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka.upgrade;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.kafka.DeserializerProvider;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaIOUtils;
import org.apache.beam.sdk.io.kafka.TimestampPolicyFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.NanosDuration;
import org.apache.beam.sdk.schemas.logicaltypes.NanosInstant;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.errorhandling.ErrorHandler;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.util.construction.TransformUpgrader;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.kafka.common.TopicPartition;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class KafkaIOTranslation {
    public static final @UnknownKeyFor @NonNull @Initialized String KAFKA_READ_WITH_METADATA_TRANSFORM_URN_V2 = "beam:transform:org.apache.beam:kafka_read_with_metadata:v2";
    public static final @UnknownKeyFor @NonNull @Initialized String KAFKA_WRITE_TRANSFORM_URN_V2 = "beam:transform:org.apache.beam:kafka_write:v2";

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class WriteRegistrar
    implements TransformPayloadTranslatorRegistrar {
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put((Object)KafkaIO.Write.AUTOVALUE_CLASS, (Object)new KafkaIOWriteTranslator()).build();
        }
    }

    static class KafkaIOWriteTranslator
    implements PTransformTranslation.TransformPayloadTranslator<KafkaIO.Write<?, ?>> {
        static @UnknownKeyFor @NonNull @Initialized Schema schema = Schema.builder().addStringField("bootstrap_servers").addNullableStringField("topic").addNullableByteArrayField("key_serializer").addNullableByteArrayField("value_serializer").addNullableByteArrayField("producer_factory_fn").addNullableByteArrayField("publish_timestamp_fn").addBooleanField("eos").addInt32Field("num_shards").addNullableStringField("sink_group_id").addNullableByteArrayField("consumer_factory_fn").addNullableMapField("producer_config", Schema.FieldType.STRING, Schema.FieldType.BYTES).build();

        KafkaIOWriteTranslator() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return KafkaIOTranslation.KAFKA_WRITE_TRANSFORM_URN_V2;
        }

        public @UnknownKeyFor @NonNull @Initialized String getUrn(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized KafkaIO.Write<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform) {
            return super.getUrn(transform);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable @UnknownKeyFor @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized KafkaIO.Write<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> application, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn()).setPayload(ByteString.empty()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Row toConfigRow(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized KafkaIO.Write<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            KafkaIO.WriteRecords writeRecordsTransform = transform.getWriteRecordsTransform();
            if (!writeRecordsTransform.getProducerConfig().containsKey("bootstrap.servers")) {
                throw new IllegalArgumentException("Expected the producer config to have 'ConsumerConfig.BOOTSTRAP_SERVERS_CONFIG' set. Found: " + writeRecordsTransform.getProducerConfig());
            }
            fieldValues.put("bootstrap_servers", writeRecordsTransform.getProducerConfig().get("bootstrap.servers"));
            if (writeRecordsTransform.getTopic() != null) {
                fieldValues.put("topic", writeRecordsTransform.getTopic());
            }
            if (writeRecordsTransform.getKeySerializer() != null) {
                fieldValues.put("key_serializer", TransformUpgrader.toByteArray((Object)writeRecordsTransform.getKeySerializer()));
            }
            if (writeRecordsTransform.getValueSerializer() != null) {
                fieldValues.put("value_serializer", TransformUpgrader.toByteArray((Object)writeRecordsTransform.getValueSerializer()));
            }
            if (writeRecordsTransform.getProducerFactoryFn() != null) {
                fieldValues.put("producer_factory_fn", TransformUpgrader.toByteArray((Object)writeRecordsTransform.getProducerFactoryFn()));
            }
            if (writeRecordsTransform.getPublishTimestampFunction() != null) {
                fieldValues.put("publish_timestamp_fn", TransformUpgrader.toByteArray((Object)writeRecordsTransform.getPublishTimestampFunction()));
            }
            fieldValues.put("eos", writeRecordsTransform.isEOS());
            fieldValues.put("num_shards", writeRecordsTransform.getNumShards());
            if (writeRecordsTransform.getSinkGroupId() != null) {
                fieldValues.put("sink_group_id", writeRecordsTransform.getSinkGroupId());
            }
            if (writeRecordsTransform.getConsumerFactoryFn() != null) {
                fieldValues.put("consumer_factory_fn", TransformUpgrader.toByteArray((Object)writeRecordsTransform.getConsumerFactoryFn()));
            }
            if (writeRecordsTransform.getProducerConfig().size() > 0) {
                HashMap producerConfigMap = new HashMap();
                writeRecordsTransform.getProducerConfig().forEach((key, value) -> producerConfigMap.put(key, TransformUpgrader.toByteArray((Object)value)));
                fieldValues.put("producer_config", producerConfigMap);
            }
            if (writeRecordsTransform.getBadRecordErrorHandler() != null && !(writeRecordsTransform.getBadRecordErrorHandler() instanceof ErrorHandler.DefaultErrorHandler)) {
                throw new RuntimeException("Upgrading KafkaIO write transforms that have `withBadRecordErrorHandler` property setis not supported yet.");
            }
            return Row.withSchema((Schema)schema).withFieldValues(fieldValues).build();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized KafkaIO.Write<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromConfigRow(@UnknownKeyFor @NonNull @Initialized Row configRow, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            try {
                Map producerConfig;
                byte[] consumerFactoryFnBytes;
                Boolean isEOS;
                byte[] producerFactoryFnBytes;
                byte[] valueSerializerBytes;
                byte[] keySerializerBytes;
                String topic;
                KafkaIO.Write transform = KafkaIO.write();
                String bootstrapServers = configRow.getString("bootstrap_servers");
                if (bootstrapServers != null) {
                    transform = transform.withBootstrapServers(bootstrapServers);
                }
                if ((topic = (String)configRow.getValue("topic")) != null) {
                    transform = transform.withTopic(topic);
                }
                if ((keySerializerBytes = configRow.getBytes("key_serializer")) != null) {
                    transform = transform.withKeySerializer((Class)TransformUpgrader.fromByteArray((byte[])keySerializerBytes));
                }
                if ((valueSerializerBytes = configRow.getBytes("value_serializer")) != null) {
                    transform = transform.withValueSerializer((Class)TransformUpgrader.fromByteArray((byte[])valueSerializerBytes));
                }
                if ((producerFactoryFnBytes = configRow.getBytes("producer_factory_fn")) != null) {
                    transform = transform.withProducerFactoryFn((SerializableFunction)TransformUpgrader.fromByteArray((byte[])producerFactoryFnBytes));
                }
                if ((isEOS = configRow.getBoolean("eos")) != null && isEOS.booleanValue()) {
                    Integer numShards = configRow.getInt32("num_shards");
                    String sinkGroupId = configRow.getString("sink_group_id");
                    if (numShards == null) {
                        throw new IllegalArgumentException("Expected numShards to be provided when EOS is set to true");
                    }
                    if (sinkGroupId == null) {
                        throw new IllegalArgumentException("Expected sinkGroupId to be provided when EOS is set to true");
                    }
                    transform = transform.withEOS(numShards.intValue(), sinkGroupId);
                }
                if ((consumerFactoryFnBytes = configRow.getBytes("consumer_factory_fn")) != null) {
                    transform = transform.withConsumerFactoryFn((SerializableFunction)TransformUpgrader.fromByteArray((byte[])consumerFactoryFnBytes));
                }
                if ((producerConfig = configRow.getMap("producer_config")) != null && !producerConfig.isEmpty()) {
                    HashMap updatedProducerConfig = new HashMap();
                    producerConfig.forEach((key, dataBytes) -> {
                        try {
                            updatedProducerConfig.put(key, TransformUpgrader.fromByteArray((byte[])dataBytes));
                        }
                        catch (InvalidClassException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    transform = transform.withProducerConfigUpdates(updatedProducerConfig);
                }
                return transform;
            }
            catch (InvalidClassException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class ReadRegistrar
    implements TransformPayloadTranslatorRegistrar {
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put((Object)KafkaIO.Read.AUTOVALUE_CLASS, (Object)new KafkaIOReadWithMetadataTranslator()).build();
        }
    }

    static class KafkaIOReadWithMetadataTranslator
    implements PTransformTranslation.TransformPayloadTranslator<KafkaIO.Read<?, ?>> {
        static @UnknownKeyFor @NonNull @Initialized Schema topicPartitionSchema = Schema.builder().addStringField("topic").addInt32Field("partition").build();
        static @UnknownKeyFor @NonNull @Initialized Schema schema = Schema.builder().addMapField("consumer_config", Schema.FieldType.STRING, Schema.FieldType.BYTES).addNullableArrayField("topics", Schema.FieldType.STRING).addNullableArrayField("topic_partitions", Schema.FieldType.row((Schema)topicPartitionSchema)).addNullableStringField("topic_pattern").addNullableByteArrayField("key_coder").addNullableByteArrayField("value_coder").addByteArrayField("consumer_factory_fn").addNullableByteArrayField("watermark_fn").addInt64Field("max_num_records").addNullableLogicalTypeField("max_read_time", (Schema.LogicalType)new NanosDuration()).addNullableLogicalTypeField("start_read_time", (Schema.LogicalType)new NanosInstant()).addNullableLogicalTypeField("stop_read_time", (Schema.LogicalType)new NanosInstant()).addBooleanField("is_commit_offset_finalize_enabled").addBooleanField("is_dynamic_read").addNullableLogicalTypeField("watch_topic_partition_duration", (Schema.LogicalType)new NanosDuration()).addByteArrayField("timestamp_policy_factory").addNullableMapField("offset_consumer_config", Schema.FieldType.STRING, Schema.FieldType.BYTES).addNullableByteArrayField("key_deserializer_provider").addNullableByteArrayField("value_deserializer_provider").addNullableByteArrayField("check_stop_reading_fn").build();

        KafkaIOReadWithMetadataTranslator() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return KafkaIOTranslation.KAFKA_READ_WITH_METADATA_TRANSFORM_URN_V2;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable @UnknownKeyFor @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized KafkaIO.Read<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> application, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn()).setPayload(ByteString.empty()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Row toConfigRow(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized KafkaIO.Read<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            HashMap consumerConfigMap = new HashMap();
            transform.getConsumerConfig().forEach((key, val) -> consumerConfigMap.put(key, TransformUpgrader.toByteArray((Object)val)));
            fieldValues.put("consumer_config", consumerConfigMap);
            if (transform.getTopics() != null) {
                fieldValues.put("topics", transform.getTopics());
            }
            if (transform.getTopicPartitions() != null && !transform.getTopicPartitions().isEmpty()) {
                ArrayList<Row> encodedTopicPartitions = new ArrayList<Row>();
                for (TopicPartition topicPartition : transform.getTopicPartitions()) {
                    encodedTopicPartitions.add(Row.withSchema((Schema)topicPartitionSchema).addValue((Object)topicPartition.topic()).addValue((Object)topicPartition.partition()).build());
                }
                fieldValues.put("topic_partitions", encodedTopicPartitions);
            }
            if (transform.getTopicPattern() != null) {
                fieldValues.put("topic_pattern", transform.getTopicPattern().pattern());
            }
            if (transform.getKeyCoder() != null) {
                fieldValues.put("key_coder", TransformUpgrader.toByteArray((Object)transform.getKeyCoder()));
            }
            if (transform.getValueCoder() != null) {
                fieldValues.put("value_coder", TransformUpgrader.toByteArray((Object)transform.getValueCoder()));
            }
            if (transform.getConsumerFactoryFn() != null) {
                fieldValues.put("consumer_factory_fn", TransformUpgrader.toByteArray((Object)transform.getConsumerFactoryFn()));
            }
            if (transform.getWatermarkFn() != null) {
                fieldValues.put("watermark_fn", TransformUpgrader.toByteArray((Object)transform.getWatermarkFn()));
            }
            fieldValues.put("max_num_records", transform.getMaxNumRecords());
            if (transform.getMaxReadTime() != null) {
                fieldValues.put("max_read_time", transform.getMaxReadTime());
            }
            if (transform.getStartReadTime() != null) {
                fieldValues.put("start_read_time", transform.getStartReadTime());
            }
            if (transform.getStopReadTime() != null) {
                fieldValues.put("stop_read_time", transform.getStopReadTime());
            }
            fieldValues.put("is_commit_offset_finalize_enabled", transform.isCommitOffsetsInFinalizeEnabled());
            fieldValues.put("is_dynamic_read", transform.isDynamicRead());
            if (transform.getWatchTopicPartitionDuration() != null) {
                fieldValues.put("watch_topic_partition_duration", transform.getWatchTopicPartitionDuration());
            }
            fieldValues.put("timestamp_policy_factory", TransformUpgrader.toByteArray((Object)transform.getTimestampPolicyFactory()));
            if (transform.getOffsetConsumerConfig() != null) {
                HashMap offsetConsumerConfigMap = new HashMap();
                transform.getOffsetConsumerConfig().forEach((key, val) -> offsetConsumerConfigMap.put(key, TransformUpgrader.toByteArray((Object)val)));
                fieldValues.put("offset_consumer_config", offsetConsumerConfigMap);
            }
            if (transform.getKeyDeserializerProvider() != null) {
                fieldValues.put("key_deserializer_provider", TransformUpgrader.toByteArray((Object)transform.getKeyDeserializerProvider()));
            }
            if (transform.getValueDeserializerProvider() != null) {
                fieldValues.put("value_deserializer_provider", TransformUpgrader.toByteArray((Object)transform.getValueDeserializerProvider()));
            }
            if (transform.getCheckStopReadingFn() != null) {
                fieldValues.put("check_stop_reading_fn", TransformUpgrader.toByteArray((Object)transform.getCheckStopReadingFn()));
            }
            if (transform.getBadRecordErrorHandler() != null) {
                throw new RuntimeException("Upgrading KafkaIO read transforms that have `withBadRecordErrorHandler` property setis not supported yet.");
            }
            return Row.withSchema((Schema)schema).withFieldValues(fieldValues).build();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized KafkaIO.Read<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromConfigRow(@UnknownKeyFor @NonNull @Initialized Row configRow, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            try {
                byte[] checkStopReadinfFn;
                Map offsetConsumerConfig;
                byte[] timestampPolicyFactory;
                Boolean isDynamicRead;
                Boolean isCommitOffsetFinalizeEnabled;
                Instant stopReadTime;
                Instant startReadTime;
                java.time.Duration maxReadTime;
                Long maxNumRecords;
                byte[] watermarkFn;
                byte[] consumerFactoryFn;
                byte[] valueDeserializerProvider;
                byte[] keyDeserializerProvider;
                String topicPattern;
                Collection topicPartitionRows;
                Collection topics;
                KafkaIO.Read transform = KafkaIO.read();
                Map consumerConfig = configRow.getMap("consumer_config");
                if (consumerConfig != null) {
                    HashMap updatedConsumerConfig = new HashMap();
                    consumerConfig.forEach((key, dataBytes) -> {
                        if (!KafkaIOUtils.DISALLOWED_CONSUMER_PROPERTIES.containsKey(key)) {
                            if (consumerConfig.get(key) == null) {
                                throw new IllegalArgumentException("Encoded value of the consumer config property " + key + " was null");
                            }
                            try {
                                updatedConsumerConfig.put(key, TransformUpgrader.fromByteArray((byte[])((byte[])consumerConfig.get(key))));
                            }
                            catch (InvalidClassException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    transform = transform.withConsumerConfigUpdates(updatedConsumerConfig);
                }
                if ((topics = configRow.getArray("topics")) != null) {
                    transform = transform.withTopics(new ArrayList(topics));
                }
                if ((topicPartitionRows = configRow.getArray("topic_partitions")) != null && !topicPartitionRows.isEmpty()) {
                    Collection topicPartitions = topicPartitionRows.stream().map(row -> {
                        String topic = row.getString("topic");
                        if (topic == null) {
                            throw new IllegalArgumentException("Expected the topic to be not null");
                        }
                        Integer partition = row.getInt32("partition");
                        if (partition == null) {
                            throw new IllegalArgumentException("Expected the partition to be not null");
                        }
                        return new TopicPartition(topic, partition.intValue());
                    }).collect(Collectors.toList());
                    transform = transform.withTopicPartitions((List)Lists.newArrayList((Iterable)topicPartitions));
                }
                if ((topicPattern = configRow.getString("topic_pattern")) != null) {
                    transform = transform.withTopicPattern(topicPattern);
                }
                if ((keyDeserializerProvider = configRow.getBytes("key_deserializer_provider")) != null) {
                    byte[] keyCoder = configRow.getBytes("key_coder");
                    transform = keyCoder != null ? transform.withKeyDeserializerProviderAndCoder((DeserializerProvider)TransformUpgrader.fromByteArray((byte[])keyDeserializerProvider), (Coder)TransformUpgrader.fromByteArray((byte[])keyCoder)) : transform.withKeyDeserializer((DeserializerProvider)TransformUpgrader.fromByteArray((byte[])keyDeserializerProvider));
                }
                if ((valueDeserializerProvider = configRow.getBytes("value_deserializer_provider")) != null) {
                    byte[] valueCoder = configRow.getBytes("value_coder");
                    transform = valueCoder != null ? transform.withValueDeserializerProviderAndCoder((DeserializerProvider)TransformUpgrader.fromByteArray((byte[])valueDeserializerProvider), (Coder)TransformUpgrader.fromByteArray((byte[])valueCoder)) : transform.withValueDeserializer((DeserializerProvider)TransformUpgrader.fromByteArray((byte[])valueDeserializerProvider));
                }
                if ((consumerFactoryFn = configRow.getBytes("consumer_factory_fn")) != null) {
                    transform = transform.withConsumerFactoryFn((SerializableFunction)TransformUpgrader.fromByteArray((byte[])consumerFactoryFn));
                }
                if ((watermarkFn = configRow.getBytes("watermark_fn")) != null) {
                    transform = transform.withWatermarkFn2((SerializableFunction)TransformUpgrader.fromByteArray((byte[])watermarkFn));
                }
                if ((maxNumRecords = configRow.getInt64("max_num_records")) != null) {
                    transform = transform.withMaxNumRecords(maxNumRecords.longValue());
                }
                if ((maxReadTime = (java.time.Duration)configRow.getValue("max_read_time")) != null) {
                    transform = transform.withMaxReadTime(Duration.millis((long)maxReadTime.toMillis()));
                }
                if ((startReadTime = (Instant)configRow.getValue("start_read_time")) != null) {
                    transform = transform.withStartReadTime(startReadTime);
                }
                if ((stopReadTime = (Instant)configRow.getValue("stop_read_time")) != null) {
                    transform = transform.withStopReadTime(stopReadTime);
                }
                if ((isCommitOffsetFinalizeEnabled = configRow.getBoolean("is_commit_offset_finalize_enabled")) != null && isCommitOffsetFinalizeEnabled.booleanValue()) {
                    transform = transform.commitOffsetsInFinalize();
                }
                if ((isDynamicRead = configRow.getBoolean("is_dynamic_read")) != null && isDynamicRead.booleanValue()) {
                    java.time.Duration watchTopicPartitionDuration = (java.time.Duration)configRow.getValue("watch_topic_partition_duration");
                    if (watchTopicPartitionDuration == null) {
                        throw new IllegalArgumentException("Expected watchTopicPartitionDuration to be available when isDynamicRead is set to true");
                    }
                    transform = transform.withDynamicRead(Duration.millis((long)watchTopicPartitionDuration.toMillis()));
                }
                if ((timestampPolicyFactory = configRow.getBytes("timestamp_policy_factory")) != null) {
                    transform = transform.withTimestampPolicyFactory((TimestampPolicyFactory)TransformUpgrader.fromByteArray((byte[])timestampPolicyFactory));
                }
                if ((offsetConsumerConfig = configRow.getMap("offset_consumer_config")) != null) {
                    HashMap updatedOffsetConsumerConfig = new HashMap();
                    offsetConsumerConfig.forEach((key, dataBytes) -> {
                        if (offsetConsumerConfig.get(key) == null) {
                            throw new IllegalArgumentException("Encoded value for the offset consumer config key " + key + " was null.");
                        }
                        try {
                            updatedOffsetConsumerConfig.put(key, TransformUpgrader.fromByteArray((byte[])((byte[])offsetConsumerConfig.get(key))));
                        }
                        catch (InvalidClassException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    transform = transform.withOffsetConsumerConfigOverrides(updatedOffsetConsumerConfig);
                }
                if ((checkStopReadinfFn = configRow.getBytes("check_stop_reading_fn")) != null) {
                    transform = transform.withCheckStopReadingFn((SerializableFunction)TransformUpgrader.fromByteArray((byte[])checkStopReadinfFn));
                }
                return transform;
            }
            catch (InvalidClassException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

