/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.beam.sdk.io.jdbc.LogicalTypes;
import org.apache.beam.sdk.io.jdbc.SchemaUtil;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.chrono.ISOChronology;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SchemaUtilTest {
    @Test
    public void testToBeamSchema() throws SQLException {
        ResultSetMetaData mockResultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        ImmutableList fieldInfo = ImmutableList.of((Object)JdbcFieldInfo.of("int_array_col", 2003, JDBCType.INTEGER.getName(), false), (Object)JdbcFieldInfo.of("bigint_col", -5), (Object)JdbcFieldInfo.of("binary_col", -2, 255), (Object)JdbcFieldInfo.of("bit_col", -7), (Object)JdbcFieldInfo.of("boolean_col", 16), (Object)JdbcFieldInfo.of("char_col", 1, 255), (Object)JdbcFieldInfo.of("date_col", 91), (Object)JdbcFieldInfo.of("decimal_col", 3), (Object)JdbcFieldInfo.of("double_col", 8), (Object)JdbcFieldInfo.of("float_col", 6), (Object)JdbcFieldInfo.of("integer_col", 4), (Object)JdbcFieldInfo.of("longnvarchar_col", -16, 1024), (Object[])new JdbcFieldInfo[]{JdbcFieldInfo.of("longvarchar_col", -1, 1024), JdbcFieldInfo.of("longvarbinary_col", -4, 1024), JdbcFieldInfo.of("nchar_col", -15, 255), JdbcFieldInfo.of("numeric_col", 2, 12, 4), JdbcFieldInfo.of("nvarchar_col", -9, 255), JdbcFieldInfo.of("real_col", 7), JdbcFieldInfo.of("smallint_col", 5), JdbcFieldInfo.of("time_col", 92), JdbcFieldInfo.of("timestamp_col", 93), JdbcFieldInfo.of("timestamptz_col", 2014), JdbcFieldInfo.of("tinyint_col", -6), JdbcFieldInfo.of("varbinary_col", -3, 255), JdbcFieldInfo.of("varchar_col", 12, 255)});
        Mockito.when((Object)mockResultSetMetaData.getColumnCount()).thenReturn((Object)fieldInfo.size());
        for (int i = 0; i < fieldInfo.size(); ++i) {
            JdbcFieldInfo f = (JdbcFieldInfo)fieldInfo.get(i);
            Mockito.when((Object)mockResultSetMetaData.getColumnLabel(Matchers.eq((int)(i + 1)))).thenReturn((Object)f.columnLabel);
            Mockito.when((Object)mockResultSetMetaData.getColumnType(Matchers.eq((int)(i + 1)))).thenReturn((Object)f.columnType);
            Mockito.when((Object)mockResultSetMetaData.getColumnTypeName(Matchers.eq((int)(i + 1)))).thenReturn((Object)f.columnTypeName);
            Mockito.when((Object)mockResultSetMetaData.getPrecision(Matchers.eq((int)(i + 1)))).thenReturn((Object)f.precision);
            Mockito.when((Object)mockResultSetMetaData.getScale(Matchers.eq((int)(i + 1)))).thenReturn((Object)f.scale);
            Mockito.when((Object)mockResultSetMetaData.isNullable(Matchers.eq((int)(i + 1)))).thenReturn((Object)(f.nullable ? 1 : 0));
        }
        Schema wantBeamSchema = Schema.builder().addArrayField("int_array_col", Schema.FieldType.INT32).addField("bigint_col", Schema.FieldType.INT64).addField("binary_col", LogicalTypes.fixedLengthBytes((JDBCType)JDBCType.BINARY, (int)255)).addField("bit_col", LogicalTypes.JDBC_BIT_TYPE).addField("boolean_col", Schema.FieldType.BOOLEAN).addField("char_col", LogicalTypes.fixedLengthString((JDBCType)JDBCType.CHAR, (int)255)).addField("date_col", LogicalTypes.JDBC_DATE_TYPE).addField("decimal_col", Schema.FieldType.DECIMAL).addField("double_col", Schema.FieldType.DOUBLE).addField("float_col", LogicalTypes.JDBC_FLOAT_TYPE).addField("integer_col", Schema.FieldType.INT32).addField("longnvarchar_col", LogicalTypes.variableLengthString((JDBCType)JDBCType.LONGNVARCHAR, (int)1024)).addField("longvarchar_col", LogicalTypes.variableLengthString((JDBCType)JDBCType.LONGVARCHAR, (int)1024)).addField("longvarbinary_col", LogicalTypes.variableLengthBytes((JDBCType)JDBCType.LONGVARBINARY, (int)1024)).addField("nchar_col", LogicalTypes.fixedLengthString((JDBCType)JDBCType.NCHAR, (int)255)).addField("numeric_col", LogicalTypes.numeric((int)12, (int)4)).addField("nvarchar_col", LogicalTypes.variableLengthString((JDBCType)JDBCType.NVARCHAR, (int)255)).addField("real_col", Schema.FieldType.FLOAT).addField("smallint_col", Schema.FieldType.INT16).addField("time_col", LogicalTypes.JDBC_TIME_TYPE).addField("timestamp_col", Schema.FieldType.DATETIME).addField("timestamptz_col", LogicalTypes.JDBC_TIMESTAMP_WITH_TIMEZONE_TYPE).addField("tinyint_col", Schema.FieldType.BYTE).addField("varbinary_col", LogicalTypes.variableLengthBytes((JDBCType)JDBCType.VARBINARY, (int)255)).addField("varchar_col", LogicalTypes.variableLengthString((JDBCType)JDBCType.VARCHAR, (int)255)).build();
        Schema haveBeamSchema = SchemaUtil.toBeamSchema((ResultSetMetaData)mockResultSetMetaData);
        Assert.assertEquals((Object)wantBeamSchema, (Object)haveBeamSchema);
    }

    @Test
    public void testBeamRowMapperArray() throws Exception {
        ResultSet mockArrayElementsResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)mockArrayElementsResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)mockArrayElementsResultSet.getInt(Matchers.eq((int)1))).thenReturn((Object)10, (Object[])new Integer[]{20, 30});
        Array mockArray = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)mockArray.getResultSet()).thenReturn((Object)mockArrayElementsResultSet);
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)mockResultSet.getArray(Matchers.eq((int)1))).thenReturn((Object)mockArray);
        Schema wantSchema = Schema.builder().addField("array", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT32)).build();
        Row wantRow = Row.withSchema((Schema)wantSchema).addValues(new Object[]{ImmutableList.of((Object)10, (Object)20, (Object)30)}).build();
        SchemaUtil.BeamRowMapper beamRowMapper = SchemaUtil.BeamRowMapper.of((Schema)wantSchema);
        Row haveRow = beamRowMapper.mapRow(mockResultSet);
        Assert.assertEquals((Object)wantRow, (Object)haveRow);
    }

    @Test
    public void testBeamRowMapperPrimitiveTypes() throws Exception {
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)mockResultSet.getLong(Matchers.eq((int)1))).thenReturn((Object)42L);
        Mockito.when((Object)mockResultSet.getBytes(Matchers.eq((int)2))).thenReturn((Object)"binary".getBytes(Charset.forName("UTF-8")));
        Mockito.when((Object)mockResultSet.getBoolean(Matchers.eq((int)3))).thenReturn((Object)true);
        Mockito.when((Object)mockResultSet.getBoolean(Matchers.eq((int)4))).thenReturn((Object)false);
        Mockito.when((Object)mockResultSet.getString(Matchers.eq((int)5))).thenReturn((Object)"char");
        Mockito.when((Object)mockResultSet.getBigDecimal(Matchers.eq((int)6))).thenReturn((Object)BigDecimal.valueOf(25L));
        Mockito.when((Object)mockResultSet.getDouble(Matchers.eq((int)7))).thenReturn((Object)20.5);
        Mockito.when((Object)Float.valueOf(mockResultSet.getFloat(Matchers.eq((int)8)))).thenReturn((Object)Float.valueOf(15.5f));
        Mockito.when((Object)mockResultSet.getInt(Matchers.eq((int)9))).thenReturn((Object)10);
        Mockito.when((Object)mockResultSet.getString(Matchers.eq((int)10))).thenReturn((Object)"longvarchar");
        Mockito.when((Object)mockResultSet.getBytes(Matchers.eq((int)11))).thenReturn((Object)"longvarbinary".getBytes(Charset.forName("UTF-8")));
        Mockito.when((Object)mockResultSet.getBigDecimal(Matchers.eq((int)12))).thenReturn((Object)BigDecimal.valueOf(1000L));
        Mockito.when((Object)Float.valueOf(mockResultSet.getFloat(Matchers.eq((int)13)))).thenReturn((Object)Float.valueOf(32.0f));
        Mockito.when((Object)mockResultSet.getShort(Matchers.eq((int)14))).thenReturn((Object)8);
        Mockito.when((Object)mockResultSet.getShort(Matchers.eq((int)15))).thenReturn((Object)4);
        Mockito.when((Object)mockResultSet.getBytes(Matchers.eq((int)16))).thenReturn((Object)"varbinary".getBytes(Charset.forName("UTF-8")));
        Mockito.when((Object)mockResultSet.getString(Matchers.eq((int)17))).thenReturn((Object)"varchar");
        Schema wantSchema = Schema.builder().addField("bigint_col", Schema.FieldType.INT64).addField("binary_col", Schema.FieldType.BYTES).addField("bit_col", Schema.FieldType.BOOLEAN).addField("boolean_col", Schema.FieldType.BOOLEAN).addField("char_col", Schema.FieldType.STRING).addField("decimal_col", Schema.FieldType.DECIMAL).addField("double_col", Schema.FieldType.DOUBLE).addField("float_col", Schema.FieldType.FLOAT).addField("integer_col", Schema.FieldType.INT32).addField("longvarchar_col", Schema.FieldType.STRING).addField("longvarbinary_col", Schema.FieldType.BYTES).addField("numeric_col", Schema.FieldType.DECIMAL).addField("real_col", Schema.FieldType.FLOAT).addField("smallint_col", Schema.FieldType.INT16).addField("tinyint_col", Schema.FieldType.INT16).addField("varbinary_col", Schema.FieldType.BYTES).addField("varchar_col", Schema.FieldType.STRING).build();
        Row wantRow = Row.withSchema((Schema)wantSchema).addValues(new Object[]{42L, "binary".getBytes(Charset.forName("UTF-8")), true, false, "char", BigDecimal.valueOf(25L), 20.5, Float.valueOf(15.5f), 10, "longvarchar", "longvarbinary".getBytes(Charset.forName("UTF-8")), BigDecimal.valueOf(1000L), Float.valueOf(32.0f), (short)8, (short)4, "varbinary".getBytes(Charset.forName("UTF-8")), "varchar"}).build();
        SchemaUtil.BeamRowMapper beamRowMapper = SchemaUtil.BeamRowMapper.of((Schema)wantSchema);
        Row haveRow = beamRowMapper.mapRow(mockResultSet);
        Assert.assertEquals((Object)wantRow, (Object)haveRow);
    }

    @Test
    public void testBeamRowMapperDateTime() throws Exception {
        long epochMilli = 1558719710000L;
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)mockResultSet.getDate(Matchers.eq((int)1), (Calendar)Matchers.any())).thenReturn((Object)new Date(epochMilli));
        Mockito.when((Object)mockResultSet.getTime(Matchers.eq((int)2), (Calendar)Matchers.any())).thenReturn((Object)new Time(epochMilli));
        Mockito.when((Object)mockResultSet.getTimestamp(Matchers.eq((int)3), (Calendar)Matchers.any())).thenReturn((Object)new Timestamp(epochMilli));
        Mockito.when((Object)mockResultSet.getTimestamp(Matchers.eq((int)4), (Calendar)Matchers.any())).thenReturn((Object)new Timestamp(epochMilli));
        Schema wantSchema = Schema.builder().addField("date_col", LogicalTypes.JDBC_DATE_TYPE).addField("time_col", LogicalTypes.JDBC_TIME_TYPE).addField("timestamptz_col", LogicalTypes.JDBC_TIMESTAMP_WITH_TIMEZONE_TYPE).addField("timestamp_col", Schema.FieldType.DATETIME).build();
        DateTime wantDateTime = new DateTime(epochMilli, (Chronology)ISOChronology.getInstanceUTC());
        Row wantRow = Row.withSchema((Schema)wantSchema).addValues(new Object[]{wantDateTime.withTimeAtStartOfDay(), wantDateTime.withDate(new LocalDate(0L)), wantDateTime, wantDateTime}).build();
        SchemaUtil.BeamRowMapper beamRowMapper = SchemaUtil.BeamRowMapper.of((Schema)wantSchema);
        Row haveRow = beamRowMapper.mapRow(mockResultSet);
        Assert.assertEquals((Object)wantRow, (Object)haveRow);
    }

    @Test
    public void testSchemaFieldComparator() {
        Assert.assertTrue((boolean)SchemaUtil.compareSchemaField((Schema.Field)Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING), (Schema.Field)Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING)));
        Assert.assertFalse((boolean)SchemaUtil.compareSchemaField((Schema.Field)Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING), (Schema.Field)Schema.Field.of((String)"anotherName", (Schema.FieldType)Schema.FieldType.STRING)));
        Assert.assertFalse((boolean)SchemaUtil.compareSchemaField((Schema.Field)Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING), (Schema.Field)Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.INT64)));
    }

    @Test
    public void testSchemaFieldTypeComparator() {
        Assert.assertTrue((boolean)SchemaUtil.compareSchemaFieldType((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.STRING));
        Assert.assertFalse((boolean)SchemaUtil.compareSchemaFieldType((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.INT16));
        Assert.assertTrue((boolean)SchemaUtil.compareSchemaFieldType((Schema.FieldType)LogicalTypes.variableLengthString((JDBCType)JDBCType.VARCHAR, (int)255), (Schema.FieldType)LogicalTypes.variableLengthString((JDBCType)JDBCType.VARCHAR, (int)255)));
        Assert.assertFalse((boolean)SchemaUtil.compareSchemaFieldType((Schema.FieldType)LogicalTypes.variableLengthString((JDBCType)JDBCType.VARCHAR, (int)255), (Schema.FieldType)LogicalTypes.fixedLengthBytes((JDBCType)JDBCType.BIT, (int)255)));
        Assert.assertTrue((boolean)SchemaUtil.compareSchemaFieldType((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)LogicalTypes.variableLengthString((JDBCType)JDBCType.VARCHAR, (int)255)));
        Assert.assertFalse((boolean)SchemaUtil.compareSchemaFieldType((Schema.FieldType)Schema.FieldType.INT16, (Schema.FieldType)LogicalTypes.variableLengthString((JDBCType)JDBCType.VARCHAR, (int)255)));
        Assert.assertTrue((boolean)SchemaUtil.compareSchemaFieldType((Schema.FieldType)LogicalTypes.variableLengthString((JDBCType)JDBCType.VARCHAR, (int)255), (Schema.FieldType)Schema.FieldType.STRING));
    }

    private static final class JdbcFieldInfo {
        private final String columnLabel;
        private final int columnType;
        private final String columnTypeName;
        private final boolean nullable;
        private final int precision;
        private final int scale;

        private JdbcFieldInfo(String columnLabel, int columnType, String columnTypeName, boolean nullable, int precision, int scale) {
            this.columnLabel = columnLabel;
            this.columnType = columnType;
            this.columnTypeName = columnTypeName;
            this.nullable = nullable;
            this.precision = precision;
            this.scale = scale;
        }

        private static JdbcFieldInfo of(String columnLabel, int columnType, String columnTypeName, boolean nullable) {
            return new JdbcFieldInfo(columnLabel, columnType, columnTypeName, nullable, 0, 0);
        }

        private static JdbcFieldInfo of(String columnLabel, int columnType, boolean nullable) {
            return new JdbcFieldInfo(columnLabel, columnType, null, nullable, 0, 0);
        }

        private static JdbcFieldInfo of(String columnLabel, int columnType) {
            return new JdbcFieldInfo(columnLabel, columnType, null, false, 0, 0);
        }

        private static JdbcFieldInfo of(String columnLabel, int columnType, int precision) {
            return new JdbcFieldInfo(columnLabel, columnType, null, false, precision, 0);
        }

        private static JdbcFieldInfo of(String columnLabel, int columnType, int precision, int scale) {
            return new JdbcFieldInfo(columnLabel, columnType, null, false, precision, scale);
        }
    }
}

