/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import com.google.cloud.Timestamp;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.sql.DataSource;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.common.DatabaseTestHelper;
import org.apache.beam.sdk.io.common.HashingFn;
import org.apache.beam.sdk.io.common.IOITHelper;
import org.apache.beam.sdk.io.common.PostgresIOTestPipelineOptions;
import org.apache.beam.sdk.io.common.TestRow;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.JdbcTestHelper;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testutils.NamedTestResult;
import org.apache.beam.sdk.testutils.metrics.IOITMetrics;
import org.apache.beam.sdk.testutils.metrics.MetricsReader;
import org.apache.beam.sdk.testutils.metrics.TimeMonitor;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.values.PCollection;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.postgresql.ds.PGSimpleDataSource;

@RunWith(value=JUnit4.class)
public class JdbcIOIT {
    private static final String NAMESPACE = JdbcIOIT.class.getName();
    private static int numberOfRows;
    private static PGSimpleDataSource dataSource;
    private static String tableName;
    private static String bigQueryDataset;
    private static String bigQueryTable;
    @Rule
    public TestPipeline pipelineWrite = TestPipeline.create();
    @Rule
    public TestPipeline pipelineRead = TestPipeline.create();

    @BeforeClass
    public static void setup() throws Exception {
        PostgresIOTestPipelineOptions options = (PostgresIOTestPipelineOptions)IOITHelper.readIOTestPipelineOptions(PostgresIOTestPipelineOptions.class);
        bigQueryDataset = options.getBigQueryDataset();
        bigQueryTable = options.getBigQueryTable();
        numberOfRows = options.getNumberOfRecords();
        dataSource = DatabaseTestHelper.getPostgresDataSource((PostgresIOTestPipelineOptions)options);
        tableName = DatabaseTestHelper.getTestTableName((String)"IT");
        IOITHelper.executeWithRetry(JdbcIOIT::createTable);
    }

    private static void createTable() throws SQLException {
        DatabaseTestHelper.createTable((DataSource)dataSource, (String)tableName);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IOITHelper.executeWithRetry(JdbcIOIT::deleteTable);
    }

    private static void deleteTable() throws SQLException {
        DatabaseTestHelper.deleteTable((DataSource)dataSource, (String)tableName);
    }

    @Test
    public void testWriteThenRead() {
        PipelineResult writeResult = this.runWrite();
        writeResult.waitUntilFinish();
        PipelineResult readResult = this.runRead();
        readResult.waitUntilFinish();
        this.gatherAndPublishMetrics(writeResult, readResult);
    }

    private void gatherAndPublishMetrics(PipelineResult writeResult, PipelineResult readResult) {
        String uuid = UUID.randomUUID().toString();
        String timestamp = Timestamp.now().toString();
        Set<Function<MetricsReader, NamedTestResult>> metricSuppliers = this.getWriteMetricSuppliers(uuid, timestamp);
        IOITMetrics writeMetrics = new IOITMetrics(metricSuppliers, writeResult, NAMESPACE, uuid, timestamp);
        writeMetrics.publish(bigQueryDataset, bigQueryTable);
        IOITMetrics readMetrics = new IOITMetrics(this.getReadMetricSuppliers(uuid, timestamp), readResult, NAMESPACE, uuid, timestamp);
        readMetrics.publish(bigQueryDataset, bigQueryTable);
    }

    private Set<Function<MetricsReader, NamedTestResult>> getWriteMetricSuppliers(String uuid, String timestamp) {
        HashSet<Function<MetricsReader, NamedTestResult>> suppliers = new HashSet<Function<MetricsReader, NamedTestResult>>();
        suppliers.add(reader -> {
            long writeStart = reader.getStartTimeMetric("write_time");
            long writeEnd = reader.getEndTimeMetric("write_time");
            return NamedTestResult.create((String)uuid, (String)timestamp, (String)"write_time", (double)((double)(writeEnd - writeStart) / 1000.0));
        });
        return suppliers;
    }

    private Set<Function<MetricsReader, NamedTestResult>> getReadMetricSuppliers(String uuid, String timestamp) {
        HashSet<Function<MetricsReader, NamedTestResult>> suppliers = new HashSet<Function<MetricsReader, NamedTestResult>>();
        suppliers.add(reader -> {
            long readStart = reader.getStartTimeMetric("read_time");
            long readEnd = reader.getEndTimeMetric("read_time");
            return NamedTestResult.create((String)uuid, (String)timestamp, (String)"read_time", (double)((double)(readEnd - readStart) / 1000.0));
        });
        return suppliers;
    }

    private PipelineResult runWrite() {
        ((PCollection)((PCollection)((PCollection)this.pipelineWrite.apply((PTransform)GenerateSequence.from((long)0L).to((long)numberOfRows))).apply((PTransform)ParDo.of((DoFn)new TestRow.DeterministicallyConstructTestRowFn()))).apply((PTransform)ParDo.of((DoFn)new TimeMonitor(NAMESPACE, "write_time")))).apply((PTransform)JdbcIO.write().withDataSourceConfiguration(JdbcIO.DataSourceConfiguration.create((DataSource)dataSource)).withStatement(String.format("insert into %s values(?, ?)", tableName)).withPreparedStatementSetter((JdbcIO.PreparedStatementSetter)new JdbcTestHelper.PrepareStatementFromTestRow()));
        return this.pipelineWrite.run();
    }

    private PipelineResult runRead() {
        PCollection namesAndIds = (PCollection)((PCollection)this.pipelineRead.apply((PTransform)JdbcIO.read().withDataSourceConfiguration(JdbcIO.DataSourceConfiguration.create((DataSource)dataSource)).withQuery(String.format("select name,id from %s;", tableName)).withRowMapper((JdbcIO.RowMapper)new JdbcTestHelper.CreateTestRowOfNameAndId()).withCoder((Coder)SerializableCoder.of(TestRow.class)))).apply((PTransform)ParDo.of((DoFn)new TimeMonitor(NAMESPACE, "read_time")));
        PAssert.thatSingleton((PCollection)((PCollection)namesAndIds.apply("Count All", Count.globally()))).isEqualTo((Object)numberOfRows);
        PCollection consolidatedHashcode = (PCollection)((PCollection)namesAndIds.apply((PTransform)ParDo.of((DoFn)new TestRow.SelectNameFn()))).apply("Hash row contents", (PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new HashingFn()).withoutDefaults());
        PAssert.that((PCollection)consolidatedHashcode).containsInAnyOrder((Object[])new String[]{TestRow.getExpectedHashForRowCount((int)numberOfRows)});
        PCollection frontOfList = (PCollection)namesAndIds.apply((PTransform)Top.smallest((int)500));
        Iterable expectedFrontOfList = TestRow.getExpectedValues((int)0, (int)500);
        PAssert.thatSingletonIterable((PCollection)frontOfList).containsInAnyOrder(expectedFrontOfList);
        PCollection backOfList = (PCollection)namesAndIds.apply((PTransform)Top.largest((int)500));
        Iterable expectedBackOfList = TestRow.getExpectedValues((int)(numberOfRows - 500), (int)numberOfRows);
        PAssert.thatSingletonIterable((PCollection)backOfList).containsInAnyOrder(expectedBackOfList);
        return this.pipelineRead.run();
    }
}

