/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.io.IOException;
import org.apache.beam.sdk.io.hbase.HBaseSharedConnection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HBaseSharedConnectionTest {
    static Configuration configuration;
    static Configuration configuration2;

    @BeforeClass
    public static void setup() {
        configuration = HBaseConfiguration.create();
        configuration2 = HBaseConfiguration.create();
        configuration2.set("hbase.zookeeper.quorum", "random-server");
    }

    @After
    public void resetConnectionPool() throws IOException {
        HBaseSharedConnection.closeAll();
        Assert.assertEquals((long)0L, (long)HBaseSharedConnection.getConnectionPoolSize());
    }

    @Test
    public void testOpenThenCloseConnection() throws IOException {
        Assert.assertEquals((long)0L, (long)HBaseSharedConnection.getConnectionCount((Configuration)configuration));
        HBaseSharedConnection.getOrCreate((Configuration)configuration);
        Assert.assertEquals((long)1L, (long)HBaseSharedConnection.getConnectionCount((Configuration)configuration));
        HBaseSharedConnection.getOrCreate((Configuration)configuration);
        Assert.assertEquals((long)2L, (long)HBaseSharedConnection.getConnectionCount((Configuration)configuration));
        HBaseSharedConnection.close((Configuration)configuration);
        Assert.assertEquals((long)1L, (long)HBaseSharedConnection.getConnectionCount((Configuration)configuration));
        HBaseSharedConnection.close((Configuration)configuration);
        Assert.assertEquals((long)0L, (long)HBaseSharedConnection.getConnectionCount((Configuration)configuration));
    }

    @Test
    public void testCloseNonExistentConnection() throws IOException {
        HBaseSharedConnection.close((Configuration)configuration);
        Assert.assertEquals((long)0L, (long)HBaseSharedConnection.getConnectionPoolSize());
    }

    @Test
    public void testCloseThenOpenConnection() throws IOException {
        HBaseSharedConnection.close((Configuration)configuration);
        HBaseSharedConnection.getOrCreate((Configuration)configuration);
        Assert.assertEquals((long)1L, (long)HBaseSharedConnection.getConnectionPoolSize());
        Assert.assertEquals((long)1L, (long)HBaseSharedConnection.getConnectionCount((Configuration)configuration));
    }

    @Test
    public void testCloseConnectionMultipleTimes() throws IOException {
        HBaseSharedConnection.getOrCreate((Configuration)configuration);
        HBaseSharedConnection.close((Configuration)configuration);
        HBaseSharedConnection.close((Configuration)configuration);
        Assert.assertEquals((long)0L, (long)HBaseSharedConnection.getConnectionPoolSize());
    }

    @Test
    public void testOpenMultipleConnections() throws IOException {
        HBaseSharedConnection.getOrCreate((Configuration)configuration);
        HBaseSharedConnection.getOrCreate((Configuration)configuration2);
        HBaseSharedConnection.getOrCreate((Configuration)configuration2);
        Assert.assertEquals((long)2L, (long)HBaseSharedConnection.getConnectionPoolSize());
        Assert.assertEquals((long)1L, (long)HBaseSharedConnection.getConnectionCount((Configuration)configuration));
        Assert.assertEquals((long)2L, (long)HBaseSharedConnection.getConnectionCount((Configuration)configuration2));
    }
}

