/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.io.hbase.HBaseMutationCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class HBaseRowMutationsCoder
extends StructuredCoder<RowMutations>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized HBaseRowMutationsCoder INSTANCE = new HBaseRowMutationsCoder();
    private final @UnknownKeyFor @NonNull @Initialized ByteArrayCoder byteArrayCoder = ByteArrayCoder.of();
    private final @UnknownKeyFor @NonNull @Initialized ListCoder<@UnknownKeyFor @NonNull @Initialized Mutation> listCoder = ListCoder.of((Coder)HBaseMutationCoder.of());
    private static final @UnknownKeyFor @NonNull @Initialized CoderProvider HBASE_ROW_MUTATIONS_CODER_PROVIDER = new HBaseRowMutationsCoderProvider();
    private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized RowMutations> HBASE_ROW_MUTATIONS_TYPE_DESCRIPTOR = new TypeDescriptor<RowMutations>(){};

    public static @UnknownKeyFor @NonNull @Initialized HBaseRowMutationsCoder of() {
        return INSTANCE;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized RowMutations value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.byteArrayCoder.encode(value.getRow(), outStream);
        this.listCoder.encode((Iterable)value.getMutations(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized RowMutations decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
        byte[] rowKey = this.byteArrayCoder.decode(inStream);
        List mutations = (List)this.listCoder.decode(inStream);
        RowMutations rowMutations = new RowMutations(rowKey);
        for (Mutation m : mutations) {
            ClientProtos.MutationProto.MutationType type = HBaseRowMutationsCoder.getType(m);
            if (type == ClientProtos.MutationProto.MutationType.PUT) {
                rowMutations.add((Put)m);
                continue;
            }
            if (type == ClientProtos.MutationProto.MutationType.DELETE) {
                rowMutations.add((Delete)m);
                continue;
            }
            throw new IllegalArgumentException("Mutation type not supported.");
        }
        return rowMutations;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return Arrays.asList(this.listCoder, this.byteArrayCoder);
    }

    public void verifyDeterministic() {
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ClientProtos.MutationProto.MutationType getType(@UnknownKeyFor @NonNull @Initialized Mutation mutation) {
        if (mutation instanceof Put) {
            return ClientProtos.MutationProto.MutationType.PUT;
        }
        if (mutation instanceof Delete) {
            return ClientProtos.MutationProto.MutationType.DELETE;
        }
        throw new IllegalArgumentException("Only Put and Delete are supported");
    }

    static @UnknownKeyFor @NonNull @Initialized CoderProvider getCoderProvider() {
        return HBASE_ROW_MUTATIONS_CODER_PROVIDER;
    }

    private static class HBaseRowMutationsCoderProvider
    extends CoderProvider {
        private HBaseRowMutationsCoderProvider() {
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> componentCoders) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            if (!typeDescriptor.isSubtypeOf(HBASE_ROW_MUTATIONS_TYPE_DESCRIPTOR)) {
                throw new CannotProvideCoderException(String.format("Cannot provide %s because %s is not a subclass of %s", HBaseRowMutationsCoder.class.getSimpleName(), typeDescriptor, Mutation.class.getName()));
            }
            try {
                HBaseRowMutationsCoder coder = HBaseRowMutationsCoder.of();
                return coder;
            }
            catch (IllegalArgumentException e) {
                throw new CannotProvideCoderException((Throwable)e);
            }
        }
    }
}

