/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.io.IOException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.hbase.HBaseIO;
import org.apache.beam.sdk.io.hbase.HBaseRowMutationsCoder;
import org.apache.beam.sdk.io.hbase.utils.TestConstants;
import org.apache.beam.sdk.io.hbase.utils.TestHBaseUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class HbaseIOWriteRowMutationsTest {
    private static final Logger LOG = LoggerFactory.getLogger(HbaseIOWriteRowMutationsTest.class);
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    private static HBaseTestingUtility htu;
    private static final Configuration conf;

    @BeforeClass
    public static void setUpCluster() throws Exception {
        conf.setInt("hbase.client.retries.number", 1);
        conf.setStrings("hbase.master.hostname", new String[]{"localhost"});
        conf.setStrings("hbase.regionserver.hostname", new String[]{"localhost"});
        htu = new HBaseTestingUtility();
        htu.startMiniZKCluster();
        MiniHBaseCluster hbm = htu.startMiniHBaseCluster(1, 4);
        hbm.waitForActiveAndReadyMaster();
        LOG.info("Hbase test cluster started.");
    }

    @AfterClass
    public static void tearDownCluster() throws Exception {
        if (htu != null) {
            htu.shutdownMiniHBaseCluster();
            htu.shutdownMiniZKCluster();
            htu.cleanupTestDir();
            htu = null;
        }
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.pipeline.getCoderRegistry().registerCoderForClass(RowMutations.class, (Coder)HBaseRowMutationsCoder.of());
    }

    @Test
    public void testWritesPuts() throws Exception {
        Table table = TestHBaseUtils.createTable(htu);
        RowMutations rowMutationsOnTwoColumnFamilies = new RowMutations(TestConstants.rowKey);
        rowMutationsOnTwoColumnFamilies.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.value, TestConstants.timeT));
        rowMutationsOnTwoColumnFamilies.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey, TestConstants.colFamily2, TestConstants.colQualifier2, TestConstants.value2, TestConstants.timeT));
        RowMutations overwritingRowMutations = new RowMutations(TestConstants.rowKey2);
        overwritingRowMutations.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey2, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.value, TestConstants.timeT));
        overwritingRowMutations.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey2, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.value2, TestConstants.timeT));
        ((PCollection)this.pipeline.apply("Create row mutations", (PTransform)Create.of((Object)KV.of((Object)TestConstants.rowKey, (Object)rowMutationsOnTwoColumnFamilies), (Object[])new KV[]{KV.of((Object)TestConstants.rowKey2, (Object)overwritingRowMutations)}))).apply("Write to hbase", (PTransform)HBaseIO.writeRowMutations().withConfiguration(htu.getConfiguration()).withTableId(table.getName().getNameAsString()));
        this.pipeline.run().waitUntilFinish();
        Assert.assertEquals((long)2L, (long)TestHBaseUtils.getRowResult(table, TestConstants.rowKey).size());
        Assert.assertArrayEquals((byte[])TestConstants.value, (byte[])TestHBaseUtils.getCell(table, TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier));
        Assert.assertArrayEquals((byte[])TestConstants.value2, (byte[])TestHBaseUtils.getCell(table, TestConstants.rowKey, TestConstants.colFamily2, TestConstants.colQualifier2));
        Assert.assertEquals((long)1L, (long)TestHBaseUtils.getRowResult(table, TestConstants.rowKey2).size());
        Assert.assertArrayEquals((byte[])TestConstants.value2, (byte[])TestHBaseUtils.getCell(table, TestConstants.rowKey2, TestConstants.colFamily, TestConstants.colQualifier));
    }

    @Test
    public void testWritesDeletes() throws Exception {
        Table table = TestHBaseUtils.createTable(htu);
        RowMutations deleteCellMutation = new RowMutations(TestConstants.rowKey);
        deleteCellMutation.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.value, TestConstants.timeT));
        deleteCellMutation.add(TestHBaseUtils.HBaseMutationBuilder.createDelete(TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.timeT));
        RowMutations deleteColFamilyMutation = new RowMutations(TestConstants.rowKey2);
        deleteColFamilyMutation.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey2, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.value, TestConstants.timeT));
        deleteColFamilyMutation.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey2, TestConstants.colFamily, TestConstants.colQualifier2, TestConstants.value2, TestConstants.timeT));
        deleteColFamilyMutation.add(TestHBaseUtils.HBaseMutationBuilder.createDeleteFamily(TestConstants.rowKey2, TestConstants.colFamily, Long.MAX_VALUE));
        ((PCollection)this.pipeline.apply("Create row mutations", (PTransform)Create.of((Object)KV.of((Object)TestConstants.rowKey, (Object)deleteCellMutation), (Object[])new KV[]{KV.of((Object)TestConstants.rowKey2, (Object)deleteColFamilyMutation)}))).apply("Write to hbase", (PTransform)HBaseIO.writeRowMutations().withConfiguration(htu.getConfiguration()).withTableId(table.getName().getNameAsString()));
        this.pipeline.run().waitUntilFinish();
        Assert.assertTrue((boolean)TestHBaseUtils.getRowResult(table, TestConstants.rowKey).isEmpty());
        Assert.assertTrue((boolean)TestHBaseUtils.getRowResult(table, TestConstants.rowKey2).isEmpty());
    }

    @Test
    public void testWritesDeletesThenPutsInOrderByTimestamp() throws Exception {
        Table table = TestHBaseUtils.createTable(htu);
        RowMutations putDeletePut = new RowMutations(TestConstants.rowKey);
        putDeletePut.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.value, TestConstants.timeT));
        putDeletePut.add(TestHBaseUtils.HBaseMutationBuilder.createDeleteFamily(TestConstants.rowKey, TestConstants.colFamily, TestConstants.timeT + 1L));
        putDeletePut.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.value2, TestConstants.timeT + 2L));
        ((PCollection)this.pipeline.apply("Create row mutations", (PTransform)Create.of((Object)KV.of((Object)TestConstants.rowKey, (Object)putDeletePut), (Object[])new KV[0]))).apply("Write to hbase", (PTransform)HBaseIO.writeRowMutations().withConfiguration(htu.getConfiguration()).withTableId(table.getName().getNameAsString()));
        this.pipeline.run().waitUntilFinish();
        Assert.assertArrayEquals((byte[])TestConstants.value2, (byte[])TestHBaseUtils.getCell(table, TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier));
    }

    static {
        conf = HBaseConfiguration.create();
    }
}

