/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.common.HashingFn;
import org.apache.beam.sdk.io.common.IOTestPipelineOptions;
import org.apache.beam.sdk.io.common.TestRow;
import org.apache.beam.sdk.io.hbase.HBaseIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HBaseIOIT {
    private static int numberOfRows;
    private static final Configuration conf;
    private static final String TABLE_NAME = "IOTesting";
    private static final byte[] COLUMN_FAMILY;
    private static final byte[] COLUMN_HASH;
    private static Admin admin;
    private static HBasePipelineOptions options;
    @Rule
    public TestPipeline pipelineWrite = TestPipeline.create();
    @Rule
    public TestPipeline pipelineRead = TestPipeline.create();

    @BeforeClass
    public static void setup() throws IOException {
        PipelineOptionsFactory.register(HBasePipelineOptions.class);
        options = (HBasePipelineOptions)TestPipeline.testingPipelineOptions().as(HBasePipelineOptions.class);
        numberOfRows = options.getNumberOfRecords();
        conf.setStrings("hbase.zookeeper.quorum", new String[]{options.getHbaseServerName()});
        conf.setStrings("hbase.cluster.distributed", new String[]{"true"});
        conf.setStrings("hbase.client.retries.number", new String[]{"1"});
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        admin = connection.getAdmin();
        HTableDescriptor testTable = new HTableDescriptor(TableName.valueOf((String)TABLE_NAME)).addFamily(new HColumnDescriptor(COLUMN_FAMILY));
        admin.createTable((TableDescriptor)testTable);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        admin.disableTable(TableName.valueOf((String)TABLE_NAME));
        admin.deleteTable(TableName.valueOf((String)TABLE_NAME));
    }

    @Test
    public void testWriteThenRead() {
        this.runWrite();
        this.runRead();
    }

    private void runWrite() {
        ((PCollection)((PCollection)((PCollection)this.pipelineWrite.apply("Generate Sequence", (PTransform)GenerateSequence.from((long)0L).to((long)numberOfRows))).apply("Prepare TestRows", (PTransform)ParDo.of((DoFn)new TestRow.DeterministicallyConstructTestRowFn()))).apply("Prepare mutations", (PTransform)ParDo.of((DoFn)new ConstructMutations()))).apply("Write to HBase", (PTransform)HBaseIO.write().withConfiguration(conf).withTableId(TABLE_NAME));
        this.pipelineWrite.run().waitUntilFinish();
    }

    private void runRead() {
        PCollection tableRows = (PCollection)this.pipelineRead.apply((PTransform)HBaseIO.read().withConfiguration(conf).withTableId(TABLE_NAME));
        PAssert.thatSingleton((PCollection)((PCollection)tableRows.apply("Count All", Count.globally()))).isEqualTo((Object)numberOfRows);
        PCollection consolidatedHashcode = (PCollection)((PCollection)tableRows.apply((PTransform)ParDo.of((DoFn)new SelectNameFn()))).apply("Hash row contents", (PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new HashingFn()).withoutDefaults());
        PAssert.that((PCollection)consolidatedHashcode).containsInAnyOrder((Object[])new String[]{TestRow.getExpectedHashForRowCount((int)numberOfRows)});
        this.pipelineRead.run().waitUntilFinish();
    }

    static {
        conf = HBaseConfiguration.create();
        COLUMN_FAMILY = Bytes.toBytes((String)"TestData");
        COLUMN_HASH = Bytes.toBytes((String)"hash");
    }

    private static class SelectNameFn
    extends DoFn<Result, String> {
        private SelectNameFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)new String(((Result)c.element()).getValue(COLUMN_FAMILY, COLUMN_HASH), StandardCharsets.UTF_8));
        }
    }

    private static class ConstructMutations
    extends DoFn<TestRow, Mutation> {
        private ConstructMutations() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)new Put(((TestRow)c.element()).id().toString().getBytes(StandardCharsets.UTF_8)).addColumn(COLUMN_FAMILY, COLUMN_HASH, Bytes.toBytes((String)((TestRow)c.element()).name())));
        }
    }

    public static interface HBasePipelineOptions
    extends IOTestPipelineOptions {
        @Description(value="HBase host")
        @Default.String(value="HBase-host")
        public String getHbaseServerName();

        public void setHbaseServerName(String var1);
    }
}

