/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class HashUtils {
    public static void assertRowMutationsEquals(RowMutations rowMutationA, RowMutations rowMutationB) throws Exception {
        if (rowMutationA == null || rowMutationB == null) {
            Assert.assertEquals((Object)rowMutationA, (Object)rowMutationB);
        }
        Assert.assertTrue((boolean)Bytes.equals((byte[])rowMutationA.getRow(), (byte[])rowMutationB.getRow()));
        Assert.assertEquals(HashUtils.hashMutationList(rowMutationA.getMutations()), HashUtils.hashMutationList(rowMutationB.getMutations()));
    }

    public static List<String> hashMutationList(List<Mutation> mutationList) throws Exception {
        ArrayList<String> mutations = new ArrayList<String>();
        for (Mutation mutation : mutationList) {
            ArrayList<String> cells = new ArrayList<String>();
            CellScanner scanner = mutation.cellScanner();
            while (scanner.advance()) {
                Cell c = scanner.current();
                String mutationType = "";
                long ts = 0L;
                if (KeyValue.Type.codeToType((byte)c.getTypeByte()).equals((Object)KeyValue.Type.DeleteFamily)) {
                    mutationType = "DELETE_FAMILY";
                    ts = 0L;
                } else if (KeyValue.Type.codeToType((byte)c.getTypeByte()).equals((Object)KeyValue.Type.DeleteColumn)) {
                    mutationType = "DELETE_COLUMN";
                    ts = c.getTimestamp();
                } else if (KeyValue.Type.codeToType((byte)c.getTypeByte()).equals((Object)KeyValue.Type.Put)) {
                    mutationType = "PUT";
                    ts = c.getTimestamp();
                } else {
                    throw new Exception("hashMutationList error: Cell type is not supported.");
                }
                String cellHash = String.join((CharSequence)"_", mutationType, Long.toString(ts), Bytes.toString((byte[])CellUtil.cloneRow((Cell)c)), Bytes.toString((byte[])CellUtil.cloneFamily((Cell)c)), Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)c)), Bytes.toString((byte[])CellUtil.cloneValue((Cell)c)));
                cells.add(cellHash);
            }
            mutations.add(String.join((CharSequence)" > ", cells));
        }
        return mutations;
    }

    static class HashHbaseRowMutationsFn
    extends DoFn<KV<byte[], RowMutations>, KV<String, List<String>>> {
        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            RowMutations rowMutations = (RowMutations)((KV)c.element()).getValue();
            if (!Bytes.equals((byte[])((byte[])((KV)c.element()).getKey()), (byte[])rowMutations.getRow())) {
                throw new Exception("Hash error, KV rowkey is not the same as rowMutations rowkey");
            }
            c.output((Object)KV.of((Object)Bytes.toString((byte[])rowMutations.getRow()), HashUtils.hashMutationList(rowMutations.getMutations())));
        }
    }

    public static class HashHbaseRowMutations
    extends PTransform<PCollection<KV<byte[], RowMutations>>, PCollection<KV<String, List<String>>>> {
        public PCollection<KV<String, List<String>>> expand(PCollection<KV<byte[], RowMutations>> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new HashHbaseRowMutationsFn()));
        }
    }
}

