/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.hadoop.SerializableConfiguration;
import org.apache.beam.sdk.io.hbase.HBaseReadSplittableDoFn;
import org.apache.beam.sdk.io.hbase.HBaseResultCoder;
import org.apache.beam.sdk.io.hbase.HBaseSharedConnection;
import org.apache.beam.sdk.io.hbase.HBaseUtils;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.io.range.ByteKeyRangeTracker;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(HBaseIO.class);

    private HBaseIO() {
    }

    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new Read(null, "", new Scan());
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadAll readAll() {
        return new ReadAll();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new Write(null, "");
    }

    public static @UnknownKeyFor @NonNull @Initialized WriteRowMutations writeRowMutations() {
        return new WriteRowMutations(null, "");
    }

    public static class WriteRowMutations
    extends PTransform<PCollection<KV<byte[], RowMutations>>, PDone> {
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final @UnknownKeyFor @NonNull @Initialized Configuration configuration;
        private final @UnknownKeyFor @NonNull @Initialized String tableId;

        public @UnknownKeyFor @NonNull @Initialized WriteRowMutations withConfiguration(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
            Preconditions.checkNotNull((Object)configuration, (Object)"configuration cannot be null");
            return new WriteRowMutations(configuration, this.tableId);
        }

        public @UnknownKeyFor @NonNull @Initialized WriteRowMutations withTableId(@UnknownKeyFor @NonNull @Initialized String tableId) {
            Preconditions.checkNotNull((Object)tableId, (Object)"tableId cannot be null");
            return new WriteRowMutations(this.configuration, tableId);
        }

        private WriteRowMutations(@UnknownKeyFor @NonNull @Initialized Configuration configuration, @UnknownKeyFor @NonNull @Initialized String tableId) {
            this.configuration = configuration;
            this.tableId = tableId;
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized RowMutations>> input) {
            Preconditions.checkNotNull((Object)this.configuration, (Object)"withConfiguration() is required");
            Preconditions.checkNotNull((Object)this.tableId, (Object)"withTableId() is required");
            Preconditions.checkArgument((!this.tableId.isEmpty() ? 1 : 0) != 0, (Object)"withTableId() cannot be empty");
            input.apply((PTransform)ParDo.of((DoFn)new WriteRowMutationsFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"configuration", (String)this.configuration.toString()));
            builder.add(DisplayData.item((String)"tableId", (String)this.tableId));
        }

        public @UnknownKeyFor @NonNull @Initialized Configuration getConfiguration() {
            return this.configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized String getTableId() {
            return this.tableId;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            WriteRowMutations writeRowMutations = (WriteRowMutations)((Object)o);
            return this.configuration.toString().equals(writeRowMutations.configuration.toString()) && Objects.equals(this.tableId, writeRowMutations.tableId);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.configuration, this.tableId);
        }

        private @UnknownKeyFor @NonNull @Initialized Object writeReplace() {
            return new SerializationProxy(this);
        }

        private class WriteRowMutationsFn
        extends DoFn<KV<byte[], RowMutations>, Integer> {
            private @UnknownKeyFor @NonNull @Initialized long recordsWritten;
            private transient @UnknownKeyFor @NonNull @Initialized Connection connection;
            private transient @UnknownKeyFor @NonNull @Initialized Table table;

            public WriteRowMutationsFn(WriteRowMutations writeRowMutations2) {
                Preconditions.checkNotNull((Object)writeRowMutations2.tableId, (Object)"tableId");
                Preconditions.checkNotNull((Object)writeRowMutations2.configuration, (Object)"configuration");
            }

            @DoFn.Setup
            public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.connection = HBaseSharedConnection.getOrCreate(WriteRowMutations.this.configuration);
            }

            @DoFn.StartBundle
            public void startBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.table = this.connection.getTable(TableName.valueOf((String)WriteRowMutations.this.tableId));
                this.recordsWritten = 0L;
            }

            @DoFn.FinishBundle
            public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
                if (this.table != null) {
                    this.table.close();
                    this.table = null;
                }
                LOG.debug("Wrote {} records", (Object)this.recordsWritten);
            }

            @DoFn.Teardown
            public void tearDown() throws @UnknownKeyFor @NonNull @Initialized Exception {
                if (this.table != null) {
                    this.table.close();
                    this.table = null;
                }
                HBaseSharedConnection.close(WriteRowMutations.this.configuration);
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IOException {
                RowMutations mutations = (RowMutations)((KV)c.element()).getValue();
                try {
                    this.table.mutateRow(mutations);
                    ++this.recordsWritten;
                }
                catch (IOException e) {
                    throw new RuntimeException(String.join((CharSequence)" ", "Table", WriteRowMutations.this.tableId, "row", Bytes.toString((byte[])mutations.getRow()), "mutation failed.", "\nTable Available/Enabled:", Boolean.toString(this.connection.getAdmin().isTableAvailable(TableName.valueOf((String)WriteRowMutations.this.tableId))), Boolean.toString(this.connection.getAdmin().isTableEnabled(TableName.valueOf((String)WriteRowMutations.this.tableId))), "\nConnection Closed/Aborted/Locks:", Boolean.toString(this.connection.isClosed()), Boolean.toString(this.connection.isAborted())));
                }
            }

            public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                builder.delegate((HasDisplayData)WriteRowMutations.this);
            }
        }

        private static class SerializationProxy
        implements Serializable {
            private @UnknownKeyFor @NonNull @Initialized Configuration configuration;
            private @UnknownKeyFor @NonNull @Initialized String tableId;

            public SerializationProxy() {
            }

            public SerializationProxy(@UnknownKeyFor @NonNull @Initialized WriteRowMutations writeRowMutations) {
                this.configuration = writeRowMutations.configuration;
                this.tableId = writeRowMutations.tableId;
            }

            private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
                SerializableCoder.of(SerializableConfiguration.class).encode((Serializable)new SerializableConfiguration(this.configuration), (OutputStream)out);
                StringUtf8Coder.of().encode(this.tableId, (OutputStream)out);
            }

            private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.configuration = ((SerializableConfiguration)SerializableCoder.of(SerializableConfiguration.class).decode((InputStream)in)).get();
                this.tableId = StringUtf8Coder.of().decode((InputStream)in);
            }

            @UnknownKeyFor @NonNull @Initialized Object readResolve() {
                return HBaseIO.writeRowMutations().withConfiguration(this.configuration).withTableId(this.tableId);
            }
        }
    }

    public static class Write
    extends PTransform<PCollection<Mutation>, PDone> {
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final @UnknownKeyFor @NonNull @Initialized Configuration configuration;
        private final @UnknownKeyFor @NonNull @Initialized String tableId;

        public @UnknownKeyFor @NonNull @Initialized Write withConfiguration(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (Object)"configuration cannot be null");
            return new Write(configuration, this.tableId);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withTableId(@UnknownKeyFor @NonNull @Initialized String tableId) {
            Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId cannot be null");
            return new Write(this.configuration, tableId);
        }

        private Write(@UnknownKeyFor @NonNull @Initialized Configuration configuration, @UnknownKeyFor @NonNull @Initialized String tableId) {
            this.configuration = configuration;
            this.tableId = tableId;
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Mutation> input) {
            Preconditions.checkArgument((this.configuration != null ? 1 : 0) != 0, (Object)"withConfiguration() is required");
            Preconditions.checkArgument((this.tableId != null && !this.tableId.isEmpty() ? 1 : 0) != 0, (Object)"withTableId() is required");
            try (Connection connection = ConnectionFactory.createConnection((Configuration)this.configuration);){
                Admin admin = connection.getAdmin();
                Preconditions.checkArgument((boolean)admin.tableExists(TableName.valueOf((String)this.tableId)), (String)"Table %s does not exist", (Object)this.tableId);
            }
            catch (IOException e) {
                LOG.warn("Error checking whether table {} exists; proceeding.", (Object)this.tableId, (Object)e);
            }
            input.apply((PTransform)ParDo.of((DoFn)new HBaseWriterFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"configuration", (String)this.configuration.toString()));
            builder.add(DisplayData.item((String)"tableId", (String)this.tableId));
        }

        public @UnknownKeyFor @NonNull @Initialized Configuration getConfiguration() {
            return this.configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized String getTableId() {
            return this.tableId;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Write write = (Write)((Object)o);
            return this.configuration.toString().equals(write.configuration.toString()) && Objects.equals(this.tableId, write.tableId);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.configuration, this.tableId);
        }

        private @UnknownKeyFor @NonNull @Initialized Object writeReplace() {
            return new SerializationProxy(this);
        }

        private class HBaseWriterFn
        extends DoFn<Mutation, Void> {
            private @UnknownKeyFor @NonNull @Initialized long recordsWritten;
            private transient @UnknownKeyFor @NonNull @Initialized Connection connection;
            private transient @UnknownKeyFor @NonNull @Initialized BufferedMutator mutator;

            HBaseWriterFn(Write write2) {
                Preconditions.checkNotNull((Object)write2.tableId, (Object)"tableId");
                Preconditions.checkNotNull((Object)write2.configuration, (Object)"configuration");
            }

            @DoFn.Setup
            public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.connection = ConnectionFactory.createConnection((Configuration)Write.this.configuration);
            }

            @DoFn.StartBundle
            public void startBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) throws @UnknownKeyFor @NonNull @Initialized IOException {
                BufferedMutatorParams params = new BufferedMutatorParams(TableName.valueOf((String)Write.this.tableId));
                this.mutator = this.connection.getBufferedMutator(params);
                this.recordsWritten = 0L;
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.mutator.mutate((Mutation)c.element());
                ++this.recordsWritten;
            }

            @DoFn.FinishBundle
            public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.mutator.flush();
                LOG.debug("Wrote {} records", (Object)this.recordsWritten);
            }

            @DoFn.Teardown
            public void tearDown() throws @UnknownKeyFor @NonNull @Initialized Exception {
                if (this.mutator != null) {
                    this.mutator.close();
                    this.mutator = null;
                }
                if (this.connection != null) {
                    this.connection.close();
                    this.connection = null;
                }
            }

            public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                builder.delegate((HasDisplayData)Write.this);
            }
        }

        private static class SerializationProxy
        implements Serializable {
            private @UnknownKeyFor @NonNull @Initialized Configuration configuration;
            private @UnknownKeyFor @NonNull @Initialized String tableId;

            public SerializationProxy() {
            }

            public SerializationProxy(@UnknownKeyFor @NonNull @Initialized Write write) {
                this.configuration = write.configuration;
                this.tableId = write.tableId;
            }

            private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
                SerializableCoder.of(SerializableConfiguration.class).encode((Serializable)new SerializableConfiguration(this.configuration), (OutputStream)out);
                StringUtf8Coder.of().encode(this.tableId, (OutputStream)out);
            }

            private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.configuration = ((SerializableConfiguration)SerializableCoder.of(SerializableConfiguration.class).decode((InputStream)in)).get();
                this.tableId = StringUtf8Coder.of().decode((InputStream)in);
            }

            @UnknownKeyFor @NonNull @Initialized Object readResolve() {
                return HBaseIO.write().withConfiguration(this.configuration).withTableId(this.tableId);
            }
        }
    }

    private static class HBaseReader
    extends BoundedSource.BoundedReader<Result> {
        private @UnknownKeyFor @NonNull @Initialized HBaseSource source;
        private @UnknownKeyFor @NonNull @Initialized Connection connection;
        private @UnknownKeyFor @NonNull @Initialized ResultScanner scanner;
        private @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Result> iter;
        private @UnknownKeyFor @NonNull @Initialized Result current;
        private final @UnknownKeyFor @NonNull @Initialized ByteKeyRangeTracker rangeTracker;
        private @UnknownKeyFor @NonNull @Initialized long recordsReturned;

        HBaseReader(@UnknownKeyFor @NonNull @Initialized HBaseSource source) {
            this.source = source;
            Scan scan = source.read.scan;
            ByteKeyRange range = ByteKeyRange.of((ByteKey)ByteKey.copyFrom((byte[])scan.getStartRow()), (ByteKey)ByteKey.copyFrom((byte[])scan.getStopRow()));
            this.rangeTracker = ByteKeyRangeTracker.of((ByteKeyRange)range);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            HBaseSource source = this.getCurrentSource();
            Configuration configuration = source.read.configuration;
            String tableId = source.read.tableId;
            this.connection = ConnectionFactory.createConnection((Configuration)configuration);
            TableName tableName = TableName.valueOf((String)tableId);
            Table table = this.connection.getTable(tableName);
            Scan scanClone = new Scan(source.read.scan);
            this.scanner = table.getScanner(scanClone);
            this.iter = this.scanner.iterator();
            return this.advance();
        }

        public @UnknownKeyFor @NonNull @Initialized Result getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.current;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean advance() {
            boolean hasRecord;
            if (!this.iter.hasNext()) {
                return this.rangeTracker.markDone();
            }
            Result next = this.iter.next();
            boolean bl = hasRecord = this.rangeTracker.tryReturnRecordAt(true, ByteKey.copyFrom((byte[])next.getRow())) || this.rangeTracker.markDone();
            if (hasRecord) {
                this.current = next;
                ++this.recordsReturned;
            }
            return hasRecord;
        }

        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            LOG.debug("Closing reader after reading {} records.", (Object)this.recordsReturned);
            if (this.scanner != null) {
                this.scanner.close();
                this.scanner = null;
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized HBaseSource getCurrentSource() {
            return this.source;
        }

        public final @UnknownKeyFor @NonNull @Initialized Double getFractionConsumed() {
            return this.rangeTracker.getFractionConsumed();
        }

        public final @UnknownKeyFor @NonNull @Initialized long getSplitPointsConsumed() {
            return this.rangeTracker.getSplitPointsConsumed();
        }

        public final synchronized @Nullable @UnknownKeyFor @Initialized HBaseSource splitAtFraction(@UnknownKeyFor @NonNull @Initialized double fraction) {
            HBaseSource residual;
            HBaseSource primary;
            ByteKey splitKey;
            try {
                splitKey = this.rangeTracker.getRange().interpolateKey(fraction);
            }
            catch (RuntimeException e) {
                LOG.info("{}: Failed to interpolate key for fraction {}.", new Object[]{this.rangeTracker.getRange(), fraction, e});
                return null;
            }
            LOG.info("Proposing to split {} at fraction {} (key {})", new Object[]{this.rangeTracker, fraction, splitKey});
            try {
                primary = this.source.withEndKey(splitKey);
                residual = this.source.withStartKey(splitKey);
            }
            catch (Exception e) {
                LOG.info("{}: Interpolating for fraction {} yielded invalid split key {}.", new Object[]{this.rangeTracker.getRange(), fraction, splitKey, e});
                return null;
            }
            if (!this.rangeTracker.trySplitAtPosition(splitKey)) {
                return null;
            }
            this.source = primary;
            return residual;
        }
    }

    static class HBaseSource
    extends BoundedSource<Result> {
        private final @UnknownKeyFor @NonNull @Initialized Read read;
        private @Nullable @UnknownKeyFor @Initialized Long estimatedSizeBytes;

        HBaseSource(@UnknownKeyFor @NonNull @Initialized Read read, @Nullable @UnknownKeyFor @Initialized Long estimatedSizeBytes) {
            this.read = read;
            this.estimatedSizeBytes = estimatedSizeBytes;
        }

        @UnknownKeyFor @NonNull @Initialized HBaseSource withStartKey(@UnknownKeyFor @NonNull @Initialized ByteKey startKey) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkNotNull((Object)startKey, (Object)"startKey");
            Read newRead = new Read(this.read.configuration, this.read.tableId, new Scan(this.read.scan).setStartRow(startKey.getBytes()));
            return new HBaseSource(newRead, this.estimatedSizeBytes);
        }

        @UnknownKeyFor @NonNull @Initialized HBaseSource withEndKey(@UnknownKeyFor @NonNull @Initialized ByteKey endKey) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkNotNull((Object)endKey, (Object)"endKey");
            Read newRead = new Read(this.read.configuration, this.read.tableId, new Scan(this.read.scan).setStopRow(endKey.getBytes()));
            return new HBaseSource(newRead, this.estimatedSizeBytes);
        }

        public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.estimatedSizeBytes == null) {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)this.read.configuration);){
                    this.estimatedSizeBytes = HBaseUtils.estimateSizeBytes(connection, this.read.tableId, HBaseUtils.getByteKeyRange(this.read.scan));
                }
                LOG.debug("Estimated size {} bytes for table {} and scan {}", new Object[]{this.estimatedSizeBytes, this.read.tableId, this.read.scan});
            }
            return this.estimatedSizeBytes;
        }

        public @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @NonNull @Initialized Result>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            LOG.debug("desiredBundleSize {} bytes", (Object)desiredBundleSizeBytes);
            long estimatedSizeBytes = this.getEstimatedSizeBytes(options);
            int numSplits = 1;
            if (estimatedSizeBytes > 0L && desiredBundleSizeBytes > 0L) {
                numSplits = (int)Math.ceil((double)estimatedSizeBytes / (double)desiredBundleSizeBytes);
            }
            try (Connection connection = ConnectionFactory.createConnection((Configuration)this.read.getConfiguration());){
                List<HRegionLocation> regionLocations = HBaseUtils.getRegionLocations(connection, this.read.tableId, HBaseUtils.getByteKeyRange(this.read.scan));
                LOG.debug("Suggested {} source(s) based on size", (Object)numSplits);
                LOG.debug("Suggested {} source(s) based on number of regions", (Object)regionLocations.size());
                List<ByteKeyRange> ranges = HBaseUtils.getRanges(regionLocations, this.read.tableId, HBaseUtils.getByteKeyRange(this.read.scan));
                int numSources = ranges.size();
                LOG.debug("Spliting into {} source(s)", (Object)numSources);
                if (numSources > 0) {
                    ArrayList<HBaseSource> sources = new ArrayList<HBaseSource>(numSources);
                    for (int i = 0; i < numSources; ++i) {
                        ByteKeyRange range = ranges.get(i);
                        LOG.debug("Range {}: {} - {}", new Object[]{i, range.getStartKey(), range.getEndKey()});
                        sources.add(new HBaseSource(new Read(this.read.configuration, this.read.tableId, new Scan(this.read.scan).setStartRow(range.getStartKey().getBytes()).setStopRow(range.getEndKey().getBytes())), estimatedSizeBytes));
                    }
                    ArrayList<HBaseSource> arrayList = sources;
                    return arrayList;
                }
            }
            return Collections.singletonList(this);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<@UnknownKeyFor @NonNull @Initialized Result> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            return new HBaseReader(this);
        }

        public void validate() {
            this.read.validate(null);
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.read.populateDisplayData(builder);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Result> getOutputCoder() {
            return HBaseResultCoder.of();
        }
    }

    public static class ReadAll
    extends PTransform<PCollection<Read>, PCollection<Result>> {
        private ReadAll() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Result> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Read> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new HBaseReadSplittableDoFn()));
        }
    }

    public static class Read
    extends PTransform<PBegin, PCollection<Result>> {
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final @UnknownKeyFor @NonNull @Initialized Configuration configuration;
        private final @UnknownKeyFor @NonNull @Initialized String tableId;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final @UnknownKeyFor @NonNull @Initialized Scan scan;

        public @UnknownKeyFor @NonNull @Initialized Read withConfiguration(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (Object)"configuration cannot be null");
            return new Read(new Configuration(configuration), this.tableId, this.scan);
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTableId(@UnknownKeyFor @NonNull @Initialized String tableId) {
            Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId cannot be null");
            return new Read(this.configuration, tableId, this.scan);
        }

        public @UnknownKeyFor @NonNull @Initialized Read withScan(@UnknownKeyFor @NonNull @Initialized Scan scan) {
            Preconditions.checkArgument((scan != null ? 1 : 0) != 0, (Object)"scan cannot be null");
            return new Read(this.configuration, this.tableId, scan);
        }

        public @UnknownKeyFor @NonNull @Initialized Read withFilter(@UnknownKeyFor @NonNull @Initialized Filter filter) {
            Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (Object)"filter cannot be null");
            return this.withScan(this.scan.setFilter(filter));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withKeyRange(@UnknownKeyFor @NonNull @Initialized ByteKeyRange keyRange) {
            Preconditions.checkArgument((keyRange != null ? 1 : 0) != 0, (Object)"keyRange cannot be null");
            byte[] startRow = keyRange.getStartKey().getBytes();
            byte[] stopRow = keyRange.getEndKey().getBytes();
            return this.withScan(this.scan.setStartRow(startRow).setStopRow(stopRow));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withKeyRange(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] startRow, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] stopRow) {
            Preconditions.checkArgument((startRow != null ? 1 : 0) != 0, (Object)"startRow cannot be null");
            Preconditions.checkArgument((stopRow != null ? 1 : 0) != 0, (Object)"stopRow cannot be null");
            ByteKeyRange keyRange = ByteKeyRange.of((ByteKey)ByteKey.copyFrom((byte[])startRow), (ByteKey)ByteKey.copyFrom((byte[])stopRow));
            return this.withKeyRange(keyRange);
        }

        private Read(@UnknownKeyFor @NonNull @Initialized Configuration configuration, @UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized Scan scan) {
            this.configuration = configuration;
            this.tableId = tableId;
            this.scan = scan;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Result> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkArgument((this.configuration != null ? 1 : 0) != 0, (Object)"withConfiguration() is required");
            Preconditions.checkArgument((!this.tableId.isEmpty() ? 1 : 0) != 0, (Object)"withTableId() is required");
            try (Connection connection = ConnectionFactory.createConnection((Configuration)this.configuration);){
                Admin admin = connection.getAdmin();
                Preconditions.checkArgument((boolean)admin.tableExists(TableName.valueOf((String)this.tableId)), (String)"Table %s does not exist", (Object)this.tableId);
            }
            catch (IOException e) {
                LOG.warn("Error checking whether table {} exists; proceeding.", (Object)this.tableId, (Object)e);
            }
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)new HBaseSource(this, null)));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"configuration", (String)this.configuration.toString()));
            builder.add(DisplayData.item((String)"tableId", (String)this.tableId));
            builder.addIfNotNull(DisplayData.item((String)"scan", (String)this.scan.toString()));
        }

        public @UnknownKeyFor @NonNull @Initialized Configuration getConfiguration() {
            return this.configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized String getTableId() {
            return this.tableId;
        }

        public @UnknownKeyFor @NonNull @Initialized Scan getScan() {
            return this.scan;
        }

        public @UnknownKeyFor @NonNull @Initialized ByteKeyRange getKeyRange() {
            byte[] startRow = this.scan.getStartRow();
            byte[] stopRow = this.scan.getStopRow();
            return ByteKeyRange.of((ByteKey)ByteKey.copyFrom((byte[])startRow), (ByteKey)ByteKey.copyFrom((byte[])stopRow));
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Read read = (Read)((Object)o);
            return this.configuration.toString().equals(read.configuration.toString()) && Objects.equals(this.tableId, read.tableId) && this.scan.toString().equals(read.scan.toString());
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.configuration, this.tableId, this.scan);
        }

        private @UnknownKeyFor @NonNull @Initialized Object writeReplace() {
            return new SerializationProxy(this);
        }

        private static class SerializationProxy
        implements Serializable {
            private @UnknownKeyFor @NonNull @Initialized Configuration configuration;
            private @UnknownKeyFor @NonNull @Initialized String tableId;
            private @UnknownKeyFor @NonNull @Initialized Scan scan;

            public SerializationProxy() {
            }

            public SerializationProxy(@UnknownKeyFor @NonNull @Initialized Read read) {
                this.configuration = read.configuration;
                this.tableId = read.tableId;
                this.scan = read.scan;
            }

            private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
                SerializableCoder.of(SerializableConfiguration.class).encode((Serializable)new SerializableConfiguration(this.configuration), (OutputStream)out);
                StringUtf8Coder.of().encode(this.tableId, (OutputStream)out);
                ProtobufUtil.toScan((Scan)this.scan).writeDelimitedTo((OutputStream)out);
            }

            private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.configuration = ((SerializableConfiguration)SerializableCoder.of(SerializableConfiguration.class).decode((InputStream)in)).get();
                this.tableId = StringUtf8Coder.of().decode((InputStream)in);
                this.scan = ProtobufUtil.toScan((ClientProtos.Scan)ClientProtos.Scan.parseDelimitedFrom((InputStream)in));
            }

            @UnknownKeyFor @NonNull @Initialized Object readResolve() {
                return HBaseIO.read().withConfiguration(this.configuration).withTableId(this.tableId).withScan(this.scan);
            }
        }
    }
}

