/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class HBaseMutationCoder
extends AtomicCoder<Mutation>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized HBaseMutationCoder INSTANCE = new HBaseMutationCoder();
    private static final @UnknownKeyFor @NonNull @Initialized CoderProvider HBASE_MUTATION_CODER_PROVIDER = new HBaseMutationCoderProvider();
    private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Mutation> HBASE_MUTATION_TYPE_DESCRIPTOR = new TypeDescriptor<Mutation>(){};

    private HBaseMutationCoder() {
    }

    public static @UnknownKeyFor @NonNull @Initialized HBaseMutationCoder of() {
        return INSTANCE;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized Mutation mutation, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ClientProtos.MutationProto.MutationType type = HBaseMutationCoder.getType(mutation);
        ClientProtos.MutationProto proto = ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)type, (Mutation)mutation);
        proto.writeDelimitedTo(outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized Mutation decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ProtobufUtil.toMutation((ClientProtos.MutationProto)ClientProtos.MutationProto.parseDelimitedFrom((InputStream)inStream));
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ClientProtos.MutationProto.MutationType getType(@UnknownKeyFor @NonNull @Initialized Mutation mutation) {
        if (mutation instanceof Put) {
            return ClientProtos.MutationProto.MutationType.PUT;
        }
        if (mutation instanceof Delete) {
            return ClientProtos.MutationProto.MutationType.DELETE;
        }
        throw new IllegalArgumentException("Only Put and Delete are supported");
    }

    static @UnknownKeyFor @NonNull @Initialized CoderProvider getCoderProvider() {
        return HBASE_MUTATION_CODER_PROVIDER;
    }

    private static class HBaseMutationCoderProvider
    extends CoderProvider {
        private HBaseMutationCoderProvider() {
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> componentCoders) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            if (!typeDescriptor.isSubtypeOf(HBASE_MUTATION_TYPE_DESCRIPTOR)) {
                throw new CannotProvideCoderException(String.format("Cannot provide %s because %s is not a subclass of %s", HBaseMutationCoder.class.getSimpleName(), typeDescriptor, Mutation.class.getName()));
            }
            try {
                HBaseMutationCoder coder = HBaseMutationCoder.of();
                return coder;
            }
            catch (IllegalArgumentException e) {
                throw new CannotProvideCoderException((Throwable)e);
            }
        }
    }
}

